/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.rest.server.audit;

import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.resource.Medication;
import ca.uhn.fhir.model.dstu.resource.MedicationStatement;
import ca.uhn.fhir.model.dstu.valueset.SecurityEventObjectSensitivityEnum;
import ca.uhn.fhir.model.dstu.valueset.SecurityEventObjectTypeEnum;
import ca.uhn.fhir.rest.server.audit.IResourceAuditor;
import java.util.Map;

public class MedicationStatementAuditor
implements IResourceAuditor<MedicationStatement> {
    MedicationStatement myMedicationStatement;

    public boolean isAuditable() {
        return this.myMedicationStatement != null;
    }

    public String getName() {
        if (this.myMedicationStatement != null) {
            Medication m = (Medication)this.myMedicationStatement.getMedication().getResource();
            if (m != null) {
                return "Medication Statement: " + (String)m.getName().getValue();
            }
            return "Medication Statement: " + this.myMedicationStatement.getId().getValueAsString();
        }
        return null;
    }

    public IdentifierDt getIdentifier() {
        if (this.myMedicationStatement != null) {
            return this.myMedicationStatement.getIdentifierFirstRep();
        }
        return null;
    }

    public SecurityEventObjectTypeEnum getType() {
        return SecurityEventObjectTypeEnum.OTHER;
    }

    public MedicationStatement getResource() {
        return this.myMedicationStatement;
    }

    public void setResource(MedicationStatement theMedicationPrescription) {
        this.myMedicationStatement = theMedicationPrescription;
    }

    public String getDescription() {
        return null;
    }

    public Map<String, String> getDetail() {
        return null;
    }

    public SecurityEventObjectSensitivityEnum getSensitivity() {
        return null;
    }
}

