/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum SupplyStatusEnum {
    REQUESTED("requested", "http://hl7.org/fhir/valueset-supply-status"),
    DISPENSED("dispensed", "http://hl7.org/fhir/valueset-supply-status"),
    RECEIVED("received", "http://hl7.org/fhir/valueset-supply-status"),
    FAILED("failed", "http://hl7.org/fhir/valueset-supply-status"),
    CANCELLED("cancelled", "http://hl7.org/fhir/valueset-supply-status");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/valueset-supply-status";
    public static final String VALUESET_NAME = "SupplyStatus";
    private static Map<String, SupplyStatusEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, SupplyStatusEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<SupplyStatusEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public SupplyStatusEnum forCode(String theCode) {
        SupplyStatusEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private SupplyStatusEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, SupplyStatusEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, SupplyStatusEnum>>();
        for (SupplyStatusEnum next : SupplyStatusEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<SupplyStatusEnum>(){

            public String toCodeString(SupplyStatusEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(SupplyStatusEnum theEnum) {
                return theEnum.getSystem();
            }

            public SupplyStatusEnum fromCodeString(String theCodeString) {
                return (SupplyStatusEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public SupplyStatusEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (SupplyStatusEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

