/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum SupplyItemTypeEnum {
    CENTRAL_SUPPLY("medication", "http://hl7.org/fhir/supply-item-type"),
    DEVICE("device", "http://hl7.org/fhir/supply-item-type");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/supply-item";
    public static final String VALUESET_NAME = "Supply Item Type";
    private static Map<String, SupplyItemTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, SupplyItemTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<SupplyItemTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public SupplyItemTypeEnum forCode(String theCode) {
        SupplyItemTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private SupplyItemTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, SupplyItemTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, SupplyItemTypeEnum>>();
        for (SupplyItemTypeEnum next : SupplyItemTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<SupplyItemTypeEnum>(){

            public String toCodeString(SupplyItemTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(SupplyItemTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public SupplyItemTypeEnum fromCodeString(String theCodeString) {
                return (SupplyItemTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public SupplyItemTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (SupplyItemTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

