/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum SubstanceTypeEnum {

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/substance-type";
    public static final String VALUESET_NAME = "Substance Type";
    private static Map<String, SubstanceTypeEnum> CODE_TO_ENUM = new HashMap<String, SubstanceTypeEnum>();
    private static Map<String, Map<String, SubstanceTypeEnum>> SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, SubstanceTypeEnum>>();
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<SubstanceTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public SubstanceTypeEnum forCode(String theCode) {
        SubstanceTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private SubstanceTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        for (SubstanceTypeEnum next : SubstanceTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<SubstanceTypeEnum>(){

            public String toCodeString(SubstanceTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(SubstanceTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public SubstanceTypeEnum fromCodeString(String theCodeString) {
                return (SubstanceTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public SubstanceTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (SubstanceTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

