/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum SecurityEventSourceTypeEnum {
    USER_DEVICE("1", "http://hl7.org/fhir/security-source-type"),
    DATA_INTERFACE("2", "http://hl7.org/fhir/security-source-type"),
    WEB_SERVER("3", "http://hl7.org/fhir/security-source-type"),
    APPLICATION_SERVER("4", "http://hl7.org/fhir/security-source-type"),
    DATABASE_SERVER("5", "http://hl7.org/fhir/security-source-type"),
    SECURITY_SERVER("6", "http://hl7.org/fhir/security-source-type"),
    NETWORK_DEVICE("7", "http://hl7.org/fhir/security-source-type"),
    NETWORK_ROUTER("8", "http://hl7.org/fhir/security-source-type"),
    OTHER("9", "http://hl7.org/fhir/security-source-type");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/security-source-type";
    public static final String VALUESET_NAME = "Security Event Source Type";
    private static Map<String, SecurityEventSourceTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, SecurityEventSourceTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<SecurityEventSourceTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public SecurityEventSourceTypeEnum forCode(String theCode) {
        SecurityEventSourceTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private SecurityEventSourceTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, SecurityEventSourceTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, SecurityEventSourceTypeEnum>>();
        for (SecurityEventSourceTypeEnum next : SecurityEventSourceTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<SecurityEventSourceTypeEnum>(){

            public String toCodeString(SecurityEventSourceTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(SecurityEventSourceTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public SecurityEventSourceTypeEnum fromCodeString(String theCodeString) {
                return (SecurityEventSourceTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public SecurityEventSourceTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (SecurityEventSourceTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

