/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum SearchParamTypeEnum {
    NUMBER("number", "http://hl7.org/fhir/search-param-type"),
    DATE("date", "http://hl7.org/fhir/search-param-type"),
    STRING("string", "http://hl7.org/fhir/search-param-type"),
    TOKEN("token", "http://hl7.org/fhir/search-param-type"),
    REFERENCE("reference", "http://hl7.org/fhir/search-param-type"),
    COMPOSITE("composite", "http://hl7.org/fhir/search-param-type"),
    QUANTITY("quantity", "http://hl7.org/fhir/search-param-type");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/search-param-type";
    public static final String VALUESET_NAME = "SearchParamType";
    private static Map<String, SearchParamTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, SearchParamTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<SearchParamTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public SearchParamTypeEnum forCode(String theCode) {
        SearchParamTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private SearchParamTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, SearchParamTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, SearchParamTypeEnum>>();
        for (SearchParamTypeEnum next : SearchParamTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<SearchParamTypeEnum>(){

            public String toCodeString(SearchParamTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(SearchParamTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public SearchParamTypeEnum fromCodeString(String theCodeString) {
                return (SearchParamTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public SearchParamTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (SearchParamTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

