/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum RestfulSecurityServiceEnum {
    OAUTH("OAuth", "http://hl7.org/fhir/restful-security-service"),
    OAUTH2("OAuth2", "http://hl7.org/fhir/restful-security-service"),
    NTLM("NTLM", "http://hl7.org/fhir/restful-security-service"),
    BASIC("Basic", "http://hl7.org/fhir/restful-security-service"),
    KERBEROS("Kerberos", "http://hl7.org/fhir/restful-security-service");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/restful-security-service";
    public static final String VALUESET_NAME = "RestfulSecurityService";
    private static Map<String, RestfulSecurityServiceEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, RestfulSecurityServiceEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<RestfulSecurityServiceEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public RestfulSecurityServiceEnum forCode(String theCode) {
        RestfulSecurityServiceEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private RestfulSecurityServiceEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, RestfulSecurityServiceEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, RestfulSecurityServiceEnum>>();
        for (RestfulSecurityServiceEnum next : RestfulSecurityServiceEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<RestfulSecurityServiceEnum>(){

            public String toCodeString(RestfulSecurityServiceEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(RestfulSecurityServiceEnum theEnum) {
                return theEnum.getSystem();
            }

            public RestfulSecurityServiceEnum fromCodeString(String theCodeString) {
                return (RestfulSecurityServiceEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public RestfulSecurityServiceEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (RestfulSecurityServiceEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

