/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ResourceTypeEnum {
    ADVERSEREACTION("AdverseReaction", "http://hl7.org/fhir/resource-types"),
    ALERT("Alert", "http://hl7.org/fhir/resource-types"),
    ALLERGYINTOLERANCE("AllergyIntolerance", "http://hl7.org/fhir/resource-types"),
    CAREPLAN("CarePlan", "http://hl7.org/fhir/resource-types"),
    COMPOSITION("Composition", "http://hl7.org/fhir/resource-types"),
    CONCEPTMAP("ConceptMap", "http://hl7.org/fhir/resource-types"),
    CONDITION("Condition", "http://hl7.org/fhir/resource-types"),
    CONFORMANCE("Conformance", "http://hl7.org/fhir/resource-types"),
    DEVICE("Device", "http://hl7.org/fhir/resource-types"),
    DEVICEOBSERVATIONREPORT("DeviceObservationReport", "http://hl7.org/fhir/resource-types"),
    DIAGNOSTICORDER("DiagnosticOrder", "http://hl7.org/fhir/resource-types"),
    DIAGNOSTICREPORT("DiagnosticReport", "http://hl7.org/fhir/resource-types"),
    DOCUMENTMANIFEST("DocumentManifest", "http://hl7.org/fhir/resource-types"),
    DOCUMENTREFERENCE("DocumentReference", "http://hl7.org/fhir/resource-types"),
    ENCOUNTER("Encounter", "http://hl7.org/fhir/resource-types"),
    FAMILYHISTORY("FamilyHistory", "http://hl7.org/fhir/resource-types"),
    GROUP("Group", "http://hl7.org/fhir/resource-types"),
    IMAGINGSTUDY("ImagingStudy", "http://hl7.org/fhir/resource-types"),
    IMMUNIZATION("Immunization", "http://hl7.org/fhir/resource-types"),
    IMMUNIZATIONRECOMMENDATION("ImmunizationRecommendation", "http://hl7.org/fhir/resource-types"),
    LIST("List", "http://hl7.org/fhir/resource-types"),
    LOCATION("Location", "http://hl7.org/fhir/resource-types"),
    MEDIA("Media", "http://hl7.org/fhir/resource-types"),
    MEDICATION("Medication", "http://hl7.org/fhir/resource-types"),
    MEDICATIONADMINISTRATION("MedicationAdministration", "http://hl7.org/fhir/resource-types"),
    MEDICATIONDISPENSE("MedicationDispense", "http://hl7.org/fhir/resource-types"),
    MEDICATIONPRESCRIPTION("MedicationPrescription", "http://hl7.org/fhir/resource-types"),
    MEDICATIONSTATEMENT("MedicationStatement", "http://hl7.org/fhir/resource-types"),
    MESSAGEHEADER("MessageHeader", "http://hl7.org/fhir/resource-types"),
    OBSERVATION("Observation", "http://hl7.org/fhir/resource-types"),
    OPERATIONOUTCOME("OperationOutcome", "http://hl7.org/fhir/resource-types"),
    ORDER("Order", "http://hl7.org/fhir/resource-types"),
    ORDERRESPONSE("OrderResponse", "http://hl7.org/fhir/resource-types"),
    ORGANIZATION("Organization", "http://hl7.org/fhir/resource-types"),
    OTHER("Other", "http://hl7.org/fhir/resource-types"),
    PATIENT("Patient", "http://hl7.org/fhir/resource-types"),
    PRACTITIONER("Practitioner", "http://hl7.org/fhir/resource-types"),
    PROCEDURE("Procedure", "http://hl7.org/fhir/resource-types"),
    PROFILE("Profile", "http://hl7.org/fhir/resource-types"),
    PROVENANCE("Provenance", "http://hl7.org/fhir/resource-types"),
    QUERY("Query", "http://hl7.org/fhir/resource-types"),
    QUESTIONNAIRE("Questionnaire", "http://hl7.org/fhir/resource-types"),
    RELATEDPERSON("RelatedPerson", "http://hl7.org/fhir/resource-types"),
    SECURITYEVENT("SecurityEvent", "http://hl7.org/fhir/resource-types"),
    SPECIMEN("Specimen", "http://hl7.org/fhir/resource-types"),
    SUBSTANCE("Substance", "http://hl7.org/fhir/resource-types"),
    SUPPLY("Supply", "http://hl7.org/fhir/resource-types"),
    VALUESET("ValueSet", "http://hl7.org/fhir/resource-types"),
    APPOINTMENT("Appointment", "http://hl7.org/fhir/resource-types"),
    APPOINTMENTRESPONSE("AppointmentResponse", "http://hl7.org/fhir/resource-types"),
    AVAILABILITY("Availability", "http://hl7.org/fhir/resource-types"),
    BINARY("Binary", "http://hl7.org/fhir/resource-types"),
    CLAIM("Claim", "http://hl7.org/fhir/resource-types"),
    COVERAGE("Coverage", "http://hl7.org/fhir/resource-types"),
    GENEEXPRESSION("GeneExpression", "http://hl7.org/fhir/resource-types"),
    GENETICANALYSIS("GeneticAnalysis", "http://hl7.org/fhir/resource-types"),
    GVFMETA("GVFMeta", "http://hl7.org/fhir/resource-types"),
    GVFVARIANT("GVFVariant", "http://hl7.org/fhir/resource-types"),
    MICROARRAY("Microarray", "http://hl7.org/fhir/resource-types"),
    REMITTANCE("Remittance", "http://hl7.org/fhir/resource-types"),
    SEQUENCINGANALYSIS("SequencingAnalysis", "http://hl7.org/fhir/resource-types"),
    SEQUENCINGLAB("SequencingLab", "http://hl7.org/fhir/resource-types"),
    SLOT("Slot", "http://hl7.org/fhir/resource-types"),
    USER("User", "http://hl7.org/fhir/resource-types");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/resource-types";
    public static final String VALUESET_NAME = "ResourceType";
    private static Map<String, ResourceTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ResourceTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ResourceTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public ResourceTypeEnum forCode(String theCode) {
        ResourceTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ResourceTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ResourceTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ResourceTypeEnum>>();
        for (ResourceTypeEnum next : ResourceTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ResourceTypeEnum>(){

            public String toCodeString(ResourceTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ResourceTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public ResourceTypeEnum fromCodeString(String theCodeString) {
                return (ResourceTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ResourceTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ResourceTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

