/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum QueryOutcomeEnum {
    OK("ok", "http://hl7.org/fhir/query-outcome"),
    LIMITED("limited", "http://hl7.org/fhir/query-outcome"),
    REFUSED("refused", "http://hl7.org/fhir/query-outcome"),
    ERROR("error", "http://hl7.org/fhir/query-outcome");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/query-outcome";
    public static final String VALUESET_NAME = "QueryOutcome";
    private static Map<String, QueryOutcomeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, QueryOutcomeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<QueryOutcomeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public QueryOutcomeEnum forCode(String theCode) {
        QueryOutcomeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private QueryOutcomeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, QueryOutcomeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, QueryOutcomeEnum>>();
        for (QueryOutcomeEnum next : QueryOutcomeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<QueryOutcomeEnum>(){

            public String toCodeString(QueryOutcomeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(QueryOutcomeEnum theEnum) {
                return theEnum.getSystem();
            }

            public QueryOutcomeEnum fromCodeString(String theCodeString) {
                return (QueryOutcomeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public QueryOutcomeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (QueryOutcomeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

