/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ProvenanceEntityRoleEnum {
    DERIVATION("derivation", "http://hl7.org/fhir/provenance-entity-role");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/provenance-entity-role";
    public static final String VALUESET_NAME = "ProvenanceEntityRole";
    private static Map<String, ProvenanceEntityRoleEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ProvenanceEntityRoleEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ProvenanceEntityRoleEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public ProvenanceEntityRoleEnum forCode(String theCode) {
        ProvenanceEntityRoleEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ProvenanceEntityRoleEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ProvenanceEntityRoleEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ProvenanceEntityRoleEnum>>();
        for (ProvenanceEntityRoleEnum next : ProvenanceEntityRoleEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ProvenanceEntityRoleEnum>(){

            public String toCodeString(ProvenanceEntityRoleEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ProvenanceEntityRoleEnum theEnum) {
                return theEnum.getSystem();
            }

            public ProvenanceEntityRoleEnum fromCodeString(String theCodeString) {
                return (ProvenanceEntityRoleEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ProvenanceEntityRoleEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ProvenanceEntityRoleEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

