/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum PractitionerSpecialtyEnum {
    CARDIOLOGIST("cardio", "http://hl7.org/fhir/practitioner-specialty"),
    DENTIST("dent", "http://hl7.org/fhir/practitioner-specialty"),
    DIETARY_CONSULTANT("dietary", "http://hl7.org/fhir/practitioner-specialty"),
    MIDWIFE("midw", "http://hl7.org/fhir/practitioner-specialty"),
    SYSTEMS_ARCHITECT("sysarch", "http://hl7.org/fhir/practitioner-specialty");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/practitioner-specialty";
    public static final String VALUESET_NAME = "PractitionerSpecialty";
    private static Map<String, PractitionerSpecialtyEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, PractitionerSpecialtyEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<PractitionerSpecialtyEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public PractitionerSpecialtyEnum forCode(String theCode) {
        PractitionerSpecialtyEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private PractitionerSpecialtyEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, PractitionerSpecialtyEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, PractitionerSpecialtyEnum>>();
        for (PractitionerSpecialtyEnum next : PractitionerSpecialtyEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<PractitionerSpecialtyEnum>(){

            public String toCodeString(PractitionerSpecialtyEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(PractitionerSpecialtyEnum theEnum) {
                return theEnum.getSystem();
            }

            public PractitionerSpecialtyEnum fromCodeString(String theCodeString) {
                return (PractitionerSpecialtyEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public PractitionerSpecialtyEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (PractitionerSpecialtyEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

