/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum PractitionerRoleEnum {
    DOCTOR("doctor", "http://hl7.org/fhir/practitioner-role"),
    NURSE("nurse", "http://hl7.org/fhir/practitioner-role"),
    PHARMACIST("pharmacist", "http://hl7.org/fhir/practitioner-role"),
    RESEARCHER("researcher", "http://hl7.org/fhir/practitioner-role"),
    TEACHER_EDUCATOR("teacher", "http://hl7.org/fhir/practitioner-role"),
    ICT_PROFESSIONAL("ict", "http://hl7.org/fhir/practitioner-role");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/practitioner-role";
    public static final String VALUESET_NAME = "PractitionerRole";
    private static Map<String, PractitionerRoleEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, PractitionerRoleEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<PractitionerRoleEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public PractitionerRoleEnum forCode(String theCode) {
        PractitionerRoleEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private PractitionerRoleEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, PractitionerRoleEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, PractitionerRoleEnum>>();
        for (PractitionerRoleEnum next : PractitionerRoleEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<PractitionerRoleEnum>(){

            public String toCodeString(PractitionerRoleEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(PractitionerRoleEnum theEnum) {
                return theEnum.getSystem();
            }

            public PractitionerRoleEnum fromCodeString(String theCodeString) {
                return (PractitionerRoleEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public PractitionerRoleEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (PractitionerRoleEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

