/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum OrganizationTypeEnum {
    HEALTHCARE_PROVIDER("prov", "http://hl7.org/fhir/organization-type"),
    HOSPITAL_DEPARTMENT("dept", "http://hl7.org/fhir/organization-type"),
    INTENSIVE_CARE_UNIT("icu", "http://hl7.org/fhir/organization-type"),
    ORGANIZATIONAL_TEAM("team", "http://hl7.org/fhir/organization-type"),
    FEDERAL_GOVERNMENT("fed", "http://hl7.org/fhir/organization-type"),
    INSURANCE_COMPANY("ins", "http://hl7.org/fhir/organization-type"),
    EDUCATIONAL_INSTITUTE("edu", "http://hl7.org/fhir/organization-type"),
    RELIGIOUS_INSTITUTION("reli", "http://hl7.org/fhir/organization-type"),
    PHARMACY("pharm", "http://hl7.org/fhir/organization-type");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/organization-type";
    public static final String VALUESET_NAME = "OrganizationType";
    private static Map<String, OrganizationTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, OrganizationTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<OrganizationTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public OrganizationTypeEnum forCode(String theCode) {
        OrganizationTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private OrganizationTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, OrganizationTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, OrganizationTypeEnum>>();
        for (OrganizationTypeEnum next : OrganizationTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<OrganizationTypeEnum>(){

            public String toCodeString(OrganizationTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(OrganizationTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public OrganizationTypeEnum fromCodeString(String theCodeString) {
                return (OrganizationTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public OrganizationTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (OrganizationTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

