/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ObservationInterpretationCodesEnum {

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/observation-interpretation";
    public static final String VALUESET_NAME = "Observation Interpretation Codes";
    private static Map<String, ObservationInterpretationCodesEnum> CODE_TO_ENUM = new HashMap<String, ObservationInterpretationCodesEnum>();
    private static Map<String, Map<String, ObservationInterpretationCodesEnum>> SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ObservationInterpretationCodesEnum>>();
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ObservationInterpretationCodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public ObservationInterpretationCodesEnum forCode(String theCode) {
        ObservationInterpretationCodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ObservationInterpretationCodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        for (ObservationInterpretationCodesEnum next : ObservationInterpretationCodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ObservationInterpretationCodesEnum>(){

            public String toCodeString(ObservationInterpretationCodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ObservationInterpretationCodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public ObservationInterpretationCodesEnum fromCodeString(String theCodeString) {
                return (ObservationInterpretationCodesEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ObservationInterpretationCodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ObservationInterpretationCodesEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

