/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum MessageTransportEnum {
    HTTP("http", "http://hl7.org/fhir/message-transport"),
    FTP("ftp", "http://hl7.org/fhir/message-transport"),
    MLLP("mllp", "http://hl7.org/fhir/message-transport");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/message-transport";
    public static final String VALUESET_NAME = "MessageTransport";
    private static Map<String, MessageTransportEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, MessageTransportEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<MessageTransportEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public MessageTransportEnum forCode(String theCode) {
        MessageTransportEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private MessageTransportEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, MessageTransportEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, MessageTransportEnum>>();
        for (MessageTransportEnum next : MessageTransportEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<MessageTransportEnum>(){

            public String toCodeString(MessageTransportEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(MessageTransportEnum theEnum) {
                return theEnum.getSystem();
            }

            public MessageTransportEnum fromCodeString(String theCodeString) {
                return (MessageTransportEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public MessageTransportEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (MessageTransportEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

