/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum MedicationKindEnum {
    PRODUCT("product", "http://hl7.org/fhir/medication-kind"),
    PACKAGE("package", "http://hl7.org/fhir/medication-kind");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/medication-kind";
    public static final String VALUESET_NAME = "MedicationKind";
    private static Map<String, MedicationKindEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, MedicationKindEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<MedicationKindEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public MedicationKindEnum forCode(String theCode) {
        MedicationKindEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private MedicationKindEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, MedicationKindEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, MedicationKindEnum>>();
        for (MedicationKindEnum next : MedicationKindEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<MedicationKindEnum>(){

            public String toCodeString(MedicationKindEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(MedicationKindEnum theEnum) {
                return theEnum.getSystem();
            }

            public MedicationKindEnum fromCodeString(String theCodeString) {
                return (MedicationKindEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public MedicationKindEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (MedicationKindEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

