/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum MediaTypeEnum {
    PHOTO("photo", "http://hl7.org/fhir/media-type"),
    VIDEO("video", "http://hl7.org/fhir/media-type"),
    AUDIO("audio", "http://hl7.org/fhir/media-type");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/media-type";
    public static final String VALUESET_NAME = "MediaType";
    private static Map<String, MediaTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, MediaTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<MediaTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public MediaTypeEnum forCode(String theCode) {
        MediaTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private MediaTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, MediaTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, MediaTypeEnum>>();
        for (MediaTypeEnum next : MediaTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<MediaTypeEnum>(){

            public String toCodeString(MediaTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(MediaTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public MediaTypeEnum fromCodeString(String theCodeString) {
                return (MediaTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public MediaTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (MediaTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

