/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum LocationTypeEnum {
    BUILDING("bu", "http://hl7.org/fhir/location-physical-type"),
    WING("wi", "http://hl7.org/fhir/location-physical-type"),
    CORRIDOR("co", "http://hl7.org/fhir/location-physical-type"),
    ROOM("ro", "http://hl7.org/fhir/location-physical-type"),
    VEHICLE("ve", "http://hl7.org/fhir/location-physical-type"),
    HOUSE("ho", "http://hl7.org/fhir/location-physical-type"),
    CABINET("ca", "http://hl7.org/fhir/location-physical-type"),
    ROAD("rd", "http://hl7.org/fhir/location-physical-type");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/location-physical-type";
    public static final String VALUESET_NAME = "LocationType";
    private static Map<String, LocationTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, LocationTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<LocationTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public LocationTypeEnum forCode(String theCode) {
        LocationTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private LocationTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, LocationTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, LocationTypeEnum>>();
        for (LocationTypeEnum next : LocationTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<LocationTypeEnum>(){

            public String toCodeString(LocationTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(LocationTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public LocationTypeEnum fromCodeString(String theCodeString) {
                return (LocationTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public LocationTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (LocationTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

