/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum InstanceAvailabilityEnum {
    ONLINE("ONLINE", "http://nema.org/dicom/dcid"),
    OFFLINE("OFFLINE", "http://nema.org/dicom/dcid"),
    NEARLINE("NEARLINE", "http://nema.org/dicom/dcid"),
    UNAVAILABLE("UNAVAILABLE", "http://nema.org/dicom/dcid");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/instance-availability";
    public static final String VALUESET_NAME = "InstanceAvailability";
    private static Map<String, InstanceAvailabilityEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, InstanceAvailabilityEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<InstanceAvailabilityEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public InstanceAvailabilityEnum forCode(String theCode) {
        InstanceAvailabilityEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private InstanceAvailabilityEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, InstanceAvailabilityEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, InstanceAvailabilityEnum>>();
        for (InstanceAvailabilityEnum next : InstanceAvailabilityEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<InstanceAvailabilityEnum>(){

            public String toCodeString(InstanceAvailabilityEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(InstanceAvailabilityEnum theEnum) {
                return theEnum.getSystem();
            }

            public InstanceAvailabilityEnum fromCodeString(String theCodeString) {
                return (InstanceAvailabilityEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public InstanceAvailabilityEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (InstanceAvailabilityEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

