/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum GroupTypeEnum {
    PERSON("person", "http://hl7.org/fhir/group-type"),
    ANIMAL("animal", "http://hl7.org/fhir/group-type"),
    PRACTITIONER("practitioner", "http://hl7.org/fhir/group-type"),
    DEVICE("device", "http://hl7.org/fhir/group-type"),
    MEDICATION("medication", "http://hl7.org/fhir/group-type"),
    SUBSTANCE("substance", "http://hl7.org/fhir/group-type");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/group-type";
    public static final String VALUESET_NAME = "GroupType";
    private static Map<String, GroupTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, GroupTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<GroupTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public GroupTypeEnum forCode(String theCode) {
        GroupTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private GroupTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, GroupTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, GroupTypeEnum>>();
        for (GroupTypeEnum next : GroupTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<GroupTypeEnum>(){

            public String toCodeString(GroupTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(GroupTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public GroupTypeEnum fromCodeString(String theCodeString) {
                return (GroupTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public GroupTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (GroupTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

