/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum FHIRDefinedTypeEnum {
    ADDRESS("Address", "http://hl7.org/fhir/defined-types"),
    AGE("Age", "http://hl7.org/fhir/defined-types"),
    ATTACHMENT("Attachment", "http://hl7.org/fhir/defined-types"),
    CODEABLECONCEPT("CodeableConcept", "http://hl7.org/fhir/defined-types"),
    CODING("Coding", "http://hl7.org/fhir/defined-types"),
    CONTACT("Contact", "http://hl7.org/fhir/defined-types"),
    COUNT("Count", "http://hl7.org/fhir/defined-types"),
    DISTANCE("Distance", "http://hl7.org/fhir/defined-types"),
    DURATION("Duration", "http://hl7.org/fhir/defined-types"),
    EXTENSION("Extension", "http://hl7.org/fhir/defined-types"),
    HUMANNAME("HumanName", "http://hl7.org/fhir/defined-types"),
    IDENTIFIER("Identifier", "http://hl7.org/fhir/defined-types"),
    MONEY("Money", "http://hl7.org/fhir/defined-types"),
    NARRATIVE("Narrative", "http://hl7.org/fhir/defined-types"),
    PERIOD("Period", "http://hl7.org/fhir/defined-types"),
    QUANTITY("Quantity", "http://hl7.org/fhir/defined-types"),
    RANGE("Range", "http://hl7.org/fhir/defined-types"),
    RATIO("Ratio", "http://hl7.org/fhir/defined-types"),
    RESOURCEREFERENCE("ResourceReference", "http://hl7.org/fhir/defined-types"),
    SAMPLEDDATA("SampledData", "http://hl7.org/fhir/defined-types"),
    SCHEDULE("Schedule", "http://hl7.org/fhir/defined-types"),
    BASE64BINARY("base64Binary", "http://hl7.org/fhir/defined-types"),
    BOOLEAN("boolean", "http://hl7.org/fhir/defined-types"),
    CODE("code", "http://hl7.org/fhir/defined-types"),
    DATE("date", "http://hl7.org/fhir/defined-types"),
    DATETIME("dateTime", "http://hl7.org/fhir/defined-types"),
    DECIMAL("decimal", "http://hl7.org/fhir/defined-types"),
    ID("id", "http://hl7.org/fhir/defined-types"),
    INSTANT("instant", "http://hl7.org/fhir/defined-types"),
    INTEGER("integer", "http://hl7.org/fhir/defined-types"),
    OID("oid", "http://hl7.org/fhir/defined-types"),
    STRING("string", "http://hl7.org/fhir/defined-types"),
    URI("uri", "http://hl7.org/fhir/defined-types"),
    UUID("uuid", "http://hl7.org/fhir/defined-types"),
    ADVERSEREACTION("AdverseReaction", "http://hl7.org/fhir/defined-types"),
    ALERT("Alert", "http://hl7.org/fhir/defined-types"),
    ALLERGYINTOLERANCE("AllergyIntolerance", "http://hl7.org/fhir/defined-types"),
    CAREPLAN("CarePlan", "http://hl7.org/fhir/defined-types"),
    COMPOSITION("Composition", "http://hl7.org/fhir/defined-types"),
    CONCEPTMAP("ConceptMap", "http://hl7.org/fhir/defined-types"),
    CONDITION("Condition", "http://hl7.org/fhir/defined-types"),
    CONFORMANCE("Conformance", "http://hl7.org/fhir/defined-types"),
    DEVICE("Device", "http://hl7.org/fhir/defined-types"),
    DEVICEOBSERVATIONREPORT("DeviceObservationReport", "http://hl7.org/fhir/defined-types"),
    DIAGNOSTICORDER("DiagnosticOrder", "http://hl7.org/fhir/defined-types"),
    DIAGNOSTICREPORT("DiagnosticReport", "http://hl7.org/fhir/defined-types"),
    DOCUMENTMANIFEST("DocumentManifest", "http://hl7.org/fhir/defined-types"),
    DOCUMENTREFERENCE("DocumentReference", "http://hl7.org/fhir/defined-types"),
    ENCOUNTER("Encounter", "http://hl7.org/fhir/defined-types"),
    FAMILYHISTORY("FamilyHistory", "http://hl7.org/fhir/defined-types"),
    GROUP("Group", "http://hl7.org/fhir/defined-types"),
    IMAGINGSTUDY("ImagingStudy", "http://hl7.org/fhir/defined-types"),
    IMMUNIZATION("Immunization", "http://hl7.org/fhir/defined-types"),
    IMMUNIZATIONRECOMMENDATION("ImmunizationRecommendation", "http://hl7.org/fhir/defined-types"),
    LIST("List", "http://hl7.org/fhir/defined-types"),
    LOCATION("Location", "http://hl7.org/fhir/defined-types"),
    MEDIA("Media", "http://hl7.org/fhir/defined-types"),
    MEDICATION("Medication", "http://hl7.org/fhir/defined-types"),
    MEDICATIONADMINISTRATION("MedicationAdministration", "http://hl7.org/fhir/defined-types"),
    MEDICATIONDISPENSE("MedicationDispense", "http://hl7.org/fhir/defined-types"),
    MEDICATIONPRESCRIPTION("MedicationPrescription", "http://hl7.org/fhir/defined-types"),
    MEDICATIONSTATEMENT("MedicationStatement", "http://hl7.org/fhir/defined-types"),
    MESSAGEHEADER("MessageHeader", "http://hl7.org/fhir/defined-types"),
    OBSERVATION("Observation", "http://hl7.org/fhir/defined-types"),
    OPERATIONOUTCOME("OperationOutcome", "http://hl7.org/fhir/defined-types"),
    ORDER("Order", "http://hl7.org/fhir/defined-types"),
    ORDERRESPONSE("OrderResponse", "http://hl7.org/fhir/defined-types"),
    ORGANIZATION("Organization", "http://hl7.org/fhir/defined-types"),
    OTHER("Other", "http://hl7.org/fhir/defined-types"),
    PATIENT("Patient", "http://hl7.org/fhir/defined-types"),
    PRACTITIONER("Practitioner", "http://hl7.org/fhir/defined-types"),
    PROCEDURE("Procedure", "http://hl7.org/fhir/defined-types"),
    PROFILE("Profile", "http://hl7.org/fhir/defined-types"),
    PROVENANCE("Provenance", "http://hl7.org/fhir/defined-types"),
    QUERY("Query", "http://hl7.org/fhir/defined-types"),
    QUESTIONNAIRE("Questionnaire", "http://hl7.org/fhir/defined-types"),
    RELATEDPERSON("RelatedPerson", "http://hl7.org/fhir/defined-types"),
    SECURITYEVENT("SecurityEvent", "http://hl7.org/fhir/defined-types"),
    SPECIMEN("Specimen", "http://hl7.org/fhir/defined-types"),
    SUBSTANCE("Substance", "http://hl7.org/fhir/defined-types"),
    SUPPLY("Supply", "http://hl7.org/fhir/defined-types"),
    VALUESET("ValueSet", "http://hl7.org/fhir/defined-types");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/defined-types";
    public static final String VALUESET_NAME = "FHIRDefinedType";
    private static Map<String, FHIRDefinedTypeEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, FHIRDefinedTypeEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<FHIRDefinedTypeEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public FHIRDefinedTypeEnum forCode(String theCode) {
        FHIRDefinedTypeEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private FHIRDefinedTypeEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, FHIRDefinedTypeEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, FHIRDefinedTypeEnum>>();
        for (FHIRDefinedTypeEnum next : FHIRDefinedTypeEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<FHIRDefinedTypeEnum>(){

            public String toCodeString(FHIRDefinedTypeEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(FHIRDefinedTypeEnum theEnum) {
                return theEnum.getSystem();
            }

            public FHIRDefinedTypeEnum fromCodeString(String theCodeString) {
                return (FHIRDefinedTypeEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public FHIRDefinedTypeEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (FHIRDefinedTypeEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

