/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum EventTimingEnum {
    HS("HS", "http://hl7.org/fhir/v3/TimingEvent"),
    WAKE("WAKE", "http://hl7.org/fhir/v3/TimingEvent"),
    AC("AC", "http://hl7.org/fhir/v3/TimingEvent"),
    ACM("ACM", "http://hl7.org/fhir/v3/TimingEvent"),
    ACD("ACD", "http://hl7.org/fhir/v3/TimingEvent"),
    ACV("ACV", "http://hl7.org/fhir/v3/TimingEvent"),
    PC("PC", "http://hl7.org/fhir/v3/TimingEvent"),
    PCM("PCM", "http://hl7.org/fhir/v3/TimingEvent"),
    PCD("PCD", "http://hl7.org/fhir/v3/TimingEvent"),
    PCV("PCV", "http://hl7.org/fhir/v3/TimingEvent");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/event-timing";
    public static final String VALUESET_NAME = "EventTiming";
    private static Map<String, EventTimingEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, EventTimingEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<EventTimingEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public EventTimingEnum forCode(String theCode) {
        EventTimingEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private EventTimingEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, EventTimingEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, EventTimingEnum>>();
        for (EventTimingEnum next : EventTimingEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<EventTimingEnum>(){

            public String toCodeString(EventTimingEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(EventTimingEnum theEnum) {
                return theEnum.getSystem();
            }

            public EventTimingEnum fromCodeString(String theCodeString) {
                return (EventTimingEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public EventTimingEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (EventTimingEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

