/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum EncounterReasonCodesEnum {

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/encounter-reason";
    public static final String VALUESET_NAME = "Encounter Reason Codes";
    private static Map<String, EncounterReasonCodesEnum> CODE_TO_ENUM = new HashMap<String, EncounterReasonCodesEnum>();
    private static Map<String, Map<String, EncounterReasonCodesEnum>> SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, EncounterReasonCodesEnum>>();
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<EncounterReasonCodesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public EncounterReasonCodesEnum forCode(String theCode) {
        EncounterReasonCodesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private EncounterReasonCodesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        for (EncounterReasonCodesEnum next : EncounterReasonCodesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<EncounterReasonCodesEnum>(){

            public String toCodeString(EncounterReasonCodesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(EncounterReasonCodesEnum theEnum) {
                return theEnum.getSystem();
            }

            public EncounterReasonCodesEnum fromCodeString(String theCodeString) {
                return (EncounterReasonCodesEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public EncounterReasonCodesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (EncounterReasonCodesEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

