/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum CriticalityEnum {
    FATAL("fatal", "http://hl7.org/fhir/criticality"),
    HIGH("high", "http://hl7.org/fhir/criticality"),
    MEDIUM("medium", "http://hl7.org/fhir/criticality"),
    LOW("low", "http://hl7.org/fhir/criticality");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/criticality";
    public static final String VALUESET_NAME = "Criticality";
    private static Map<String, CriticalityEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, CriticalityEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<CriticalityEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public CriticalityEnum forCode(String theCode) {
        CriticalityEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private CriticalityEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, CriticalityEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, CriticalityEnum>>();
        for (CriticalityEnum next : CriticalityEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<CriticalityEnum>(){

            public String toCodeString(CriticalityEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(CriticalityEnum theEnum) {
                return theEnum.getSystem();
            }

            public CriticalityEnum fromCodeString(String theCodeString) {
                return (CriticalityEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public CriticalityEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (CriticalityEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

