/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ContactUseEnum {
    HOME("home", "http://hl7.org/fhir/contact-use"),
    WORK("work", "http://hl7.org/fhir/contact-use"),
    TEMP("temp", "http://hl7.org/fhir/contact-use"),
    OLD("old", "http://hl7.org/fhir/contact-use"),
    MOBILE("mobile", "http://hl7.org/fhir/contact-use");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/contact-use";
    public static final String VALUESET_NAME = "ContactUse";
    private static Map<String, ContactUseEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ContactUseEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ContactUseEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public ContactUseEnum forCode(String theCode) {
        ContactUseEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ContactUseEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ContactUseEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ContactUseEnum>>();
        for (ContactUseEnum next : ContactUseEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ContactUseEnum>(){

            public String toCodeString(ContactUseEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ContactUseEnum theEnum) {
                return theEnum.getSystem();
            }

            public ContactUseEnum fromCodeString(String theCodeString) {
                return (ContactUseEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ContactUseEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ContactUseEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

