/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum ConditionStatusEnum {
    PROVISIONAL("provisional", "http://hl7.org/fhir/condition-status"),
    WORKING("working", "http://hl7.org/fhir/condition-status"),
    CONFIRMED("confirmed", "http://hl7.org/fhir/condition-status"),
    REFUTED("refuted", "http://hl7.org/fhir/condition-status");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/condition-status";
    public static final String VALUESET_NAME = "ConditionStatus";
    private static Map<String, ConditionStatusEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, ConditionStatusEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<ConditionStatusEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public ConditionStatusEnum forCode(String theCode) {
        ConditionStatusEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private ConditionStatusEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, ConditionStatusEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, ConditionStatusEnum>>();
        for (ConditionStatusEnum next : ConditionStatusEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<ConditionStatusEnum>(){

            public String toCodeString(ConditionStatusEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(ConditionStatusEnum theEnum) {
                return theEnum.getSystem();
            }

            public ConditionStatusEnum fromCodeString(String theCodeString) {
                return (ConditionStatusEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public ConditionStatusEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (ConditionStatusEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

