/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum BindingConformanceEnum {
    REQUIRED("required", "http://hl7.org/fhir/binding-conformance"),
    PREFERRED("preferred", "http://hl7.org/fhir/binding-conformance"),
    EXAMPLE("example", "http://hl7.org/fhir/binding-conformance");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/binding-conformance";
    public static final String VALUESET_NAME = "BindingConformance";
    private static Map<String, BindingConformanceEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, BindingConformanceEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<BindingConformanceEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public BindingConformanceEnum forCode(String theCode) {
        BindingConformanceEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private BindingConformanceEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, BindingConformanceEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, BindingConformanceEnum>>();
        for (BindingConformanceEnum next : BindingConformanceEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<BindingConformanceEnum>(){

            public String toCodeString(BindingConformanceEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(BindingConformanceEnum theEnum) {
                return theEnum.getSystem();
            }

            public BindingConformanceEnum fromCodeString(String theCodeString) {
                return (BindingConformanceEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public BindingConformanceEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (BindingConformanceEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

