/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum AnimalSpeciesEnum {
    DOG("canislf", "http://hl7.org/fhir/animal-species"),
    SHEEP("ovisa", "http://hl7.org/fhir/animal-species"),
    DOMESTIC_CANARY("serinuscd", "http://hl7.org/fhir/animal-species");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/animal-species";
    public static final String VALUESET_NAME = "AnimalSpecies";
    private static Map<String, AnimalSpeciesEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, AnimalSpeciesEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<AnimalSpeciesEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public AnimalSpeciesEnum forCode(String theCode) {
        AnimalSpeciesEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private AnimalSpeciesEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, AnimalSpeciesEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, AnimalSpeciesEnum>>();
        for (AnimalSpeciesEnum next : AnimalSpeciesEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<AnimalSpeciesEnum>(){

            public String toCodeString(AnimalSpeciesEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(AnimalSpeciesEnum theEnum) {
                return theEnum.getSystem();
            }

            public AnimalSpeciesEnum fromCodeString(String theCodeString) {
                return (AnimalSpeciesEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public AnimalSpeciesEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (AnimalSpeciesEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

