/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.valueset;

import ca.uhn.fhir.model.api.IValueSetEnumBinder;
import java.util.HashMap;
import java.util.Map;

public enum AlertStatusEnum {
    ACTIVE("active", "http://hl7.org/fhir/alert-status"),
    INACTIVE("inactive", "http://hl7.org/fhir/alert-status"),
    ENTERED_IN_ERROR("entered in error", "http://hl7.org/fhir/alert-status");

    public static final String VALUESET_IDENTIFIER = "http://hl7.org/fhir/vs/alert-status";
    public static final String VALUESET_NAME = "AlertStatus";
    private static Map<String, AlertStatusEnum> CODE_TO_ENUM;
    private static Map<String, Map<String, AlertStatusEnum>> SYSTEM_TO_CODE_TO_ENUM;
    private final String myCode;
    private final String mySystem;
    public static final IValueSetEnumBinder<AlertStatusEnum> VALUESET_BINDER;

    public String getCode() {
        return this.myCode;
    }

    public String getSystem() {
        return this.mySystem;
    }

    public AlertStatusEnum forCode(String theCode) {
        AlertStatusEnum retVal = CODE_TO_ENUM.get(theCode);
        return retVal;
    }

    private AlertStatusEnum(String theCode, String theSystem) {
        this.myCode = theCode;
        this.mySystem = theSystem;
    }

    static {
        CODE_TO_ENUM = new HashMap<String, AlertStatusEnum>();
        SYSTEM_TO_CODE_TO_ENUM = new HashMap<String, Map<String, AlertStatusEnum>>();
        for (AlertStatusEnum next : AlertStatusEnum.values()) {
            CODE_TO_ENUM.put(next.getCode(), next);
            if (!SYSTEM_TO_CODE_TO_ENUM.containsKey(next.getSystem())) {
                SYSTEM_TO_CODE_TO_ENUM.put(next.getSystem(), new HashMap());
            }
            SYSTEM_TO_CODE_TO_ENUM.get(next.getSystem()).put(next.getCode(), next);
        }
        VALUESET_BINDER = new IValueSetEnumBinder<AlertStatusEnum>(){

            public String toCodeString(AlertStatusEnum theEnum) {
                return theEnum.getCode();
            }

            public String toSystemString(AlertStatusEnum theEnum) {
                return theEnum.getSystem();
            }

            public AlertStatusEnum fromCodeString(String theCodeString) {
                return (AlertStatusEnum)((Object)CODE_TO_ENUM.get(theCodeString));
            }

            public AlertStatusEnum fromCodeString(String theCodeString, String theSystemString) {
                Map map = (Map)SYSTEM_TO_CODE_TO_ENUM.get(theSystemString);
                if (map == null) {
                    return null;
                }
                return (AlertStatusEnum)((Object)map.get(theCodeString));
            }
        };
    }
}

