/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.ContactDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.valueset.ContactUseEnum;
import ca.uhn.fhir.model.dstu.valueset.FilterOperatorEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.ValueSetStatusEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="ValueSet", profile="http://hl7.org/fhir/profiles/ValueSet", id="valueset")
public class ValueSet
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="ValueSet.identifier", description="The identifier of the value set", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="version", path="ValueSet.version", description="The version identifier of the value set", type="token")
    public static final String SP_VERSION = "version";
    public static final TokenClientParam VERSION = new TokenClientParam("version");
    @SearchParamDefinition(name="name", path="ValueSet.name", description="The name of the value set", type="string")
    public static final String SP_NAME = "name";
    public static final StringClientParam NAME = new StringClientParam("name");
    @SearchParamDefinition(name="publisher", path="ValueSet.publisher", description="Name of the publisher of the value set", type="string")
    public static final String SP_PUBLISHER = "publisher";
    public static final StringClientParam PUBLISHER = new StringClientParam("publisher");
    @SearchParamDefinition(name="description", path="ValueSet.description", description="Text search in the description of the value set", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="status", path="ValueSet.status", description="The status of the value set", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="date", path="ValueSet.date", description="The value set publication date", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="system", path="ValueSet.define.system", description="The system for any codes defined by this value set", type="token")
    public static final String SP_SYSTEM = "system";
    public static final TokenClientParam SYSTEM = new TokenClientParam("system");
    @SearchParamDefinition(name="code", path="ValueSet.define.concept.code", description="A code defined in the value set", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @SearchParamDefinition(name="reference", path="ValueSet.compose.include.system", description="A code system included or excluded in the value set or an imported value set", type="token")
    public static final String SP_REFERENCE = "reference";
    public static final TokenClientParam REFERENCE = new TokenClientParam("reference");
    @Child(name="identifier", type={StringDt.class}, order=0, min=0, max=1)
    @Description(shortDefinition="Logical id to reference this value set", formalDefinition="The identifier that is used to identify this value set when it is referenced in a specification, model, design or an instance (should be globally unique OID, UUID, or URI)")
    private StringDt myIdentifier;
    @Child(name="version", type={StringDt.class}, order=1, min=0, max=1)
    @Description(shortDefinition="Logical id for this version of the value set", formalDefinition="The identifier that is used to identify this version of the value set when it is referenced in a specification, model, design or instance. This is an arbitrary value managed by the profile author manually and the value should be a timestamp")
    private StringDt myVersion;
    @Child(name="name", type={StringDt.class}, order=2, min=1, max=1)
    @Description(shortDefinition="Informal name for this value set", formalDefinition="A free text natural language name describing the value set")
    private StringDt myName;
    @Child(name="publisher", type={StringDt.class}, order=3, min=0, max=1)
    @Description(shortDefinition="Name of the publisher (Organization or individual)", formalDefinition="The name of the individual or organization that published the value set")
    private StringDt myPublisher;
    @Child(name="telecom", type={ContactDt.class}, order=4, min=0, max=-1)
    @Description(shortDefinition="Contact information of the publisher", formalDefinition="Contacts of the publisher to assist a user in finding and communicating with the publisher")
    private List<ContactDt> myTelecom;
    @Child(name="description", type={StringDt.class}, order=5, min=1, max=1)
    @Description(shortDefinition="Human language description of the value set", formalDefinition="A free text natural language description of the use of the value set - reason for definition, conditions of use, etc.")
    private StringDt myDescription;
    @Child(name="copyright", type={StringDt.class}, order=6, min=0, max=1)
    @Description(shortDefinition="About the value set or its content", formalDefinition="A copyright statement relating to the value set and/or its contents")
    private StringDt myCopyright;
    @Child(name="status", type={CodeDt.class}, order=7, min=1, max=1)
    @Description(shortDefinition="draft | active | retired", formalDefinition="The status of the value set")
    private BoundCodeDt<ValueSetStatusEnum> myStatus;
    @Child(name="experimental", type={BooleanDt.class}, order=8, min=0, max=1)
    @Description(shortDefinition="If for testing purposes, not real usage", formalDefinition="This valueset was authored for testing purposes (or education/evaluation/marketing), and is not intended to be used for genuine usage")
    private BooleanDt myExperimental;
    @Child(name="extensible", type={BooleanDt.class}, order=9, min=0, max=1)
    @Description(shortDefinition="Whether this is intended to be used with an extensible binding", formalDefinition="Whether this is intended to be used with an extensible binding or not")
    private BooleanDt myExtensible;
    @Child(name="date", type={DateTimeDt.class}, order=10, min=0, max=1)
    @Description(shortDefinition="Date for given status", formalDefinition="The date that the value set status was last changed")
    private DateTimeDt myDate;
    @Child(name="define", order=11, min=0, max=1)
    @Description(shortDefinition="When value set defines its own codes", formalDefinition="")
    private Define myDefine;
    @Child(name="compose", order=12, min=0, max=1)
    @Description(shortDefinition="When value set includes codes from elsewhere", formalDefinition="")
    private Compose myCompose;
    @Child(name="expansion", order=13, min=0, max=1)
    @Description(shortDefinition="When value set is an expansion", formalDefinition="")
    private Expansion myExpansion;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myVersion, this.myName, this.myPublisher, this.myTelecom, this.myDescription, this.myCopyright, this.myStatus, this.myExperimental, this.myExtensible, this.myDate, this.myDefine, this.myCompose, this.myExpansion});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myVersion, this.myName, this.myPublisher, this.myTelecom, this.myDescription, this.myCopyright, this.myStatus, this.myExperimental, this.myExtensible, this.myDate, this.myDefine, this.myCompose, this.myExpansion});
    }

    public StringDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new StringDt();
        }
        return this.myIdentifier;
    }

    public StringDt getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new StringDt();
        }
        return this.myIdentifier;
    }

    public ValueSet setIdentifier(StringDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public ValueSet setIdentifier(String theString) {
        this.myIdentifier = new StringDt(theString);
        return this;
    }

    public StringDt getVersion() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public StringDt getVersionElement() {
        if (this.myVersion == null) {
            this.myVersion = new StringDt();
        }
        return this.myVersion;
    }

    public ValueSet setVersion(StringDt theValue) {
        this.myVersion = theValue;
        return this;
    }

    public ValueSet setVersion(String theString) {
        this.myVersion = new StringDt(theString);
        return this;
    }

    public StringDt getName() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public ValueSet setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public ValueSet setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public StringDt getPublisher() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public StringDt getPublisherElement() {
        if (this.myPublisher == null) {
            this.myPublisher = new StringDt();
        }
        return this.myPublisher;
    }

    public ValueSet setPublisher(StringDt theValue) {
        this.myPublisher = theValue;
        return this;
    }

    public ValueSet setPublisher(String theString) {
        this.myPublisher = new StringDt(theString);
        return this;
    }

    public List<ContactDt> getTelecom() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        return this.myTelecom;
    }

    public List<ContactDt> getTelecomElement() {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        return this.myTelecom;
    }

    public ValueSet setTelecom(List<ContactDt> theValue) {
        this.myTelecom = theValue;
        return this;
    }

    public ContactDt addTelecom() {
        ContactDt newType = new ContactDt();
        this.getTelecom().add(newType);
        return newType;
    }

    public ContactDt getTelecomFirstRep() {
        if (this.getTelecom().isEmpty()) {
            return this.addTelecom();
        }
        return this.getTelecom().get(0);
    }

    public ValueSet addTelecom(ContactUseEnum theContactUse, String theValue) {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        this.myTelecom.add(new ContactDt(theContactUse, theValue));
        return this;
    }

    public ValueSet addTelecom(String theValue) {
        if (this.myTelecom == null) {
            this.myTelecom = new ArrayList<ContactDt>();
        }
        this.myTelecom.add(new ContactDt(theValue));
        return this;
    }

    public StringDt getDescription() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public ValueSet setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public ValueSet setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public StringDt getCopyright() {
        if (this.myCopyright == null) {
            this.myCopyright = new StringDt();
        }
        return this.myCopyright;
    }

    public StringDt getCopyrightElement() {
        if (this.myCopyright == null) {
            this.myCopyright = new StringDt();
        }
        return this.myCopyright;
    }

    public ValueSet setCopyright(StringDt theValue) {
        this.myCopyright = theValue;
        return this;
    }

    public ValueSet setCopyright(String theString) {
        this.myCopyright = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<ValueSetStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ValueSetStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<ValueSetStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(ValueSetStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public ValueSet setStatus(BoundCodeDt<ValueSetStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public ValueSet setStatus(ValueSetStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public BooleanDt getExperimental() {
        if (this.myExperimental == null) {
            this.myExperimental = new BooleanDt();
        }
        return this.myExperimental;
    }

    public BooleanDt getExperimentalElement() {
        if (this.myExperimental == null) {
            this.myExperimental = new BooleanDt();
        }
        return this.myExperimental;
    }

    public ValueSet setExperimental(BooleanDt theValue) {
        this.myExperimental = theValue;
        return this;
    }

    public ValueSet setExperimental(boolean theBoolean) {
        this.myExperimental = new BooleanDt(theBoolean);
        return this;
    }

    public BooleanDt getExtensible() {
        if (this.myExtensible == null) {
            this.myExtensible = new BooleanDt();
        }
        return this.myExtensible;
    }

    public BooleanDt getExtensibleElement() {
        if (this.myExtensible == null) {
            this.myExtensible = new BooleanDt();
        }
        return this.myExtensible;
    }

    public ValueSet setExtensible(BooleanDt theValue) {
        this.myExtensible = theValue;
        return this;
    }

    public ValueSet setExtensible(boolean theBoolean) {
        this.myExtensible = new BooleanDt(theBoolean);
        return this;
    }

    public DateTimeDt getDate() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public ValueSet setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public ValueSet setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public ValueSet setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public Define getDefine() {
        if (this.myDefine == null) {
            this.myDefine = new Define();
        }
        return this.myDefine;
    }

    public Define getDefineElement() {
        if (this.myDefine == null) {
            this.myDefine = new Define();
        }
        return this.myDefine;
    }

    public ValueSet setDefine(Define theValue) {
        this.myDefine = theValue;
        return this;
    }

    public Compose getCompose() {
        if (this.myCompose == null) {
            this.myCompose = new Compose();
        }
        return this.myCompose;
    }

    public Compose getComposeElement() {
        if (this.myCompose == null) {
            this.myCompose = new Compose();
        }
        return this.myCompose;
    }

    public ValueSet setCompose(Compose theValue) {
        this.myCompose = theValue;
        return this;
    }

    public Expansion getExpansion() {
        if (this.myExpansion == null) {
            this.myExpansion = new Expansion();
        }
        return this.myExpansion;
    }

    public Expansion getExpansionElement() {
        if (this.myExpansion == null) {
            this.myExpansion = new Expansion();
        }
        return this.myExpansion;
    }

    public ValueSet setExpansion(Expansion theValue) {
        this.myExpansion = theValue;
        return this;
    }

    public String getResourceName() {
        return "ValueSet";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class ExpansionContains
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="system", type={UriDt.class}, order=0, min=0, max=1)
        @Description(shortDefinition="System value for the code", formalDefinition="")
        private UriDt mySystem;
        @Child(name="code", type={CodeDt.class}, order=1, min=0, max=1)
        @Description(shortDefinition="Code - if blank, this is not a choosable code", formalDefinition="")
        private CodeDt myCode;
        @Child(name="display", type={StringDt.class}, order=2, min=0, max=1)
        @Description(shortDefinition="User display for the concept", formalDefinition="")
        private StringDt myDisplay;
        @Child(name="contains", type={ExpansionContains.class}, order=3, min=0, max=-1)
        @Description(shortDefinition="Codes contained in this concept", formalDefinition="")
        private List<ExpansionContains> myContains;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySystem, this.myCode, this.myDisplay, this.myContains});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySystem, this.myCode, this.myDisplay, this.myContains});
        }

        public UriDt getSystem() {
            if (this.mySystem == null) {
                this.mySystem = new UriDt();
            }
            return this.mySystem;
        }

        public UriDt getSystemElement() {
            if (this.mySystem == null) {
                this.mySystem = new UriDt();
            }
            return this.mySystem;
        }

        public ExpansionContains setSystem(UriDt theValue) {
            this.mySystem = theValue;
            return this;
        }

        public ExpansionContains setSystem(String theUri) {
            this.mySystem = new UriDt(theUri);
            return this;
        }

        public CodeDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeDt();
            }
            return this.myCode;
        }

        public CodeDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeDt();
            }
            return this.myCode;
        }

        public ExpansionContains setCode(CodeDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public ExpansionContains setCode(String theCode) {
            this.myCode = new CodeDt(theCode);
            return this;
        }

        public StringDt getDisplay() {
            if (this.myDisplay == null) {
                this.myDisplay = new StringDt();
            }
            return this.myDisplay;
        }

        public StringDt getDisplayElement() {
            if (this.myDisplay == null) {
                this.myDisplay = new StringDt();
            }
            return this.myDisplay;
        }

        public ExpansionContains setDisplay(StringDt theValue) {
            this.myDisplay = theValue;
            return this;
        }

        public ExpansionContains setDisplay(String theString) {
            this.myDisplay = new StringDt(theString);
            return this;
        }

        public List<ExpansionContains> getContains() {
            if (this.myContains == null) {
                this.myContains = new ArrayList<ExpansionContains>();
            }
            return this.myContains;
        }

        public List<ExpansionContains> getContainsElement() {
            if (this.myContains == null) {
                this.myContains = new ArrayList<ExpansionContains>();
            }
            return this.myContains;
        }

        public ExpansionContains setContains(List<ExpansionContains> theValue) {
            this.myContains = theValue;
            return this;
        }

        public ExpansionContains addContains() {
            ExpansionContains newType = new ExpansionContains();
            this.getContains().add(newType);
            return newType;
        }

        public ExpansionContains getContainsFirstRep() {
            if (this.getContains().isEmpty()) {
                return this.addContains();
            }
            return this.getContains().get(0);
        }
    }

    @Block
    public static class Expansion
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1)
        @Description(shortDefinition="Uniquely identifies this expansion", formalDefinition="An identifier that uniquely identifies this expansion of the valueset. Systems may re-use the same identifier as long as the expansion and the definition remain the same, but are not required to do so")
        private IdentifierDt myIdentifier;
        @Child(name="timestamp", type={InstantDt.class}, order=1, min=1, max=1)
        @Description(shortDefinition="Time valueset expansion happened", formalDefinition="")
        private InstantDt myTimestamp;
        @Child(name="contains", order=2, min=0, max=-1)
        @Description(shortDefinition="Codes in the value set", formalDefinition="")
        private List<ExpansionContains> myContains;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myTimestamp, this.myContains});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myTimestamp, this.myContains});
        }

        public IdentifierDt getIdentifier() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public IdentifierDt getIdentifierElement() {
            if (this.myIdentifier == null) {
                this.myIdentifier = new IdentifierDt();
            }
            return this.myIdentifier;
        }

        public Expansion setIdentifier(IdentifierDt theValue) {
            this.myIdentifier = theValue;
            return this;
        }

        public Expansion setIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
            this.myIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
            return this;
        }

        public Expansion setIdentifier(String theSystem, String theValue) {
            this.myIdentifier = new IdentifierDt(theSystem, theValue);
            return this;
        }

        public InstantDt getTimestamp() {
            if (this.myTimestamp == null) {
                this.myTimestamp = new InstantDt();
            }
            return this.myTimestamp;
        }

        public InstantDt getTimestampElement() {
            if (this.myTimestamp == null) {
                this.myTimestamp = new InstantDt();
            }
            return this.myTimestamp;
        }

        public Expansion setTimestamp(InstantDt theValue) {
            this.myTimestamp = theValue;
            return this;
        }

        public Expansion setTimestampWithMillisPrecision(Date theDate) {
            this.myTimestamp = new InstantDt(theDate);
            return this;
        }

        public Expansion setTimestamp(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myTimestamp = new InstantDt(theDate, thePrecision);
            return this;
        }

        public List<ExpansionContains> getContains() {
            if (this.myContains == null) {
                this.myContains = new ArrayList<ExpansionContains>();
            }
            return this.myContains;
        }

        public List<ExpansionContains> getContainsElement() {
            if (this.myContains == null) {
                this.myContains = new ArrayList<ExpansionContains>();
            }
            return this.myContains;
        }

        public Expansion setContains(List<ExpansionContains> theValue) {
            this.myContains = theValue;
            return this;
        }

        public ExpansionContains addContains() {
            ExpansionContains newType = new ExpansionContains();
            this.getContains().add(newType);
            return newType;
        }

        public ExpansionContains getContainsFirstRep() {
            if (this.getContains().isEmpty()) {
                return this.addContains();
            }
            return this.getContains().get(0);
        }
    }

    @Block
    public static class ComposeIncludeFilter
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="property", type={CodeDt.class}, order=0, min=1, max=1)
        @Description(shortDefinition="", formalDefinition="A code that identifies a property defined in the code system")
        private CodeDt myProperty;
        @Child(name="op", type={CodeDt.class}, order=1, min=1, max=1)
        @Description(shortDefinition="= | is-a | is-not-a | regex | in | not in", formalDefinition="The kind of operation to perform as a part of the filter criteria")
        private BoundCodeDt<FilterOperatorEnum> myOp;
        @Child(name="value", type={CodeDt.class}, order=2, min=1, max=1)
        @Description(shortDefinition="Code from the system, or regex criteria", formalDefinition="The match value may be either a code defined by the system, or a string value which is used a regex match on the literal string of the property value")
        private CodeDt myValue;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myProperty, this.myOp, this.myValue});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myProperty, this.myOp, this.myValue});
        }

        public CodeDt getProperty() {
            if (this.myProperty == null) {
                this.myProperty = new CodeDt();
            }
            return this.myProperty;
        }

        public CodeDt getPropertyElement() {
            if (this.myProperty == null) {
                this.myProperty = new CodeDt();
            }
            return this.myProperty;
        }

        public ComposeIncludeFilter setProperty(CodeDt theValue) {
            this.myProperty = theValue;
            return this;
        }

        public ComposeIncludeFilter setProperty(String theCode) {
            this.myProperty = new CodeDt(theCode);
            return this;
        }

        public BoundCodeDt<FilterOperatorEnum> getOp() {
            if (this.myOp == null) {
                this.myOp = new BoundCodeDt(FilterOperatorEnum.VALUESET_BINDER);
            }
            return this.myOp;
        }

        public BoundCodeDt<FilterOperatorEnum> getOpElement() {
            if (this.myOp == null) {
                this.myOp = new BoundCodeDt(FilterOperatorEnum.VALUESET_BINDER);
            }
            return this.myOp;
        }

        public ComposeIncludeFilter setOp(BoundCodeDt<FilterOperatorEnum> theValue) {
            this.myOp = theValue;
            return this;
        }

        public ComposeIncludeFilter setOp(FilterOperatorEnum theValue) {
            this.getOp().setValueAsEnum((Enum)theValue);
            return this;
        }

        public CodeDt getValue() {
            if (this.myValue == null) {
                this.myValue = new CodeDt();
            }
            return this.myValue;
        }

        public CodeDt getValueElement() {
            if (this.myValue == null) {
                this.myValue = new CodeDt();
            }
            return this.myValue;
        }

        public ComposeIncludeFilter setValue(CodeDt theValue) {
            this.myValue = theValue;
            return this;
        }

        public ComposeIncludeFilter setValue(String theCode) {
            this.myValue = new CodeDt(theCode);
            return this;
        }
    }

    @Block
    public static class ComposeInclude
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="system", type={UriDt.class}, order=0, min=1, max=1)
        @Description(shortDefinition="The system the codes come from", formalDefinition="The code system from which the selected codes come from")
        private UriDt mySystem;
        @Child(name="version", type={StringDt.class}, order=1, min=0, max=1)
        @Description(shortDefinition="Specific version of the code system referred to", formalDefinition="The version of the code system that the codes are selected from")
        private StringDt myVersion;
        @Child(name="code", type={CodeDt.class}, order=2, min=0, max=-1)
        @Description(shortDefinition="Code or concept from system", formalDefinition="Specifies a code or concept to be included or excluded. The list of codes is considered ordered, though the order may not have any particular significance")
        private List<CodeDt> myCode;
        @Child(name="filter", order=3, min=0, max=-1)
        @Description(shortDefinition="Select codes/concepts by their properties (including relationships)", formalDefinition="Select concepts by specify a matching criteria based on the properties (including relationships) defined by the system. If multiple filters are specified, they SHALL all be true.")
        private List<ComposeIncludeFilter> myFilter;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySystem, this.myVersion, this.myCode, this.myFilter});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySystem, this.myVersion, this.myCode, this.myFilter});
        }

        public UriDt getSystem() {
            if (this.mySystem == null) {
                this.mySystem = new UriDt();
            }
            return this.mySystem;
        }

        public UriDt getSystemElement() {
            if (this.mySystem == null) {
                this.mySystem = new UriDt();
            }
            return this.mySystem;
        }

        public ComposeInclude setSystem(UriDt theValue) {
            this.mySystem = theValue;
            return this;
        }

        public ComposeInclude setSystem(String theUri) {
            this.mySystem = new UriDt(theUri);
            return this;
        }

        public StringDt getVersion() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public StringDt getVersionElement() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public ComposeInclude setVersion(StringDt theValue) {
            this.myVersion = theValue;
            return this;
        }

        public ComposeInclude setVersion(String theString) {
            this.myVersion = new StringDt(theString);
            return this;
        }

        public List<CodeDt> getCode() {
            if (this.myCode == null) {
                this.myCode = new ArrayList<CodeDt>();
            }
            return this.myCode;
        }

        public List<CodeDt> getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new ArrayList<CodeDt>();
            }
            return this.myCode;
        }

        public ComposeInclude setCode(List<CodeDt> theValue) {
            this.myCode = theValue;
            return this;
        }

        public CodeDt addCode() {
            CodeDt newType = new CodeDt();
            this.getCode().add(newType);
            return newType;
        }

        public CodeDt getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                return this.addCode();
            }
            return this.getCode().get(0);
        }

        public ComposeInclude addCode(String theCode) {
            if (this.myCode == null) {
                this.myCode = new ArrayList<CodeDt>();
            }
            this.myCode.add(new CodeDt(theCode));
            return this;
        }

        public List<ComposeIncludeFilter> getFilter() {
            if (this.myFilter == null) {
                this.myFilter = new ArrayList<ComposeIncludeFilter>();
            }
            return this.myFilter;
        }

        public List<ComposeIncludeFilter> getFilterElement() {
            if (this.myFilter == null) {
                this.myFilter = new ArrayList<ComposeIncludeFilter>();
            }
            return this.myFilter;
        }

        public ComposeInclude setFilter(List<ComposeIncludeFilter> theValue) {
            this.myFilter = theValue;
            return this;
        }

        public ComposeIncludeFilter addFilter() {
            ComposeIncludeFilter newType = new ComposeIncludeFilter();
            this.getFilter().add(newType);
            return newType;
        }

        public ComposeIncludeFilter getFilterFirstRep() {
            if (this.getFilter().isEmpty()) {
                return this.addFilter();
            }
            return this.getFilter().get(0);
        }
    }

    @Block
    public static class Compose
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="import", type={UriDt.class}, order=0, min=0, max=-1)
        @Description(shortDefinition="Import the contents of another value set", formalDefinition="Includes the contents of the referenced value set as a part of the contents of this value set")
        private List<UriDt> myImport;
        @Child(name="include", order=1, min=0, max=-1)
        @Description(shortDefinition="Include one or more codes from a code system", formalDefinition="Include one or more codes from a code system")
        private List<ComposeInclude> myInclude;
        @Child(name="exclude", type={ComposeInclude.class}, order=2, min=0, max=-1)
        @Description(shortDefinition="Explicitly exclude codes", formalDefinition="Exclude one or more codes from the value set")
        private List<ComposeInclude> myExclude;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myImport, this.myInclude, this.myExclude});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myImport, this.myInclude, this.myExclude});
        }

        public List<UriDt> getImport() {
            if (this.myImport == null) {
                this.myImport = new ArrayList<UriDt>();
            }
            return this.myImport;
        }

        public List<UriDt> getImportElement() {
            if (this.myImport == null) {
                this.myImport = new ArrayList<UriDt>();
            }
            return this.myImport;
        }

        public Compose setImport(List<UriDt> theValue) {
            this.myImport = theValue;
            return this;
        }

        public UriDt addImport() {
            UriDt newType = new UriDt();
            this.getImport().add(newType);
            return newType;
        }

        public UriDt getImportFirstRep() {
            if (this.getImport().isEmpty()) {
                return this.addImport();
            }
            return this.getImport().get(0);
        }

        public Compose addImport(String theUri) {
            if (this.myImport == null) {
                this.myImport = new ArrayList<UriDt>();
            }
            this.myImport.add(new UriDt(theUri));
            return this;
        }

        public List<ComposeInclude> getInclude() {
            if (this.myInclude == null) {
                this.myInclude = new ArrayList<ComposeInclude>();
            }
            return this.myInclude;
        }

        public List<ComposeInclude> getIncludeElement() {
            if (this.myInclude == null) {
                this.myInclude = new ArrayList<ComposeInclude>();
            }
            return this.myInclude;
        }

        public Compose setInclude(List<ComposeInclude> theValue) {
            this.myInclude = theValue;
            return this;
        }

        public ComposeInclude addInclude() {
            ComposeInclude newType = new ComposeInclude();
            this.getInclude().add(newType);
            return newType;
        }

        public ComposeInclude getIncludeFirstRep() {
            if (this.getInclude().isEmpty()) {
                return this.addInclude();
            }
            return this.getInclude().get(0);
        }

        public List<ComposeInclude> getExclude() {
            if (this.myExclude == null) {
                this.myExclude = new ArrayList<ComposeInclude>();
            }
            return this.myExclude;
        }

        public List<ComposeInclude> getExcludeElement() {
            if (this.myExclude == null) {
                this.myExclude = new ArrayList<ComposeInclude>();
            }
            return this.myExclude;
        }

        public Compose setExclude(List<ComposeInclude> theValue) {
            this.myExclude = theValue;
            return this;
        }

        public ComposeInclude addExclude() {
            ComposeInclude newType = new ComposeInclude();
            this.getExclude().add(newType);
            return newType;
        }

        public ComposeInclude getExcludeFirstRep() {
            if (this.getExclude().isEmpty()) {
                return this.addExclude();
            }
            return this.getExclude().get(0);
        }
    }

    @Block
    public static class DefineConcept
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeDt.class}, order=0, min=1, max=1)
        @Description(shortDefinition="Code that identifies concept", formalDefinition="")
        private CodeDt myCode;
        @Child(name="abstract", type={BooleanDt.class}, order=1, min=0, max=1)
        @Description(shortDefinition="If this code is not for use as a real concept", formalDefinition="If this code is not for use as a real concept")
        private BooleanDt myAbstract;
        @Child(name="display", type={StringDt.class}, order=2, min=0, max=1)
        @Description(shortDefinition="Text to Display to the user", formalDefinition="")
        private StringDt myDisplay;
        @Child(name="definition", type={StringDt.class}, order=3, min=0, max=1)
        @Description(shortDefinition="Formal Definition", formalDefinition="The formal definition of the concept. Formal definitions are not required, because of the prevalence of legacy systems without them, but they are highly recommended, as without them there is no formal meaning associated with the concept")
        private StringDt myDefinition;
        @Child(name="concept", type={DefineConcept.class}, order=4, min=0, max=-1)
        @Description(shortDefinition="Child Concepts (is-a / contains)", formalDefinition="")
        private List<DefineConcept> myConcept;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCode, this.myAbstract, this.myDisplay, this.myDefinition, this.myConcept});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myAbstract, this.myDisplay, this.myDefinition, this.myConcept});
        }

        public CodeDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeDt();
            }
            return this.myCode;
        }

        public CodeDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeDt();
            }
            return this.myCode;
        }

        public DefineConcept setCode(CodeDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public DefineConcept setCode(String theCode) {
            this.myCode = new CodeDt(theCode);
            return this;
        }

        public BooleanDt getAbstract() {
            if (this.myAbstract == null) {
                this.myAbstract = new BooleanDt();
            }
            return this.myAbstract;
        }

        public BooleanDt getAbstractElement() {
            if (this.myAbstract == null) {
                this.myAbstract = new BooleanDt();
            }
            return this.myAbstract;
        }

        public DefineConcept setAbstract(BooleanDt theValue) {
            this.myAbstract = theValue;
            return this;
        }

        public DefineConcept setAbstract(boolean theBoolean) {
            this.myAbstract = new BooleanDt(theBoolean);
            return this;
        }

        public StringDt getDisplay() {
            if (this.myDisplay == null) {
                this.myDisplay = new StringDt();
            }
            return this.myDisplay;
        }

        public StringDt getDisplayElement() {
            if (this.myDisplay == null) {
                this.myDisplay = new StringDt();
            }
            return this.myDisplay;
        }

        public DefineConcept setDisplay(StringDt theValue) {
            this.myDisplay = theValue;
            return this;
        }

        public DefineConcept setDisplay(String theString) {
            this.myDisplay = new StringDt(theString);
            return this;
        }

        public StringDt getDefinition() {
            if (this.myDefinition == null) {
                this.myDefinition = new StringDt();
            }
            return this.myDefinition;
        }

        public StringDt getDefinitionElement() {
            if (this.myDefinition == null) {
                this.myDefinition = new StringDt();
            }
            return this.myDefinition;
        }

        public DefineConcept setDefinition(StringDt theValue) {
            this.myDefinition = theValue;
            return this;
        }

        public DefineConcept setDefinition(String theString) {
            this.myDefinition = new StringDt(theString);
            return this;
        }

        public List<DefineConcept> getConcept() {
            if (this.myConcept == null) {
                this.myConcept = new ArrayList<DefineConcept>();
            }
            return this.myConcept;
        }

        public List<DefineConcept> getConceptElement() {
            if (this.myConcept == null) {
                this.myConcept = new ArrayList<DefineConcept>();
            }
            return this.myConcept;
        }

        public DefineConcept setConcept(List<DefineConcept> theValue) {
            this.myConcept = theValue;
            return this;
        }

        public DefineConcept addConcept() {
            DefineConcept newType = new DefineConcept();
            this.getConcept().add(newType);
            return newType;
        }

        public DefineConcept getConceptFirstRep() {
            if (this.getConcept().isEmpty()) {
                return this.addConcept();
            }
            return this.getConcept().get(0);
        }
    }

    @Block
    public static class Define
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="system", type={UriDt.class}, order=0, min=1, max=1)
        @Description(shortDefinition="URI to identify the code system", formalDefinition="")
        private UriDt mySystem;
        @Child(name="version", type={StringDt.class}, order=1, min=0, max=1)
        @Description(shortDefinition="Version of this system", formalDefinition="The version of this code system that defines the codes. Note that the version is optional because a well maintained code system does not suffer from versioning, and therefore the version does not need to be maintained. However many code systems are not well maintained, and the version needs to be defined and tracked")
        private StringDt myVersion;
        @Child(name="caseSensitive", type={BooleanDt.class}, order=2, min=0, max=1)
        @Description(shortDefinition="If code comparison is case sensitive", formalDefinition="If code comparison is case sensitive when codes within this system are compared to each other")
        private BooleanDt myCaseSensitive;
        @Child(name="concept", order=3, min=0, max=-1)
        @Description(shortDefinition="Concepts in the code system", formalDefinition="")
        private List<DefineConcept> myConcept;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySystem, this.myVersion, this.myCaseSensitive, this.myConcept});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySystem, this.myVersion, this.myCaseSensitive, this.myConcept});
        }

        public UriDt getSystem() {
            if (this.mySystem == null) {
                this.mySystem = new UriDt();
            }
            return this.mySystem;
        }

        public UriDt getSystemElement() {
            if (this.mySystem == null) {
                this.mySystem = new UriDt();
            }
            return this.mySystem;
        }

        public Define setSystem(UriDt theValue) {
            this.mySystem = theValue;
            return this;
        }

        public Define setSystem(String theUri) {
            this.mySystem = new UriDt(theUri);
            return this;
        }

        public StringDt getVersion() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public StringDt getVersionElement() {
            if (this.myVersion == null) {
                this.myVersion = new StringDt();
            }
            return this.myVersion;
        }

        public Define setVersion(StringDt theValue) {
            this.myVersion = theValue;
            return this;
        }

        public Define setVersion(String theString) {
            this.myVersion = new StringDt(theString);
            return this;
        }

        public BooleanDt getCaseSensitive() {
            if (this.myCaseSensitive == null) {
                this.myCaseSensitive = new BooleanDt();
            }
            return this.myCaseSensitive;
        }

        public BooleanDt getCaseSensitiveElement() {
            if (this.myCaseSensitive == null) {
                this.myCaseSensitive = new BooleanDt();
            }
            return this.myCaseSensitive;
        }

        public Define setCaseSensitive(BooleanDt theValue) {
            this.myCaseSensitive = theValue;
            return this;
        }

        public Define setCaseSensitive(boolean theBoolean) {
            this.myCaseSensitive = new BooleanDt(theBoolean);
            return this;
        }

        public List<DefineConcept> getConcept() {
            if (this.myConcept == null) {
                this.myConcept = new ArrayList<DefineConcept>();
            }
            return this.myConcept;
        }

        public List<DefineConcept> getConceptElement() {
            if (this.myConcept == null) {
                this.myConcept = new ArrayList<DefineConcept>();
            }
            return this.myConcept;
        }

        public Define setConcept(List<DefineConcept> theValue) {
            this.myConcept = theValue;
            return this;
        }

        public DefineConcept addConcept() {
            DefineConcept newType = new DefineConcept();
            this.getConcept().add(newType);
            return newType;
        }

        public DefineConcept getConceptFirstRep() {
            if (this.getConcept().isEmpty()) {
                return this.addConcept();
            }
            return this.getConcept().get(0);
        }
    }
}

