/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.Availability;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Slot", profile="http://hl7.org/fhir/profiles/Slot", id="slot")
public class Slot
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="slottype", path="Slot.type", description="The type of appointments that can be booked into the slot", type="token")
    public static final String SP_SLOTTYPE = "slottype";
    public static final TokenClientParam SLOTTYPE = new TokenClientParam("slottype");
    @SearchParamDefinition(name="availability", path="Slot.availability", description="The Availability Resource that we are seeking a slot within", type="reference")
    public static final String SP_AVAILABILITY = "availability";
    public static final ReferenceClientParam AVAILABILITY = new ReferenceClientParam("availability");
    public static final Include INCLUDE_AVAILABILITY = new Include("Slot.availability");
    @SearchParamDefinition(name="start", path="Slot.start", description="Appointment date/time.", type="date")
    public static final String SP_START = "start";
    public static final DateClientParam START = new DateClientParam("start");
    @SearchParamDefinition(name="fbtype", path="Slot.freeBusyType", description="The free/busy status of the appointment", type="token")
    public static final String SP_FBTYPE = "fbtype";
    public static final TokenClientParam FBTYPE = new TokenClientParam("fbtype");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1)
    @Description(shortDefinition="External Ids for this item", formalDefinition="")
    private List<IdentifierDt> myIdentifier;
    @Child(name="type", type={CodeableConceptDt.class}, order=1, min=0, max=1)
    @Description(shortDefinition="The type of appointments that can be booked into this slot (ideally this would be an identifiable service - which is at a location, rather than the location itself). If provided then this overrides the value provided on the availability resource", formalDefinition="")
    private CodeableConceptDt myType;
    @Child(name="availability", order=2, min=1, max=1, type={Availability.class})
    @Description(shortDefinition="The availability resource that this slot defines an interval of status information", formalDefinition="")
    private ResourceReferenceDt myAvailability;
    @Child(name="freeBusyType", type={CodeDt.class}, order=3, min=1, max=1)
    @Description(shortDefinition="BUSY | FREE | BUSY-UNAVAILABLE | BUSY-TENTATIVE", formalDefinition="")
    private CodeDt myFreeBusyType;
    @Child(name="start", type={InstantDt.class}, order=4, min=1, max=1)
    @Description(shortDefinition="Date/Time that the slot is to begin", formalDefinition="")
    private InstantDt myStart;
    @Child(name="end", type={InstantDt.class}, order=5, min=1, max=1)
    @Description(shortDefinition="Date/Time that the slot is to conclude", formalDefinition="")
    private InstantDt myEnd;
    @Child(name="comment", type={StringDt.class}, order=6, min=0, max=1)
    @Description(shortDefinition="Comments on the slot to describe any extended information. Such as custom constraints on the slot", formalDefinition="")
    private StringDt myComment;
    @Child(name="author", order=7, min=0, max=1, type={Practitioner.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="Who authored the slot", formalDefinition="")
    private ResourceReferenceDt myAuthor;
    @Child(name="authorDate", type={DateTimeDt.class}, order=8, min=0, max=1)
    @Description(shortDefinition="When this slot was created, or last revised", formalDefinition="")
    private DateTimeDt myAuthorDate;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myType, this.myAvailability, this.myFreeBusyType, this.myStart, this.myEnd, this.myComment, this.myAuthor, this.myAuthorDate});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myType, this.myAvailability, this.myFreeBusyType, this.myStart, this.myEnd, this.myComment, this.myAuthor, this.myAuthorDate});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Slot setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Slot addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public Slot addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public CodeableConceptDt getTypeElement() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public Slot setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public ResourceReferenceDt getAvailability() {
        if (this.myAvailability == null) {
            this.myAvailability = new ResourceReferenceDt();
        }
        return this.myAvailability;
    }

    public ResourceReferenceDt getAvailabilityElement() {
        if (this.myAvailability == null) {
            this.myAvailability = new ResourceReferenceDt();
        }
        return this.myAvailability;
    }

    public Slot setAvailability(ResourceReferenceDt theValue) {
        this.myAvailability = theValue;
        return this;
    }

    public CodeDt getFreeBusyType() {
        if (this.myFreeBusyType == null) {
            this.myFreeBusyType = new CodeDt();
        }
        return this.myFreeBusyType;
    }

    public CodeDt getFreeBusyTypeElement() {
        if (this.myFreeBusyType == null) {
            this.myFreeBusyType = new CodeDt();
        }
        return this.myFreeBusyType;
    }

    public Slot setFreeBusyType(CodeDt theValue) {
        this.myFreeBusyType = theValue;
        return this;
    }

    public Slot setFreeBusyType(String theCode) {
        this.myFreeBusyType = new CodeDt(theCode);
        return this;
    }

    public InstantDt getStart() {
        if (this.myStart == null) {
            this.myStart = new InstantDt();
        }
        return this.myStart;
    }

    public InstantDt getStartElement() {
        if (this.myStart == null) {
            this.myStart = new InstantDt();
        }
        return this.myStart;
    }

    public Slot setStart(InstantDt theValue) {
        this.myStart = theValue;
        return this;
    }

    public Slot setStartWithMillisPrecision(Date theDate) {
        this.myStart = new InstantDt(theDate);
        return this;
    }

    public Slot setStart(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myStart = new InstantDt(theDate, thePrecision);
        return this;
    }

    public InstantDt getEnd() {
        if (this.myEnd == null) {
            this.myEnd = new InstantDt();
        }
        return this.myEnd;
    }

    public InstantDt getEndElement() {
        if (this.myEnd == null) {
            this.myEnd = new InstantDt();
        }
        return this.myEnd;
    }

    public Slot setEnd(InstantDt theValue) {
        this.myEnd = theValue;
        return this;
    }

    public Slot setEndWithMillisPrecision(Date theDate) {
        this.myEnd = new InstantDt(theDate);
        return this;
    }

    public Slot setEnd(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myEnd = new InstantDt(theDate, thePrecision);
        return this;
    }

    public StringDt getComment() {
        if (this.myComment == null) {
            this.myComment = new StringDt();
        }
        return this.myComment;
    }

    public StringDt getCommentElement() {
        if (this.myComment == null) {
            this.myComment = new StringDt();
        }
        return this.myComment;
    }

    public Slot setComment(StringDt theValue) {
        this.myComment = theValue;
        return this;
    }

    public Slot setComment(String theString) {
        this.myComment = new StringDt(theString);
        return this;
    }

    public ResourceReferenceDt getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public ResourceReferenceDt getAuthorElement() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public Slot setAuthor(ResourceReferenceDt theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public DateTimeDt getAuthorDate() {
        if (this.myAuthorDate == null) {
            this.myAuthorDate = new DateTimeDt();
        }
        return this.myAuthorDate;
    }

    public DateTimeDt getAuthorDateElement() {
        if (this.myAuthorDate == null) {
            this.myAuthorDate = new DateTimeDt();
        }
        return this.myAuthorDate;
    }

    public Slot setAuthorDate(DateTimeDt theValue) {
        this.myAuthorDate = theValue;
        return this;
    }

    public Slot setAuthorDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myAuthorDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Slot setAuthorDateWithSecondsPrecision(Date theDate) {
        this.myAuthorDate = new DateTimeDt(theDate);
        return this;
    }

    public String getResourceName() {
        return "Slot";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }
}

