/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.SequencingLab;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="SequencingAnalysis", profile="http://hl7.org/fhir/profiles/SequencingAnalysis", id="sequencinganalysis")
public class SequencingAnalysis
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="subject", path="SequencingAnalysis.subject", description="Subject of the analysis", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("SequencingAnalysis.subject");
    @SearchParamDefinition(name="date", path="SequencingAnalysis.date", description="Date when result of the analysis is updated", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="genome", path="SequencingAnalysis.genome.name", description="Name of the reference genome used in the analysis", type="string")
    public static final String SP_GENOME = "genome";
    public static final StringClientParam GENOME = new StringClientParam("genome");
    @Child(name="subject", order=0, min=0, max=1, type={Patient.class})
    @Description(shortDefinition="Subject", formalDefinition="Subject of the analysis")
    private ResourceReferenceDt mySubject;
    @Child(name="date", type={DateDt.class}, order=1, min=1, max=1)
    @Description(shortDefinition="Date", formalDefinition="Date when result of the analysis is updated")
    private DateDt myDate;
    @Child(name="name", type={StringDt.class}, order=2, min=1, max=1)
    @Description(shortDefinition="Name", formalDefinition="Name of the analysis")
    private StringDt myName;
    @Child(name="genome", order=3, min=1, max=1)
    @Description(shortDefinition="Reference genome", formalDefinition="Reference genome used in the analysis")
    private Genome myGenome;
    @Child(name="file", type={AttachmentDt.class}, order=4, min=0, max=-1)
    @Description(shortDefinition="File", formalDefinition="Files uploaded as result of the analysis")
    private List<AttachmentDt> myFile;
    @Child(name="inputLab", order=5, min=0, max=-1, type={SequencingLab.class})
    @Description(shortDefinition="Input lab", formalDefinition="SequencingLab taken into account of the analysis")
    private List<ResourceReferenceDt> myInputLab;
    @Child(name="inputAnalysis", order=6, min=0, max=-1, type={SequencingAnalysis.class})
    @Description(shortDefinition="Input analysis", formalDefinition="SequencingAnalysis taken into account of the analysis")
    private List<ResourceReferenceDt> myInputAnalysis;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySubject, this.myDate, this.myName, this.myGenome, this.myFile, this.myInputLab, this.myInputAnalysis});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySubject, this.myDate, this.myName, this.myGenome, this.myFile, this.myInputLab, this.myInputAnalysis});
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public SequencingAnalysis setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public DateDt getDate() {
        if (this.myDate == null) {
            this.myDate = new DateDt();
        }
        return this.myDate;
    }

    public DateDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateDt();
        }
        return this.myDate;
    }

    public SequencingAnalysis setDate(DateDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public SequencingAnalysis setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateDt(theDate, thePrecision);
        return this;
    }

    public SequencingAnalysis setDateWithDayPrecision(Date theDate) {
        this.myDate = new DateDt(theDate);
        return this;
    }

    public StringDt getName() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public StringDt getNameElement() {
        if (this.myName == null) {
            this.myName = new StringDt();
        }
        return this.myName;
    }

    public SequencingAnalysis setName(StringDt theValue) {
        this.myName = theValue;
        return this;
    }

    public SequencingAnalysis setName(String theString) {
        this.myName = new StringDt(theString);
        return this;
    }

    public Genome getGenome() {
        if (this.myGenome == null) {
            this.myGenome = new Genome();
        }
        return this.myGenome;
    }

    public Genome getGenomeElement() {
        if (this.myGenome == null) {
            this.myGenome = new Genome();
        }
        return this.myGenome;
    }

    public SequencingAnalysis setGenome(Genome theValue) {
        this.myGenome = theValue;
        return this;
    }

    public List<AttachmentDt> getFile() {
        if (this.myFile == null) {
            this.myFile = new ArrayList<AttachmentDt>();
        }
        return this.myFile;
    }

    public List<AttachmentDt> getFileElement() {
        if (this.myFile == null) {
            this.myFile = new ArrayList<AttachmentDt>();
        }
        return this.myFile;
    }

    public SequencingAnalysis setFile(List<AttachmentDt> theValue) {
        this.myFile = theValue;
        return this;
    }

    public AttachmentDt addFile() {
        AttachmentDt newType = new AttachmentDt();
        this.getFile().add(newType);
        return newType;
    }

    public AttachmentDt getFileFirstRep() {
        if (this.getFile().isEmpty()) {
            return this.addFile();
        }
        return this.getFile().get(0);
    }

    public List<ResourceReferenceDt> getInputLab() {
        if (this.myInputLab == null) {
            this.myInputLab = new ArrayList<ResourceReferenceDt>();
        }
        return this.myInputLab;
    }

    public List<ResourceReferenceDt> getInputLabElement() {
        if (this.myInputLab == null) {
            this.myInputLab = new ArrayList<ResourceReferenceDt>();
        }
        return this.myInputLab;
    }

    public SequencingAnalysis setInputLab(List<ResourceReferenceDt> theValue) {
        this.myInputLab = theValue;
        return this;
    }

    public ResourceReferenceDt addInputLab() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getInputLab().add(newType);
        return newType;
    }

    public List<ResourceReferenceDt> getInputAnalysis() {
        if (this.myInputAnalysis == null) {
            this.myInputAnalysis = new ArrayList<ResourceReferenceDt>();
        }
        return this.myInputAnalysis;
    }

    public List<ResourceReferenceDt> getInputAnalysisElement() {
        if (this.myInputAnalysis == null) {
            this.myInputAnalysis = new ArrayList<ResourceReferenceDt>();
        }
        return this.myInputAnalysis;
    }

    public SequencingAnalysis setInputAnalysis(List<ResourceReferenceDt> theValue) {
        this.myInputAnalysis = theValue;
        return this;
    }

    public ResourceReferenceDt addInputAnalysis() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getInputAnalysis().add(newType);
        return newType;
    }

    public String getResourceName() {
        return "SequencingAnalysis";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Genome
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={CodeDt.class}, order=0, min=1, max=1)
        @Description(shortDefinition="Name", formalDefinition="Name of the reference genome")
        private CodeDt myName;
        @Child(name="build", type={StringDt.class}, order=1, min=1, max=1)
        @Description(shortDefinition="Build", formalDefinition="Build number of the refernece genome")
        private StringDt myBuild;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myName, this.myBuild});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myBuild});
        }

        public CodeDt getName() {
            if (this.myName == null) {
                this.myName = new CodeDt();
            }
            return this.myName;
        }

        public CodeDt getNameElement() {
            if (this.myName == null) {
                this.myName = new CodeDt();
            }
            return this.myName;
        }

        public Genome setName(CodeDt theValue) {
            this.myName = theValue;
            return this;
        }

        public Genome setName(String theCode) {
            this.myName = new CodeDt(theCode);
            return this;
        }

        public StringDt getBuild() {
            if (this.myBuild == null) {
                this.myBuild = new StringDt();
            }
            return this.myBuild;
        }

        public StringDt getBuildElement() {
            if (this.myBuild == null) {
                this.myBuild = new StringDt();
            }
            return this.myBuild;
        }

        public Genome setBuild(StringDt theValue) {
            this.myBuild = theValue;
            return this;
        }

        public Genome setBuild(String theString) {
            this.myBuild = new StringDt(theString);
            return this;
        }
    }
}

