/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.CodingDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Location;
import ca.uhn.fhir.model.dstu.valueset.ProvenanceEntityRoleEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.InstantDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Provenance", profile="http://hl7.org/fhir/profiles/Provenance", id="provenance")
public class Provenance
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="target", path="Provenance.target", description="", type="reference")
    public static final String SP_TARGET = "target";
    public static final ReferenceClientParam TARGET = new ReferenceClientParam("target");
    public static final Include INCLUDE_TARGET = new Include("Provenance.target");
    @SearchParamDefinition(name="start", path="Provenance.period.start", description="", type="date")
    public static final String SP_START = "start";
    public static final DateClientParam START = new DateClientParam("start");
    @SearchParamDefinition(name="end", path="Provenance.period.end", description="", type="date")
    public static final String SP_END = "end";
    public static final DateClientParam END = new DateClientParam("end");
    @SearchParamDefinition(name="location", path="Provenance.location", description="", type="reference")
    public static final String SP_LOCATION = "location";
    public static final ReferenceClientParam LOCATION = new ReferenceClientParam("location");
    public static final Include INCLUDE_LOCATION = new Include("Provenance.location");
    @SearchParamDefinition(name="party", path="Provenance.agent.reference", description="", type="token")
    public static final String SP_PARTY = "party";
    public static final TokenClientParam PARTY = new TokenClientParam("party");
    @SearchParamDefinition(name="partytype", path="Provenance.agent.type", description="", type="token")
    public static final String SP_PARTYTYPE = "partytype";
    public static final TokenClientParam PARTYTYPE = new TokenClientParam("partytype");
    @Child(name="target", order=0, min=1, max=-1, type={IResource.class})
    @Description(shortDefinition="Target resource(s) (usually version specific)", formalDefinition="The resource(s) that were generated by  the activity described in this resource. A provenance can point to more than one target if multiple resources were created/updated by the same activity")
    private List<ResourceReferenceDt> myTarget;
    @Child(name="period", type={PeriodDt.class}, order=1, min=0, max=1)
    @Description(shortDefinition="When the activity occurred", formalDefinition="The period during which the activity occurred")
    private PeriodDt myPeriod;
    @Child(name="recorded", type={InstantDt.class}, order=2, min=1, max=1)
    @Description(shortDefinition="When the activity was recorded / updated", formalDefinition="The instant of time at which the activity was recorded")
    private InstantDt myRecorded;
    @Child(name="reason", type={CodeableConceptDt.class}, order=3, min=0, max=1)
    @Description(shortDefinition="Reason the activity is occurring", formalDefinition="The reason that the activity was taking place")
    private CodeableConceptDt myReason;
    @Child(name="location", order=4, min=0, max=1, type={Location.class})
    @Description(shortDefinition="Where the activity occurred, if relevant", formalDefinition="Where the activity occurred, if relevant")
    private ResourceReferenceDt myLocation;
    @Child(name="policy", type={UriDt.class}, order=5, min=0, max=-1)
    @Description(shortDefinition="Policy or plan the activity was defined by", formalDefinition="Policy or plan the activity was defined by. Typically, a single activity may have multiple applicable policy documents, such as patient consent, guarantor funding, etc.")
    private List<UriDt> myPolicy;
    @Child(name="agent", order=6, min=0, max=-1)
    @Description(shortDefinition="Person, organization, records, etc. involved in creating resource", formalDefinition="An agent takes a role in an activity such that the agent can be assigned some degree of responsibility for the activity taking place. An agent can be a person, a piece of software, an inanimate object, an organization, or other entities that may be ascribed responsibility")
    private List<Agent> myAgent;
    @Child(name="entity", order=7, min=0, max=-1)
    @Description(shortDefinition="An entity used in this activity", formalDefinition="An entity used in this activity")
    private List<Entity> myEntity;
    @Child(name="integritySignature", type={StringDt.class}, order=8, min=0, max=1)
    @Description(shortDefinition="Base64 signature (DigSig) - integrity check", formalDefinition="A digital signature on the target resource(s). The signature should match a Provenance.agent.reference in the provenance resource. The signature is only added to support checking cryptographic integrity of the resource, and not to represent workflow and clinical aspects of the signing process, or to support non-repudiation.")
    private StringDt myIntegritySignature;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myTarget, this.myPeriod, this.myRecorded, this.myReason, this.myLocation, this.myPolicy, this.myAgent, this.myEntity, this.myIntegritySignature});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myTarget, this.myPeriod, this.myRecorded, this.myReason, this.myLocation, this.myPolicy, this.myAgent, this.myEntity, this.myIntegritySignature});
    }

    public List<ResourceReferenceDt> getTarget() {
        if (this.myTarget == null) {
            this.myTarget = new ArrayList<ResourceReferenceDt>();
        }
        return this.myTarget;
    }

    public List<ResourceReferenceDt> getTargetElement() {
        if (this.myTarget == null) {
            this.myTarget = new ArrayList<ResourceReferenceDt>();
        }
        return this.myTarget;
    }

    public Provenance setTarget(List<ResourceReferenceDt> theValue) {
        this.myTarget = theValue;
        return this;
    }

    public ResourceReferenceDt addTarget() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getTarget().add(newType);
        return newType;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public PeriodDt getPeriodElement() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public Provenance setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public InstantDt getRecorded() {
        if (this.myRecorded == null) {
            this.myRecorded = new InstantDt();
        }
        return this.myRecorded;
    }

    public InstantDt getRecordedElement() {
        if (this.myRecorded == null) {
            this.myRecorded = new InstantDt();
        }
        return this.myRecorded;
    }

    public Provenance setRecorded(InstantDt theValue) {
        this.myRecorded = theValue;
        return this;
    }

    public Provenance setRecordedWithMillisPrecision(Date theDate) {
        this.myRecorded = new InstantDt(theDate);
        return this;
    }

    public Provenance setRecorded(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myRecorded = new InstantDt(theDate, thePrecision);
        return this;
    }

    public CodeableConceptDt getReason() {
        if (this.myReason == null) {
            this.myReason = new CodeableConceptDt();
        }
        return this.myReason;
    }

    public CodeableConceptDt getReasonElement() {
        if (this.myReason == null) {
            this.myReason = new CodeableConceptDt();
        }
        return this.myReason;
    }

    public Provenance setReason(CodeableConceptDt theValue) {
        this.myReason = theValue;
        return this;
    }

    public ResourceReferenceDt getLocation() {
        if (this.myLocation == null) {
            this.myLocation = new ResourceReferenceDt();
        }
        return this.myLocation;
    }

    public ResourceReferenceDt getLocationElement() {
        if (this.myLocation == null) {
            this.myLocation = new ResourceReferenceDt();
        }
        return this.myLocation;
    }

    public Provenance setLocation(ResourceReferenceDt theValue) {
        this.myLocation = theValue;
        return this;
    }

    public List<UriDt> getPolicy() {
        if (this.myPolicy == null) {
            this.myPolicy = new ArrayList<UriDt>();
        }
        return this.myPolicy;
    }

    public List<UriDt> getPolicyElement() {
        if (this.myPolicy == null) {
            this.myPolicy = new ArrayList<UriDt>();
        }
        return this.myPolicy;
    }

    public Provenance setPolicy(List<UriDt> theValue) {
        this.myPolicy = theValue;
        return this;
    }

    public UriDt addPolicy() {
        UriDt newType = new UriDt();
        this.getPolicy().add(newType);
        return newType;
    }

    public UriDt getPolicyFirstRep() {
        if (this.getPolicy().isEmpty()) {
            return this.addPolicy();
        }
        return this.getPolicy().get(0);
    }

    public Provenance addPolicy(String theUri) {
        if (this.myPolicy == null) {
            this.myPolicy = new ArrayList<UriDt>();
        }
        this.myPolicy.add(new UriDt(theUri));
        return this;
    }

    public List<Agent> getAgent() {
        if (this.myAgent == null) {
            this.myAgent = new ArrayList<Agent>();
        }
        return this.myAgent;
    }

    public List<Agent> getAgentElement() {
        if (this.myAgent == null) {
            this.myAgent = new ArrayList<Agent>();
        }
        return this.myAgent;
    }

    public Provenance setAgent(List<Agent> theValue) {
        this.myAgent = theValue;
        return this;
    }

    public Agent addAgent() {
        Agent newType = new Agent();
        this.getAgent().add(newType);
        return newType;
    }

    public Agent getAgentFirstRep() {
        if (this.getAgent().isEmpty()) {
            return this.addAgent();
        }
        return this.getAgent().get(0);
    }

    public List<Entity> getEntity() {
        if (this.myEntity == null) {
            this.myEntity = new ArrayList<Entity>();
        }
        return this.myEntity;
    }

    public List<Entity> getEntityElement() {
        if (this.myEntity == null) {
            this.myEntity = new ArrayList<Entity>();
        }
        return this.myEntity;
    }

    public Provenance setEntity(List<Entity> theValue) {
        this.myEntity = theValue;
        return this;
    }

    public Entity addEntity() {
        Entity newType = new Entity();
        this.getEntity().add(newType);
        return newType;
    }

    public Entity getEntityFirstRep() {
        if (this.getEntity().isEmpty()) {
            return this.addEntity();
        }
        return this.getEntity().get(0);
    }

    public StringDt getIntegritySignature() {
        if (this.myIntegritySignature == null) {
            this.myIntegritySignature = new StringDt();
        }
        return this.myIntegritySignature;
    }

    public StringDt getIntegritySignatureElement() {
        if (this.myIntegritySignature == null) {
            this.myIntegritySignature = new StringDt();
        }
        return this.myIntegritySignature;
    }

    public Provenance setIntegritySignature(StringDt theValue) {
        this.myIntegritySignature = theValue;
        return this;
    }

    public Provenance setIntegritySignature(String theString) {
        this.myIntegritySignature = new StringDt(theString);
        return this;
    }

    public String getResourceName() {
        return "Provenance";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Entity
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="role", type={CodeDt.class}, order=0, min=1, max=1)
        @Description(shortDefinition="derivation | revision | quotation | source", formalDefinition="How the entity was used during the activity")
        private BoundCodeDt<ProvenanceEntityRoleEnum> myRole;
        @Child(name="type", type={CodingDt.class}, order=1, min=1, max=1)
        @Description(shortDefinition="Resource Type, or something else", formalDefinition="The type of the entity. If the entity is a resource, then this is a resource type")
        private CodingDt myType;
        @Child(name="reference", type={UriDt.class}, order=2, min=1, max=1)
        @Description(shortDefinition="Identity of participant (urn or url)", formalDefinition="Identity of participant. May be a logical or physical uri and maybe absolute or relative")
        private UriDt myReference;
        @Child(name="display", type={StringDt.class}, order=3, min=0, max=1)
        @Description(shortDefinition="Human description of participant", formalDefinition="Human-readable description of the entity")
        private StringDt myDisplay;
        @Child(name="agent", type={Agent.class}, order=4, min=0, max=1)
        @Description(shortDefinition="Entity is attributed to this agent", formalDefinition="The entity is attributed to an agent to express the agent's responsibility for that entity, possibly along with other agents. This description can be understood as shorthand for saying that the agent was responsible for the activity which generated the entity")
        private Agent myAgent;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myRole, this.myType, this.myReference, this.myDisplay, this.myAgent});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myRole, this.myType, this.myReference, this.myDisplay, this.myAgent});
        }

        public BoundCodeDt<ProvenanceEntityRoleEnum> getRole() {
            if (this.myRole == null) {
                this.myRole = new BoundCodeDt(ProvenanceEntityRoleEnum.VALUESET_BINDER);
            }
            return this.myRole;
        }

        public BoundCodeDt<ProvenanceEntityRoleEnum> getRoleElement() {
            if (this.myRole == null) {
                this.myRole = new BoundCodeDt(ProvenanceEntityRoleEnum.VALUESET_BINDER);
            }
            return this.myRole;
        }

        public Entity setRole(BoundCodeDt<ProvenanceEntityRoleEnum> theValue) {
            this.myRole = theValue;
            return this;
        }

        public Entity setRole(ProvenanceEntityRoleEnum theValue) {
            this.getRole().setValueAsEnum((Enum)theValue);
            return this;
        }

        public CodingDt getType() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public CodingDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public Entity setType(CodingDt theValue) {
            this.myType = theValue;
            return this;
        }

        public UriDt getReference() {
            if (this.myReference == null) {
                this.myReference = new UriDt();
            }
            return this.myReference;
        }

        public UriDt getReferenceElement() {
            if (this.myReference == null) {
                this.myReference = new UriDt();
            }
            return this.myReference;
        }

        public Entity setReference(UriDt theValue) {
            this.myReference = theValue;
            return this;
        }

        public Entity setReference(String theUri) {
            this.myReference = new UriDt(theUri);
            return this;
        }

        public StringDt getDisplay() {
            if (this.myDisplay == null) {
                this.myDisplay = new StringDt();
            }
            return this.myDisplay;
        }

        public StringDt getDisplayElement() {
            if (this.myDisplay == null) {
                this.myDisplay = new StringDt();
            }
            return this.myDisplay;
        }

        public Entity setDisplay(StringDt theValue) {
            this.myDisplay = theValue;
            return this;
        }

        public Entity setDisplay(String theString) {
            this.myDisplay = new StringDt(theString);
            return this;
        }

        public Agent getAgent() {
            if (this.myAgent == null) {
                this.myAgent = new Agent();
            }
            return this.myAgent;
        }

        public Agent getAgentElement() {
            if (this.myAgent == null) {
                this.myAgent = new Agent();
            }
            return this.myAgent;
        }

        public Entity setAgent(Agent theValue) {
            this.myAgent = theValue;
            return this;
        }
    }

    @Block
    public static class Agent
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="role", type={CodingDt.class}, order=0, min=1, max=1)
        @Description(shortDefinition="e.g. author | overseer | enterer | attester | source | cc: +", formalDefinition="The role that the participant played")
        private CodingDt myRole;
        @Child(name="type", type={CodingDt.class}, order=1, min=1, max=1)
        @Description(shortDefinition="e.g. Resource | Person | Application | Record | Document +", formalDefinition="The type of the participant")
        private CodingDt myType;
        @Child(name="reference", type={UriDt.class}, order=2, min=1, max=1)
        @Description(shortDefinition="Identity of agent (urn or url)", formalDefinition="Identity of participant. May be a logical or physical uri and maybe absolute or relative")
        private UriDt myReference;
        @Child(name="display", type={StringDt.class}, order=3, min=0, max=1)
        @Description(shortDefinition="Human description of participant", formalDefinition="Human-readable description of the participant")
        private StringDt myDisplay;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myRole, this.myType, this.myReference, this.myDisplay});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myRole, this.myType, this.myReference, this.myDisplay});
        }

        public CodingDt getRole() {
            if (this.myRole == null) {
                this.myRole = new CodingDt();
            }
            return this.myRole;
        }

        public CodingDt getRoleElement() {
            if (this.myRole == null) {
                this.myRole = new CodingDt();
            }
            return this.myRole;
        }

        public Agent setRole(CodingDt theValue) {
            this.myRole = theValue;
            return this;
        }

        public CodingDt getType() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public CodingDt getTypeElement() {
            if (this.myType == null) {
                this.myType = new CodingDt();
            }
            return this.myType;
        }

        public Agent setType(CodingDt theValue) {
            this.myType = theValue;
            return this;
        }

        public UriDt getReference() {
            if (this.myReference == null) {
                this.myReference = new UriDt();
            }
            return this.myReference;
        }

        public UriDt getReferenceElement() {
            if (this.myReference == null) {
                this.myReference = new UriDt();
            }
            return this.myReference;
        }

        public Agent setReference(UriDt theValue) {
            this.myReference = theValue;
            return this;
        }

        public Agent setReference(String theUri) {
            this.myReference = new UriDt(theUri);
            return this;
        }

        public StringDt getDisplay() {
            if (this.myDisplay == null) {
                this.myDisplay = new StringDt();
            }
            return this.myDisplay;
        }

        public StringDt getDisplayElement() {
            if (this.myDisplay == null) {
                this.myDisplay = new StringDt();
            }
            return this.myDisplay;
        }

        public Agent setDisplay(StringDt theValue) {
            this.myDisplay = theValue;
            return this;
        }

        public Agent setDisplay(String theString) {
            this.myDisplay = new StringDt(theString);
            return this;
        }
    }
}

