/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Other", profile="http://hl7.org/fhir/profiles/Other", id="other")
public class Other
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="subject", path="Other.subject", description="", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Other.subject");
    @SearchParamDefinition(name="created", path="Other.created", description="", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="code", path="Other.code", description="", type="token")
    public static final String SP_CODE = "code";
    public static final TokenClientParam CODE = new TokenClientParam("code");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1)
    @Description(shortDefinition="Business identifier", formalDefinition="Identifier assigned to the resource for business purposes, outside the context of FHIR")
    private List<IdentifierDt> myIdentifier;
    @Child(name="code", type={CodeableConceptDt.class}, order=1, min=1, max=1)
    @Description(shortDefinition="Kind of Resource", formalDefinition="Identifies the 'type' of resource - equivalent to the resource name for other resources.")
    private CodeableConceptDt myCode;
    @Child(name="subject", order=2, min=0, max=1, type={IResource.class})
    @Description(shortDefinition="Identifies the", formalDefinition="Identifies the patient, practitioner, device or any other resource that is the \"focus\" of this resoruce.")
    private ResourceReferenceDt mySubject;
    @Child(name="author", order=3, min=0, max=1, type={Practitioner.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="Who created", formalDefinition="Indicates who was responsible for creating the resource instance")
    private ResourceReferenceDt myAuthor;
    @Child(name="created", type={DateDt.class}, order=4, min=0, max=1)
    @Description(shortDefinition="When created", formalDefinition="Identifies when the resource was first created")
    private DateDt myCreated;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myCode, this.mySubject, this.myAuthor, this.myCreated});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myCode, this.mySubject, this.myAuthor, this.myCreated});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Other setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Other addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public Other addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public CodeableConceptDt getCode() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public CodeableConceptDt getCodeElement() {
        if (this.myCode == null) {
            this.myCode = new CodeableConceptDt();
        }
        return this.myCode;
    }

    public Other setCode(CodeableConceptDt theValue) {
        this.myCode = theValue;
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Other setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public ResourceReferenceDt getAuthorElement() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public Other setAuthor(ResourceReferenceDt theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public DateDt getCreated() {
        if (this.myCreated == null) {
            this.myCreated = new DateDt();
        }
        return this.myCreated;
    }

    public DateDt getCreatedElement() {
        if (this.myCreated == null) {
            this.myCreated = new DateDt();
        }
        return this.myCreated;
    }

    public Other setCreated(DateDt theValue) {
        this.myCreated = theValue;
        return this;
    }

    public Other setCreated(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myCreated = new DateDt(theDate, thePrecision);
        return this;
    }

    public Other setCreatedWithDayPrecision(Date theDate) {
        this.myCreated = new DateDt(theDate);
        return this;
    }

    public String getResourceName() {
        return "Other";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }
}

