/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.composite.ScheduleDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Order", profile="http://hl7.org/fhir/profiles/Order", id="order")
public class Order
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="date", path="Order.date", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="subject", path="Order.subject", description="", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Order.subject");
    @SearchParamDefinition(name="source", path="Order.source", description="", type="reference")
    public static final String SP_SOURCE = "source";
    public static final ReferenceClientParam SOURCE = new ReferenceClientParam("source");
    public static final Include INCLUDE_SOURCE = new Include("Order.source");
    @SearchParamDefinition(name="target", path="Order.target", description="", type="reference")
    public static final String SP_TARGET = "target";
    public static final ReferenceClientParam TARGET = new ReferenceClientParam("target");
    public static final Include INCLUDE_TARGET = new Include("Order.target");
    @SearchParamDefinition(name="authority", path="Order.authority", description="", type="reference")
    public static final String SP_AUTHORITY = "authority";
    public static final ReferenceClientParam AUTHORITY = new ReferenceClientParam("authority");
    public static final Include INCLUDE_AUTHORITY = new Include("Order.authority");
    @SearchParamDefinition(name="when_code", path="Order.when.code", description="", type="token")
    public static final String SP_WHEN_CODE = "when_code";
    public static final TokenClientParam WHEN_CODE = new TokenClientParam("when_code");
    @SearchParamDefinition(name="when", path="Order.when.schedule", description="", type="date")
    public static final String SP_WHEN = "when";
    public static final DateClientParam WHEN = new DateClientParam("when");
    @SearchParamDefinition(name="detail", path="Order.detail", description="", type="reference")
    public static final String SP_DETAIL = "detail";
    public static final ReferenceClientParam DETAIL = new ReferenceClientParam("detail");
    public static final Include INCLUDE_DETAIL = new Include("Order.detail");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1)
    @Description(shortDefinition="Identifiers assigned to this order by the orderer or by the receiver", formalDefinition="")
    private List<IdentifierDt> myIdentifier;
    @Child(name="date", type={DateTimeDt.class}, order=1, min=0, max=1)
    @Description(shortDefinition="When the order was made", formalDefinition="")
    private DateTimeDt myDate;
    @Child(name="subject", order=2, min=0, max=1, type={Patient.class})
    @Description(shortDefinition="Patient this order is about", formalDefinition="")
    private ResourceReferenceDt mySubject;
    @Child(name="source", order=3, min=0, max=1, type={Practitioner.class})
    @Description(shortDefinition="Who initiated the order", formalDefinition="")
    private ResourceReferenceDt mySource;
    @Child(name="target", order=4, min=0, max=1, type={Organization.class, Device.class, Practitioner.class})
    @Description(shortDefinition="Who is intended to fulfill the order", formalDefinition="")
    private ResourceReferenceDt myTarget;
    @Child(name="reason", order=5, min=0, max=1, type={CodeableConceptDt.class, IResource.class})
    @Description(shortDefinition="Text - why the order was made", formalDefinition="")
    private IDatatype myReason;
    @Child(name="authority", order=6, min=0, max=1, type={IResource.class})
    @Description(shortDefinition="If required by policy", formalDefinition="")
    private ResourceReferenceDt myAuthority;
    @Child(name="when", order=7, min=0, max=1)
    @Description(shortDefinition="When order should be fulfilled", formalDefinition="")
    private When myWhen;
    @Child(name="detail", order=8, min=1, max=-1, type={IResource.class})
    @Description(shortDefinition="What action is being ordered", formalDefinition="")
    private List<ResourceReferenceDt> myDetail;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myDate, this.mySubject, this.mySource, this.myTarget, this.myReason, this.myAuthority, this.myWhen, this.myDetail});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myDate, this.mySubject, this.mySource, this.myTarget, this.myReason, this.myAuthority, this.myWhen, this.myDetail});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Order setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Order addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public Order addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public DateTimeDt getDate() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Order setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public Order setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Order setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Order setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getSource() {
        if (this.mySource == null) {
            this.mySource = new ResourceReferenceDt();
        }
        return this.mySource;
    }

    public ResourceReferenceDt getSourceElement() {
        if (this.mySource == null) {
            this.mySource = new ResourceReferenceDt();
        }
        return this.mySource;
    }

    public Order setSource(ResourceReferenceDt theValue) {
        this.mySource = theValue;
        return this;
    }

    public ResourceReferenceDt getTarget() {
        if (this.myTarget == null) {
            this.myTarget = new ResourceReferenceDt();
        }
        return this.myTarget;
    }

    public ResourceReferenceDt getTargetElement() {
        if (this.myTarget == null) {
            this.myTarget = new ResourceReferenceDt();
        }
        return this.myTarget;
    }

    public Order setTarget(ResourceReferenceDt theValue) {
        this.myTarget = theValue;
        return this;
    }

    public IDatatype getReason() {
        return this.myReason;
    }

    public IDatatype getReasonElement() {
        return this.myReason;
    }

    public Order setReason(IDatatype theValue) {
        this.myReason = theValue;
        return this;
    }

    public ResourceReferenceDt getAuthority() {
        if (this.myAuthority == null) {
            this.myAuthority = new ResourceReferenceDt();
        }
        return this.myAuthority;
    }

    public ResourceReferenceDt getAuthorityElement() {
        if (this.myAuthority == null) {
            this.myAuthority = new ResourceReferenceDt();
        }
        return this.myAuthority;
    }

    public Order setAuthority(ResourceReferenceDt theValue) {
        this.myAuthority = theValue;
        return this;
    }

    public When getWhen() {
        if (this.myWhen == null) {
            this.myWhen = new When();
        }
        return this.myWhen;
    }

    public When getWhenElement() {
        if (this.myWhen == null) {
            this.myWhen = new When();
        }
        return this.myWhen;
    }

    public Order setWhen(When theValue) {
        this.myWhen = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getDetail() {
        if (this.myDetail == null) {
            this.myDetail = new ArrayList<ResourceReferenceDt>();
        }
        return this.myDetail;
    }

    public List<ResourceReferenceDt> getDetailElement() {
        if (this.myDetail == null) {
            this.myDetail = new ArrayList<ResourceReferenceDt>();
        }
        return this.myDetail;
    }

    public Order setDetail(List<ResourceReferenceDt> theValue) {
        this.myDetail = theValue;
        return this;
    }

    public ResourceReferenceDt addDetail() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getDetail().add(newType);
        return newType;
    }

    public String getResourceName() {
        return "Order";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class When
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=0, max=1)
        @Description(shortDefinition="Code specifies when request should be done. The code may simply be a priority code", formalDefinition="")
        private CodeableConceptDt myCode;
        @Child(name="schedule", type={ScheduleDt.class}, order=1, min=0, max=1)
        @Description(shortDefinition="A formal schedule", formalDefinition="")
        private ScheduleDt mySchedule;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.mySchedule});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.mySchedule});
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public CodeableConceptDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public When setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public ScheduleDt getSchedule() {
            if (this.mySchedule == null) {
                this.mySchedule = new ScheduleDt();
            }
            return this.mySchedule;
        }

        public ScheduleDt getScheduleElement() {
            if (this.mySchedule == null) {
                this.mySchedule = new ScheduleDt();
            }
            return this.mySchedule;
        }

        public When setSchedule(ScheduleDt theValue) {
            this.mySchedule = theValue;
            return this;
        }
    }
}

