/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.QuantityDt;
import ca.uhn.fhir.model.dstu.composite.RatioDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.composite.ScheduleDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Medication;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="MedicationStatement", profile="http://hl7.org/fhir/profiles/MedicationStatement", id="medicationstatement")
public class MedicationStatement
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="device", path="MedicationStatement.device", description="Return administrations with this administration device identity", type="reference")
    public static final String SP_DEVICE = "device";
    public static final ReferenceClientParam DEVICE = new ReferenceClientParam("device");
    public static final Include INCLUDE_DEVICE = new Include("MedicationStatement.device");
    @SearchParamDefinition(name="identifier", path="MedicationStatement.identifier", description="Return administrations with this external identity", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="medication", path="MedicationStatement.medication", description="Code for medicine or text in medicine name", type="reference")
    public static final String SP_MEDICATION = "medication";
    public static final ReferenceClientParam MEDICATION = new ReferenceClientParam("medication");
    public static final Include INCLUDE_MEDICATION = new Include("MedicationStatement.medication");
    @SearchParamDefinition(name="patient", path="MedicationStatement.patient", description="The identity of a patient to list administrations  for", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("MedicationStatement.patient");
    @SearchParamDefinition(name="when-given", path="MedicationStatement.whenGiven", description="Date of administration", type="date")
    public static final String SP_WHEN_GIVEN = "when-given";
    public static final DateClientParam WHEN_GIVEN = new DateClientParam("when-given");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1)
    @Description(shortDefinition="External Identifier", formalDefinition="External identifier - FHIR will generate its own internal IDs (probably URLs) which do not need to be explicitly managed by the resource.  The identifier here is one that would be used by another non-FHIR system - for example an automated medication pump would provide a record each time it operated; an administration while the patient was off the ward might be made with a different system and entered after the event.  Particularly important if these records have to be updated.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="patient", order=1, min=0, max=1, type={Patient.class})
    @Description(shortDefinition="Who was/is taking medication", formalDefinition="The person or animal who is /was taking the medication.")
    private ResourceReferenceDt myPatient;
    @Child(name="wasNotGiven", type={BooleanDt.class}, order=2, min=0, max=1)
    @Description(shortDefinition="True if medication is/was not being taken", formalDefinition="Set this to true if the record is saying that the medication was NOT taken.")
    private BooleanDt myWasNotGiven;
    @Child(name="reasonNotGiven", type={CodeableConceptDt.class}, order=3, min=0, max=-1)
    @Description(shortDefinition="True if asserting medication was not given", formalDefinition="A code indicating why the medication was not taken.")
    private List<CodeableConceptDt> myReasonNotGiven;
    @Child(name="whenGiven", type={PeriodDt.class}, order=4, min=0, max=1)
    @Description(shortDefinition="Over what period was medication consumed?", formalDefinition="The interval of time during which it is being asserted that the patient was taking the medication.")
    private PeriodDt myWhenGiven;
    @Child(name="medication", order=5, min=0, max=1, type={Medication.class})
    @Description(shortDefinition="What medication was taken?", formalDefinition="Identifies the medication being administered. This is either a link to a resource representing the details of the medication or a simple attribute carrying a code that identifies the medication from a known list of medications.")
    private ResourceReferenceDt myMedication;
    @Child(name="device", order=6, min=0, max=-1, type={Device.class})
    @Description(shortDefinition="E.g. infusion pump", formalDefinition="An identifier or a link to a resource that identifies a device used in administering the medication to the patient.")
    private List<ResourceReferenceDt> myDevice;
    @Child(name="dosage", order=7, min=0, max=-1)
    @Description(shortDefinition="Details of how medication was taken", formalDefinition="Indicates how the medication is/was used by the patient")
    private List<Dosage> myDosage;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myPatient, this.myWasNotGiven, this.myReasonNotGiven, this.myWhenGiven, this.myMedication, this.myDevice, this.myDosage});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myPatient, this.myWasNotGiven, this.myReasonNotGiven, this.myWhenGiven, this.myMedication, this.myDevice, this.myDosage});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public MedicationStatement setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public MedicationStatement addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public MedicationStatement addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public ResourceReferenceDt getPatientElement() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public MedicationStatement setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public BooleanDt getWasNotGiven() {
        if (this.myWasNotGiven == null) {
            this.myWasNotGiven = new BooleanDt();
        }
        return this.myWasNotGiven;
    }

    public BooleanDt getWasNotGivenElement() {
        if (this.myWasNotGiven == null) {
            this.myWasNotGiven = new BooleanDt();
        }
        return this.myWasNotGiven;
    }

    public MedicationStatement setWasNotGiven(BooleanDt theValue) {
        this.myWasNotGiven = theValue;
        return this;
    }

    public MedicationStatement setWasNotGiven(boolean theBoolean) {
        this.myWasNotGiven = new BooleanDt(theBoolean);
        return this;
    }

    public List<CodeableConceptDt> getReasonNotGiven() {
        if (this.myReasonNotGiven == null) {
            this.myReasonNotGiven = new ArrayList<CodeableConceptDt>();
        }
        return this.myReasonNotGiven;
    }

    public List<CodeableConceptDt> getReasonNotGivenElement() {
        if (this.myReasonNotGiven == null) {
            this.myReasonNotGiven = new ArrayList<CodeableConceptDt>();
        }
        return this.myReasonNotGiven;
    }

    public MedicationStatement setReasonNotGiven(List<CodeableConceptDt> theValue) {
        this.myReasonNotGiven = theValue;
        return this;
    }

    public CodeableConceptDt addReasonNotGiven() {
        CodeableConceptDt newType = new CodeableConceptDt();
        this.getReasonNotGiven().add(newType);
        return newType;
    }

    public CodeableConceptDt getReasonNotGivenFirstRep() {
        if (this.getReasonNotGiven().isEmpty()) {
            return this.addReasonNotGiven();
        }
        return this.getReasonNotGiven().get(0);
    }

    public PeriodDt getWhenGiven() {
        if (this.myWhenGiven == null) {
            this.myWhenGiven = new PeriodDt();
        }
        return this.myWhenGiven;
    }

    public PeriodDt getWhenGivenElement() {
        if (this.myWhenGiven == null) {
            this.myWhenGiven = new PeriodDt();
        }
        return this.myWhenGiven;
    }

    public MedicationStatement setWhenGiven(PeriodDt theValue) {
        this.myWhenGiven = theValue;
        return this;
    }

    public ResourceReferenceDt getMedication() {
        if (this.myMedication == null) {
            this.myMedication = new ResourceReferenceDt();
        }
        return this.myMedication;
    }

    public ResourceReferenceDt getMedicationElement() {
        if (this.myMedication == null) {
            this.myMedication = new ResourceReferenceDt();
        }
        return this.myMedication;
    }

    public MedicationStatement setMedication(ResourceReferenceDt theValue) {
        this.myMedication = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getDevice() {
        if (this.myDevice == null) {
            this.myDevice = new ArrayList<ResourceReferenceDt>();
        }
        return this.myDevice;
    }

    public List<ResourceReferenceDt> getDeviceElement() {
        if (this.myDevice == null) {
            this.myDevice = new ArrayList<ResourceReferenceDt>();
        }
        return this.myDevice;
    }

    public MedicationStatement setDevice(List<ResourceReferenceDt> theValue) {
        this.myDevice = theValue;
        return this;
    }

    public ResourceReferenceDt addDevice() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getDevice().add(newType);
        return newType;
    }

    public List<Dosage> getDosage() {
        if (this.myDosage == null) {
            this.myDosage = new ArrayList<Dosage>();
        }
        return this.myDosage;
    }

    public List<Dosage> getDosageElement() {
        if (this.myDosage == null) {
            this.myDosage = new ArrayList<Dosage>();
        }
        return this.myDosage;
    }

    public MedicationStatement setDosage(List<Dosage> theValue) {
        this.myDosage = theValue;
        return this;
    }

    public Dosage addDosage() {
        Dosage newType = new Dosage();
        this.getDosage().add(newType);
        return newType;
    }

    public Dosage getDosageFirstRep() {
        if (this.getDosage().isEmpty()) {
            return this.addDosage();
        }
        return this.getDosage().get(0);
    }

    public String getResourceName() {
        return "MedicationStatement";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Dosage
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="timing", type={ScheduleDt.class}, order=0, min=0, max=1)
        @Description(shortDefinition="When/how often was medication taken?", formalDefinition="The timing schedule for giving the medication to the patient.  The Schedule data type allows many different expressions, for example.  \"Every  8 hours\"; \"Three times a day\"; \"1/2 an hour before breakfast for 10 days from 23-Dec 2011:\";  \"15 Oct 2013, 17 Oct 2013 and 1 Nov 2013\"")
        private ScheduleDt myTiming;
        @Child(name="asNeeded", order=1, min=0, max=1, type={BooleanDt.class, CodeableConceptDt.class})
        @Description(shortDefinition="Take \"as needed\" f(or x)", formalDefinition="If set to true or if specified as a CodeableConcept, indicates that the medication is only taken when needed within the specified schedule rather than at every scheduled dose.  If a CodeableConcept is present, it indicates the pre-condition for taking the Medication")
        private IDatatype myAsNeeded;
        @Child(name="site", type={CodeableConceptDt.class}, order=2, min=0, max=1)
        @Description(shortDefinition="Where on body was medication administered?", formalDefinition="A coded specification of the anatomic site where the medication first enters the body")
        private CodeableConceptDt mySite;
        @Child(name="route", type={CodeableConceptDt.class}, order=3, min=0, max=1)
        @Description(shortDefinition="How did the medication enter the body?", formalDefinition="A code specifying the route or physiological path of administration of a therapeutic agent into or onto a subject.")
        private CodeableConceptDt myRoute;
        @Child(name="method", type={CodeableConceptDt.class}, order=4, min=0, max=1)
        @Description(shortDefinition="Technique used to administer medication", formalDefinition="A coded value indicating the method by which the medication is introduced into or onto the body. Most commonly used for injections.  Examples:  Slow Push; Deep IV.Terminologies used often pre-coordinate this term with the route and or form of administration.")
        private CodeableConceptDt myMethod;
        @Child(name="quantity", type={QuantityDt.class}, order=5, min=0, max=1)
        @Description(shortDefinition="Amount administered in one dose", formalDefinition="The amount of therapeutic or other substance given at one administration event.")
        private QuantityDt myQuantity;
        @Child(name="rate", type={RatioDt.class}, order=6, min=0, max=1)
        @Description(shortDefinition="Dose quantity per unit of time", formalDefinition="Identifies the speed with which the substance is introduced into the subject. Typically the rate for an infusion. 200ml in 2 hours.")
        private RatioDt myRate;
        @Child(name="maxDosePerPeriod", type={RatioDt.class}, order=7, min=0, max=1)
        @Description(shortDefinition="Maximum dose that was consumed per unit of time", formalDefinition="The maximum total quantity of a therapeutic substance that may be administered to a subject over the period of time. E.g. 1000mg in 24 hours.")
        private RatioDt myMaxDosePerPeriod;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myTiming, this.myAsNeeded, this.mySite, this.myRoute, this.myMethod, this.myQuantity, this.myRate, this.myMaxDosePerPeriod});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myTiming, this.myAsNeeded, this.mySite, this.myRoute, this.myMethod, this.myQuantity, this.myRate, this.myMaxDosePerPeriod});
        }

        public ScheduleDt getTiming() {
            if (this.myTiming == null) {
                this.myTiming = new ScheduleDt();
            }
            return this.myTiming;
        }

        public ScheduleDt getTimingElement() {
            if (this.myTiming == null) {
                this.myTiming = new ScheduleDt();
            }
            return this.myTiming;
        }

        public Dosage setTiming(ScheduleDt theValue) {
            this.myTiming = theValue;
            return this;
        }

        public IDatatype getAsNeeded() {
            return this.myAsNeeded;
        }

        public IDatatype getAsNeededElement() {
            return this.myAsNeeded;
        }

        public Dosage setAsNeeded(IDatatype theValue) {
            this.myAsNeeded = theValue;
            return this;
        }

        public CodeableConceptDt getSite() {
            if (this.mySite == null) {
                this.mySite = new CodeableConceptDt();
            }
            return this.mySite;
        }

        public CodeableConceptDt getSiteElement() {
            if (this.mySite == null) {
                this.mySite = new CodeableConceptDt();
            }
            return this.mySite;
        }

        public Dosage setSite(CodeableConceptDt theValue) {
            this.mySite = theValue;
            return this;
        }

        public CodeableConceptDt getRoute() {
            if (this.myRoute == null) {
                this.myRoute = new CodeableConceptDt();
            }
            return this.myRoute;
        }

        public CodeableConceptDt getRouteElement() {
            if (this.myRoute == null) {
                this.myRoute = new CodeableConceptDt();
            }
            return this.myRoute;
        }

        public Dosage setRoute(CodeableConceptDt theValue) {
            this.myRoute = theValue;
            return this;
        }

        public CodeableConceptDt getMethod() {
            if (this.myMethod == null) {
                this.myMethod = new CodeableConceptDt();
            }
            return this.myMethod;
        }

        public CodeableConceptDt getMethodElement() {
            if (this.myMethod == null) {
                this.myMethod = new CodeableConceptDt();
            }
            return this.myMethod;
        }

        public Dosage setMethod(CodeableConceptDt theValue) {
            this.myMethod = theValue;
            return this;
        }

        public QuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new QuantityDt();
            }
            return this.myQuantity;
        }

        public QuantityDt getQuantityElement() {
            if (this.myQuantity == null) {
                this.myQuantity = new QuantityDt();
            }
            return this.myQuantity;
        }

        public Dosage setQuantity(QuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public Dosage setQuantity(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public Dosage setQuantity(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public Dosage setQuantity(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public Dosage setQuantity(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public Dosage setQuantity(double theValue) {
            this.myQuantity = new QuantityDt(theValue);
            return this;
        }

        public Dosage setQuantity(long theValue) {
            this.myQuantity = new QuantityDt(theValue);
            return this;
        }

        public RatioDt getRate() {
            if (this.myRate == null) {
                this.myRate = new RatioDt();
            }
            return this.myRate;
        }

        public RatioDt getRateElement() {
            if (this.myRate == null) {
                this.myRate = new RatioDt();
            }
            return this.myRate;
        }

        public Dosage setRate(RatioDt theValue) {
            this.myRate = theValue;
            return this;
        }

        public RatioDt getMaxDosePerPeriod() {
            if (this.myMaxDosePerPeriod == null) {
                this.myMaxDosePerPeriod = new RatioDt();
            }
            return this.myMaxDosePerPeriod;
        }

        public RatioDt getMaxDosePerPeriodElement() {
            if (this.myMaxDosePerPeriod == null) {
                this.myMaxDosePerPeriod = new RatioDt();
            }
            return this.myMaxDosePerPeriod;
        }

        public Dosage setMaxDosePerPeriod(RatioDt theValue) {
            this.myMaxDosePerPeriod = theValue;
            return this;
        }
    }
}

