/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.AdverseReaction;
import ca.uhn.fhir.model.dstu.resource.AllergyIntolerance;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Immunization;
import ca.uhn.fhir.model.dstu.resource.Observation;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.ImmunizationRecommendationDateCriterionCodesEnum;
import ca.uhn.fhir.model.dstu.valueset.ImmunizationRecommendationStatusCodesEnum;
import ca.uhn.fhir.model.primitive.BoundCodeableConceptDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.NumberClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="ImmunizationRecommendation", profile="http://hl7.org/fhir/profiles/ImmunizationRecommendation", id="immunizationrecommendation")
public class ImmunizationRecommendation
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="subject", path="ImmunizationRecommendation.subject", description="", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("ImmunizationRecommendation.subject");
    @SearchParamDefinition(name="vaccine-type", path="ImmunizationRecommendation.recommendation.vaccineType", description="", type="token")
    public static final String SP_VACCINE_TYPE = "vaccine-type";
    public static final TokenClientParam VACCINE_TYPE = new TokenClientParam("vaccine-type");
    @SearchParamDefinition(name="identifier", path="ImmunizationRecommendation.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="date", path="ImmunizationRecommendation.recommendation.date", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="dose-number", path="ImmunizationRecommendation.recommendation.doseNumber", description="", type="number")
    public static final String SP_DOSE_NUMBER = "dose-number";
    public static final NumberClientParam DOSE_NUMBER = new NumberClientParam("dose-number");
    @SearchParamDefinition(name="status", path="ImmunizationRecommendation.recommendation.forecastStatus", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="dose-sequence", path="ImmunizationRecommendation.recommendation.protocol.doseSequence", description="", type="token")
    public static final String SP_DOSE_SEQUENCE = "dose-sequence";
    public static final TokenClientParam DOSE_SEQUENCE = new TokenClientParam("dose-sequence");
    @SearchParamDefinition(name="support", path="ImmunizationRecommendation.recommendation.supportingImmunization", description="", type="reference")
    public static final String SP_SUPPORT = "support";
    public static final ReferenceClientParam SUPPORT = new ReferenceClientParam("support");
    public static final Include INCLUDE_RECOMMENDATION_SUPPORTINGIMMUNIZATION = new Include("ImmunizationRecommendation.recommendation.supportingImmunization");
    @SearchParamDefinition(name="information", path="ImmunizationRecommendation.recommendation.supportingPatientInformation", description="", type="reference")
    public static final String SP_INFORMATION = "information";
    public static final ReferenceClientParam INFORMATION = new ReferenceClientParam("information");
    public static final Include INCLUDE_RECOMMENDATION_SUPPORTINGPATIENTINFORMATION = new Include("ImmunizationRecommendation.recommendation.supportingPatientInformation");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1)
    @Description(shortDefinition="Business identifier", formalDefinition="A unique identifier assigned to this particular recommendation record.")
    private List<IdentifierDt> myIdentifier;
    @Child(name="subject", order=1, min=1, max=1, type={Patient.class})
    @Description(shortDefinition="Who this profile is for", formalDefinition="The patient who is the subject of the profile")
    private ResourceReferenceDt mySubject;
    @Child(name="recommendation", order=2, min=1, max=-1)
    @Description(shortDefinition="Vaccine administration recommendations", formalDefinition="Vaccine administration recommendations")
    private List<Recommendation> myRecommendation;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.mySubject, this.myRecommendation});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.mySubject, this.myRecommendation});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public ImmunizationRecommendation setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public ImmunizationRecommendation addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public ImmunizationRecommendation addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ImmunizationRecommendation setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public List<Recommendation> getRecommendation() {
        if (this.myRecommendation == null) {
            this.myRecommendation = new ArrayList<Recommendation>();
        }
        return this.myRecommendation;
    }

    public List<Recommendation> getRecommendationElement() {
        if (this.myRecommendation == null) {
            this.myRecommendation = new ArrayList<Recommendation>();
        }
        return this.myRecommendation;
    }

    public ImmunizationRecommendation setRecommendation(List<Recommendation> theValue) {
        this.myRecommendation = theValue;
        return this;
    }

    public Recommendation addRecommendation() {
        Recommendation newType = new Recommendation();
        this.getRecommendation().add(newType);
        return newType;
    }

    public Recommendation getRecommendationFirstRep() {
        if (this.getRecommendation().isEmpty()) {
            return this.addRecommendation();
        }
        return this.getRecommendation().get(0);
    }

    public String getResourceName() {
        return "ImmunizationRecommendation";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class RecommendationProtocol
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="doseSequence", type={IntegerDt.class}, order=0, min=0, max=1)
        @Description(shortDefinition="Number of dose within sequence", formalDefinition="Indicates the nominal position in a series of the next dose.  This is the recommended dose number as per a specified protocol.")
        private IntegerDt myDoseSequence;
        @Child(name="description", type={StringDt.class}, order=1, min=0, max=1)
        @Description(shortDefinition="Protocol details", formalDefinition="Contains the description about the protocol under which the vaccine was administered")
        private StringDt myDescription;
        @Child(name="authority", order=2, min=0, max=1, type={Organization.class})
        @Description(shortDefinition="Who is responsible for protocol", formalDefinition="Indicates the authority who published the protocol?  E.g. ACIP")
        private ResourceReferenceDt myAuthority;
        @Child(name="series", type={StringDt.class}, order=3, min=0, max=1)
        @Description(shortDefinition="Name of vaccination series", formalDefinition="One possible path to achieve presumed immunity against a disease - within the context of an authority")
        private StringDt mySeries;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myDoseSequence, this.myDescription, this.myAuthority, this.mySeries});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDoseSequence, this.myDescription, this.myAuthority, this.mySeries});
        }

        public IntegerDt getDoseSequence() {
            if (this.myDoseSequence == null) {
                this.myDoseSequence = new IntegerDt();
            }
            return this.myDoseSequence;
        }

        public IntegerDt getDoseSequenceElement() {
            if (this.myDoseSequence == null) {
                this.myDoseSequence = new IntegerDt();
            }
            return this.myDoseSequence;
        }

        public RecommendationProtocol setDoseSequence(IntegerDt theValue) {
            this.myDoseSequence = theValue;
            return this;
        }

        public RecommendationProtocol setDoseSequence(int theInteger) {
            this.myDoseSequence = new IntegerDt(theInteger);
            return this;
        }

        public StringDt getDescription() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public RecommendationProtocol setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public RecommendationProtocol setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public ResourceReferenceDt getAuthority() {
            if (this.myAuthority == null) {
                this.myAuthority = new ResourceReferenceDt();
            }
            return this.myAuthority;
        }

        public ResourceReferenceDt getAuthorityElement() {
            if (this.myAuthority == null) {
                this.myAuthority = new ResourceReferenceDt();
            }
            return this.myAuthority;
        }

        public RecommendationProtocol setAuthority(ResourceReferenceDt theValue) {
            this.myAuthority = theValue;
            return this;
        }

        public StringDt getSeries() {
            if (this.mySeries == null) {
                this.mySeries = new StringDt();
            }
            return this.mySeries;
        }

        public StringDt getSeriesElement() {
            if (this.mySeries == null) {
                this.mySeries = new StringDt();
            }
            return this.mySeries;
        }

        public RecommendationProtocol setSeries(StringDt theValue) {
            this.mySeries = theValue;
            return this;
        }

        public RecommendationProtocol setSeries(String theString) {
            this.mySeries = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class RecommendationDateCriterion
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=1, max=1)
        @Description(shortDefinition="Type of date", formalDefinition="Date classification of recommendation - e.g. earliest date to give, latest date to give, etc.")
        private BoundCodeableConceptDt<ImmunizationRecommendationDateCriterionCodesEnum> myCode;
        @Child(name="value", type={DateTimeDt.class}, order=1, min=1, max=1)
        @Description(shortDefinition="Recommended date", formalDefinition="Date recommendation")
        private DateTimeDt myValue;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.myValue});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myValue});
        }

        public BoundCodeableConceptDt<ImmunizationRecommendationDateCriterionCodesEnum> getCode() {
            if (this.myCode == null) {
                this.myCode = new BoundCodeableConceptDt<ImmunizationRecommendationDateCriterionCodesEnum>(ImmunizationRecommendationDateCriterionCodesEnum.VALUESET_BINDER);
            }
            return this.myCode;
        }

        public BoundCodeableConceptDt<ImmunizationRecommendationDateCriterionCodesEnum> getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new BoundCodeableConceptDt<ImmunizationRecommendationDateCriterionCodesEnum>(ImmunizationRecommendationDateCriterionCodesEnum.VALUESET_BINDER);
            }
            return this.myCode;
        }

        public RecommendationDateCriterion setCode(BoundCodeableConceptDt<ImmunizationRecommendationDateCriterionCodesEnum> theValue) {
            this.myCode = theValue;
            return this;
        }

        public RecommendationDateCriterion setCode(ImmunizationRecommendationDateCriterionCodesEnum theValue) {
            this.getCode().setValueAsEnum(theValue);
            return this;
        }

        public DateTimeDt getValue() {
            if (this.myValue == null) {
                this.myValue = new DateTimeDt();
            }
            return this.myValue;
        }

        public DateTimeDt getValueElement() {
            if (this.myValue == null) {
                this.myValue = new DateTimeDt();
            }
            return this.myValue;
        }

        public RecommendationDateCriterion setValue(DateTimeDt theValue) {
            this.myValue = theValue;
            return this;
        }

        public RecommendationDateCriterion setValue(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myValue = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public RecommendationDateCriterion setValueWithSecondsPrecision(Date theDate) {
            this.myValue = new DateTimeDt(theDate);
            return this;
        }
    }

    @Block
    public static class Recommendation
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="date", type={DateTimeDt.class}, order=0, min=1, max=1)
        @Description(shortDefinition="Date recommendation created", formalDefinition="The date the immunization recommendation was created.")
        private DateTimeDt myDate;
        @Child(name="vaccineType", type={CodeableConceptDt.class}, order=1, min=1, max=1)
        @Description(shortDefinition="Vaccine recommendation applies to", formalDefinition="Vaccine that pertains to the recommendation")
        private CodeableConceptDt myVaccineType;
        @Child(name="doseNumber", type={IntegerDt.class}, order=2, min=0, max=1)
        @Description(shortDefinition="Recommended dose number", formalDefinition="This indicates the next recommended dose number (e.g. dose 2 is the next recommended dose).")
        private IntegerDt myDoseNumber;
        @Child(name="forecastStatus", type={CodeableConceptDt.class}, order=3, min=1, max=1)
        @Description(shortDefinition="Vaccine administration status", formalDefinition="Vaccine administration status")
        private BoundCodeableConceptDt<ImmunizationRecommendationStatusCodesEnum> myForecastStatus;
        @Child(name="dateCriterion", order=4, min=0, max=-1)
        @Description(shortDefinition="Dates governing proposed immunization", formalDefinition="Vaccine date recommendations - e.g. earliest date to administer, latest date to administer, etc.")
        private List<RecommendationDateCriterion> myDateCriterion;
        @Child(name="protocol", order=5, min=0, max=1)
        @Description(shortDefinition="Protocol used by recommendation", formalDefinition="Contains information about the protocol under which the vaccine was administered")
        private RecommendationProtocol myProtocol;
        @Child(name="supportingImmunization", order=6, min=0, max=-1, type={Immunization.class})
        @Description(shortDefinition="Past immunizations supporting recommendation", formalDefinition="Immunization event history that supports the status and recommendation")
        private List<ResourceReferenceDt> mySupportingImmunization;
        @Child(name="supportingPatientInformation", order=7, min=0, max=-1, type={Observation.class, AdverseReaction.class, AllergyIntolerance.class})
        @Description(shortDefinition="Patient observations supporting recommendation", formalDefinition="Patient Information that supports the status and recommendation.  This includes patient observations, adverse reactions and allergy/intolerance information.")
        private List<ResourceReferenceDt> mySupportingPatientInformation;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myDate, this.myVaccineType, this.myDoseNumber, this.myForecastStatus, this.myDateCriterion, this.myProtocol, this.mySupportingImmunization, this.mySupportingPatientInformation});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDate, this.myVaccineType, this.myDoseNumber, this.myForecastStatus, this.myDateCriterion, this.myProtocol, this.mySupportingImmunization, this.mySupportingPatientInformation});
        }

        public DateTimeDt getDate() {
            if (this.myDate == null) {
                this.myDate = new DateTimeDt();
            }
            return this.myDate;
        }

        public DateTimeDt getDateElement() {
            if (this.myDate == null) {
                this.myDate = new DateTimeDt();
            }
            return this.myDate;
        }

        public Recommendation setDate(DateTimeDt theValue) {
            this.myDate = theValue;
            return this;
        }

        public Recommendation setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myDate = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public Recommendation setDateWithSecondsPrecision(Date theDate) {
            this.myDate = new DateTimeDt(theDate);
            return this;
        }

        public CodeableConceptDt getVaccineType() {
            if (this.myVaccineType == null) {
                this.myVaccineType = new CodeableConceptDt();
            }
            return this.myVaccineType;
        }

        public CodeableConceptDt getVaccineTypeElement() {
            if (this.myVaccineType == null) {
                this.myVaccineType = new CodeableConceptDt();
            }
            return this.myVaccineType;
        }

        public Recommendation setVaccineType(CodeableConceptDt theValue) {
            this.myVaccineType = theValue;
            return this;
        }

        public IntegerDt getDoseNumber() {
            if (this.myDoseNumber == null) {
                this.myDoseNumber = new IntegerDt();
            }
            return this.myDoseNumber;
        }

        public IntegerDt getDoseNumberElement() {
            if (this.myDoseNumber == null) {
                this.myDoseNumber = new IntegerDt();
            }
            return this.myDoseNumber;
        }

        public Recommendation setDoseNumber(IntegerDt theValue) {
            this.myDoseNumber = theValue;
            return this;
        }

        public Recommendation setDoseNumber(int theInteger) {
            this.myDoseNumber = new IntegerDt(theInteger);
            return this;
        }

        public BoundCodeableConceptDt<ImmunizationRecommendationStatusCodesEnum> getForecastStatus() {
            if (this.myForecastStatus == null) {
                this.myForecastStatus = new BoundCodeableConceptDt<ImmunizationRecommendationStatusCodesEnum>(ImmunizationRecommendationStatusCodesEnum.VALUESET_BINDER);
            }
            return this.myForecastStatus;
        }

        public BoundCodeableConceptDt<ImmunizationRecommendationStatusCodesEnum> getForecastStatusElement() {
            if (this.myForecastStatus == null) {
                this.myForecastStatus = new BoundCodeableConceptDt<ImmunizationRecommendationStatusCodesEnum>(ImmunizationRecommendationStatusCodesEnum.VALUESET_BINDER);
            }
            return this.myForecastStatus;
        }

        public Recommendation setForecastStatus(BoundCodeableConceptDt<ImmunizationRecommendationStatusCodesEnum> theValue) {
            this.myForecastStatus = theValue;
            return this;
        }

        public Recommendation setForecastStatus(ImmunizationRecommendationStatusCodesEnum theValue) {
            this.getForecastStatus().setValueAsEnum(theValue);
            return this;
        }

        public List<RecommendationDateCriterion> getDateCriterion() {
            if (this.myDateCriterion == null) {
                this.myDateCriterion = new ArrayList<RecommendationDateCriterion>();
            }
            return this.myDateCriterion;
        }

        public List<RecommendationDateCriterion> getDateCriterionElement() {
            if (this.myDateCriterion == null) {
                this.myDateCriterion = new ArrayList<RecommendationDateCriterion>();
            }
            return this.myDateCriterion;
        }

        public Recommendation setDateCriterion(List<RecommendationDateCriterion> theValue) {
            this.myDateCriterion = theValue;
            return this;
        }

        public RecommendationDateCriterion addDateCriterion() {
            RecommendationDateCriterion newType = new RecommendationDateCriterion();
            this.getDateCriterion().add(newType);
            return newType;
        }

        public RecommendationDateCriterion getDateCriterionFirstRep() {
            if (this.getDateCriterion().isEmpty()) {
                return this.addDateCriterion();
            }
            return this.getDateCriterion().get(0);
        }

        public RecommendationProtocol getProtocol() {
            if (this.myProtocol == null) {
                this.myProtocol = new RecommendationProtocol();
            }
            return this.myProtocol;
        }

        public RecommendationProtocol getProtocolElement() {
            if (this.myProtocol == null) {
                this.myProtocol = new RecommendationProtocol();
            }
            return this.myProtocol;
        }

        public Recommendation setProtocol(RecommendationProtocol theValue) {
            this.myProtocol = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getSupportingImmunization() {
            if (this.mySupportingImmunization == null) {
                this.mySupportingImmunization = new ArrayList<ResourceReferenceDt>();
            }
            return this.mySupportingImmunization;
        }

        public List<ResourceReferenceDt> getSupportingImmunizationElement() {
            if (this.mySupportingImmunization == null) {
                this.mySupportingImmunization = new ArrayList<ResourceReferenceDt>();
            }
            return this.mySupportingImmunization;
        }

        public Recommendation setSupportingImmunization(List<ResourceReferenceDt> theValue) {
            this.mySupportingImmunization = theValue;
            return this;
        }

        public ResourceReferenceDt addSupportingImmunization() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getSupportingImmunization().add(newType);
            return newType;
        }

        public List<ResourceReferenceDt> getSupportingPatientInformation() {
            if (this.mySupportingPatientInformation == null) {
                this.mySupportingPatientInformation = new ArrayList<ResourceReferenceDt>();
            }
            return this.mySupportingPatientInformation;
        }

        public List<ResourceReferenceDt> getSupportingPatientInformationElement() {
            if (this.mySupportingPatientInformation == null) {
                this.mySupportingPatientInformation = new ArrayList<ResourceReferenceDt>();
            }
            return this.mySupportingPatientInformation;
        }

        public Recommendation setSupportingPatientInformation(List<ResourceReferenceDt> theValue) {
            this.mySupportingPatientInformation = theValue;
            return this;
        }

        public ResourceReferenceDt addSupportingPatientInformation() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getSupportingPatientInformation().add(newType);
            return newType;
        }
    }
}

