/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.AttachmentDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.GVFMeta;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="GVFVariant", profile="http://hl7.org/fhir/profiles/GVFVariant", id="gvfvariant")
public class GVFVariant
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="patient", path="GVFVariant.subject.patient", description="Patient being described", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_SUBJECT_PATIENT = new Include("GVFVariant.subject.patient");
    @SearchParamDefinition(name="coordinate", path="", description="Coordinate of the variant being studied", type="string")
    public static final String SP_COORDINATE = "coordinate";
    public static final StringClientParam COORDINATE = new StringClientParam("coordinate");
    @Child(name="subject", order=0, min=0, max=1)
    @Description(shortDefinition="Subject described by this segment of GVF file", formalDefinition="Subject described by this segment of GVF file")
    private Subject mySubject;
    @Child(name="meta", order=1, min=0, max=1, type={GVFMeta.class})
    @Description(shortDefinition="GVF Meta", formalDefinition="Meta information of a GVF file")
    private ResourceReferenceDt myMeta;
    @Child(name="sourceFile", type={AttachmentDt.class}, order=2, min=0, max=1)
    @Description(shortDefinition="Source file", formalDefinition="Source GVF file")
    private AttachmentDt mySourceFile;
    @Child(name="seqid", type={StringDt.class}, order=3, min=1, max=1)
    @Description(shortDefinition="Sequence Id", formalDefinition="Id the sequence being described")
    private StringDt mySeqid;
    @Child(name="source", type={StringDt.class}, order=4, min=1, max=1)
    @Description(shortDefinition="Data source", formalDefinition="Algorithm or software used to generate the data")
    private StringDt mySource;
    @Child(name="type", type={CodeDt.class}, order=5, min=1, max=1)
    @Description(shortDefinition="Feature type", formalDefinition="Type of the feature being described")
    private CodeDt myType;
    @Child(name="start", type={IntegerDt.class}, order=6, min=1, max=1)
    @Description(shortDefinition="Start position", formalDefinition="Start position")
    private IntegerDt myStart;
    @Child(name="end", type={IntegerDt.class}, order=7, min=1, max=1)
    @Description(shortDefinition="End position", formalDefinition="End position")
    private IntegerDt myEnd;
    @Child(name="score", type={IntegerDt.class}, order=8, min=1, max=1)
    @Description(shortDefinition="Sequence score", formalDefinition="Phred scaled score of the sequence")
    private IntegerDt myScore;
    @Child(name="strand", type={CodeDt.class}, order=9, min=1, max=1)
    @Description(shortDefinition="Strand", formalDefinition="Direction of the strand")
    private CodeDt myStrand;
    @Child(name="featureId", type={StringDt.class}, order=10, min=1, max=1)
    @Description(shortDefinition="Id of the feature", formalDefinition="Id of the attribute, unique to other segments in the same source file")
    private StringDt myFeatureId;
    @Child(name="alias", type={StringDt.class}, order=11, min=0, max=1)
    @Description(shortDefinition="Alias of the feature", formalDefinition="Alias of the feature being described")
    private StringDt myAlias;
    @Child(name="dbxref", order=12, min=0, max=1)
    @Description(shortDefinition="Reference of the feature in a database", formalDefinition="Reference of the feature in a database")
    private Dbxref myDbxref;
    @Child(name="variantSeq", type={StringDt.class}, order=13, min=1, max=-1)
    @Description(shortDefinition="Sequence presents in the variant", formalDefinition="Sequence presents in the variant")
    private List<StringDt> myVariantSeq;
    @Child(name="referenceSeq", type={StringDt.class}, order=14, min=0, max=1)
    @Description(shortDefinition="Reference sequence", formalDefinition="Reference sequence")
    private StringDt myReferenceSeq;
    @Child(name="variantFreq", type={DecimalDt.class}, order=15, min=0, max=-1)
    @Description(shortDefinition="Variant frequency", formalDefinition="Frequency of the variant")
    private List<DecimalDt> myVariantFreq;
    @Child(name="variantEffect", order=16, min=0, max=-1)
    @Description(shortDefinition="Variant effect", formalDefinition="Effect of the variant")
    private List<VariantEffect> myVariantEffect;
    @Child(name="startRange", order=17, min=0, max=1)
    @Description(shortDefinition="Start range", formalDefinition="Attribute describing ambiguity of the start position of the feature")
    private StartRange myStartRange;
    @Child(name="endRange", order=18, min=0, max=1)
    @Description(shortDefinition="End range", formalDefinition="Attribute describing ambiguity of the end position of the feature")
    private EndRange myEndRange;
    @Child(name="variantCodon", type={StringDt.class}, order=19, min=0, max=-1)
    @Description(shortDefinition="Codons that overlap with feature being described", formalDefinition="Codons that overlap with the feature being described")
    private List<StringDt> myVariantCodon;
    @Child(name="referenceCodon", type={StringDt.class}, order=20, min=0, max=1)
    @Description(shortDefinition="Codon that overlap with the reference sequence", formalDefinition="Codon that overlap with the reference sequence")
    private StringDt myReferenceCodon;
    @Child(name="variantAA", type={StringDt.class}, order=21, min=0, max=-1)
    @Description(shortDefinition="Amino acids that overlap with the features being described", formalDefinition="Amino acids that overlap with the features being described")
    private List<StringDt> myVariantAA;
    @Child(name="referenceAA", type={StringDt.class}, order=22, min=0, max=-1)
    @Description(shortDefinition="Amino acids that overlaps with the reference sequence", formalDefinition="Amino acids that overlaps with the reference sequence")
    private List<StringDt> myReferenceAA;
    @Child(name="breakpointDetail", order=23, min=0, max=1)
    @Description(shortDefinition="Coordinate of a variant with zero length", formalDefinition="Coordinate of a variant with zero length")
    private BreakpointDetail myBreakpointDetail;
    @Child(name="sequenceContext", order=24, min=0, max=1)
    @Description(shortDefinition="Context of features being described", formalDefinition="Sequences adjacent to the feature")
    private SequenceContext mySequenceContext;
    @Child(name="individual", type={StringDt.class}, order=25, min=0, max=-1)
    @Description(shortDefinition="Individuals being described", formalDefinition="Individuals for whom the feature is described")
    private List<StringDt> myIndividual;
    @Child(name="sample", order=26, min=0, max=-1)
    @Description(shortDefinition="Individual genotypic information", formalDefinition="Individual genotypic information")
    private List<Sample> mySample;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySubject, this.myMeta, this.mySourceFile, this.mySeqid, this.mySource, this.myType, this.myStart, this.myEnd, this.myScore, this.myStrand, this.myFeatureId, this.myAlias, this.myDbxref, this.myVariantSeq, this.myReferenceSeq, this.myVariantFreq, this.myVariantEffect, this.myStartRange, this.myEndRange, this.myVariantCodon, this.myReferenceCodon, this.myVariantAA, this.myReferenceAA, this.myBreakpointDetail, this.mySequenceContext, this.myIndividual, this.mySample});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySubject, this.myMeta, this.mySourceFile, this.mySeqid, this.mySource, this.myType, this.myStart, this.myEnd, this.myScore, this.myStrand, this.myFeatureId, this.myAlias, this.myDbxref, this.myVariantSeq, this.myReferenceSeq, this.myVariantFreq, this.myVariantEffect, this.myStartRange, this.myEndRange, this.myVariantCodon, this.myReferenceCodon, this.myVariantAA, this.myReferenceAA, this.myBreakpointDetail, this.mySequenceContext, this.myIndividual, this.mySample});
    }

    public Subject getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new Subject();
        }
        return this.mySubject;
    }

    public Subject getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new Subject();
        }
        return this.mySubject;
    }

    public GVFVariant setSubject(Subject theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getMeta() {
        if (this.myMeta == null) {
            this.myMeta = new ResourceReferenceDt();
        }
        return this.myMeta;
    }

    public ResourceReferenceDt getMetaElement() {
        if (this.myMeta == null) {
            this.myMeta = new ResourceReferenceDt();
        }
        return this.myMeta;
    }

    public GVFVariant setMeta(ResourceReferenceDt theValue) {
        this.myMeta = theValue;
        return this;
    }

    public AttachmentDt getSourceFile() {
        if (this.mySourceFile == null) {
            this.mySourceFile = new AttachmentDt();
        }
        return this.mySourceFile;
    }

    public AttachmentDt getSourceFileElement() {
        if (this.mySourceFile == null) {
            this.mySourceFile = new AttachmentDt();
        }
        return this.mySourceFile;
    }

    public GVFVariant setSourceFile(AttachmentDt theValue) {
        this.mySourceFile = theValue;
        return this;
    }

    public StringDt getSeqid() {
        if (this.mySeqid == null) {
            this.mySeqid = new StringDt();
        }
        return this.mySeqid;
    }

    public StringDt getSeqidElement() {
        if (this.mySeqid == null) {
            this.mySeqid = new StringDt();
        }
        return this.mySeqid;
    }

    public GVFVariant setSeqid(StringDt theValue) {
        this.mySeqid = theValue;
        return this;
    }

    public GVFVariant setSeqid(String theString) {
        this.mySeqid = new StringDt(theString);
        return this;
    }

    public StringDt getSource() {
        if (this.mySource == null) {
            this.mySource = new StringDt();
        }
        return this.mySource;
    }

    public StringDt getSourceElement() {
        if (this.mySource == null) {
            this.mySource = new StringDt();
        }
        return this.mySource;
    }

    public GVFVariant setSource(StringDt theValue) {
        this.mySource = theValue;
        return this;
    }

    public GVFVariant setSource(String theString) {
        this.mySource = new StringDt(theString);
        return this;
    }

    public CodeDt getType() {
        if (this.myType == null) {
            this.myType = new CodeDt();
        }
        return this.myType;
    }

    public CodeDt getTypeElement() {
        if (this.myType == null) {
            this.myType = new CodeDt();
        }
        return this.myType;
    }

    public GVFVariant setType(CodeDt theValue) {
        this.myType = theValue;
        return this;
    }

    public GVFVariant setType(String theCode) {
        this.myType = new CodeDt(theCode);
        return this;
    }

    public IntegerDt getStart() {
        if (this.myStart == null) {
            this.myStart = new IntegerDt();
        }
        return this.myStart;
    }

    public IntegerDt getStartElement() {
        if (this.myStart == null) {
            this.myStart = new IntegerDt();
        }
        return this.myStart;
    }

    public GVFVariant setStart(IntegerDt theValue) {
        this.myStart = theValue;
        return this;
    }

    public GVFVariant setStart(int theInteger) {
        this.myStart = new IntegerDt(theInteger);
        return this;
    }

    public IntegerDt getEnd() {
        if (this.myEnd == null) {
            this.myEnd = new IntegerDt();
        }
        return this.myEnd;
    }

    public IntegerDt getEndElement() {
        if (this.myEnd == null) {
            this.myEnd = new IntegerDt();
        }
        return this.myEnd;
    }

    public GVFVariant setEnd(IntegerDt theValue) {
        this.myEnd = theValue;
        return this;
    }

    public GVFVariant setEnd(int theInteger) {
        this.myEnd = new IntegerDt(theInteger);
        return this;
    }

    public IntegerDt getScore() {
        if (this.myScore == null) {
            this.myScore = new IntegerDt();
        }
        return this.myScore;
    }

    public IntegerDt getScoreElement() {
        if (this.myScore == null) {
            this.myScore = new IntegerDt();
        }
        return this.myScore;
    }

    public GVFVariant setScore(IntegerDt theValue) {
        this.myScore = theValue;
        return this;
    }

    public GVFVariant setScore(int theInteger) {
        this.myScore = new IntegerDt(theInteger);
        return this;
    }

    public CodeDt getStrand() {
        if (this.myStrand == null) {
            this.myStrand = new CodeDt();
        }
        return this.myStrand;
    }

    public CodeDt getStrandElement() {
        if (this.myStrand == null) {
            this.myStrand = new CodeDt();
        }
        return this.myStrand;
    }

    public GVFVariant setStrand(CodeDt theValue) {
        this.myStrand = theValue;
        return this;
    }

    public GVFVariant setStrand(String theCode) {
        this.myStrand = new CodeDt(theCode);
        return this;
    }

    public StringDt getFeatureId() {
        if (this.myFeatureId == null) {
            this.myFeatureId = new StringDt();
        }
        return this.myFeatureId;
    }

    public StringDt getFeatureIdElement() {
        if (this.myFeatureId == null) {
            this.myFeatureId = new StringDt();
        }
        return this.myFeatureId;
    }

    public GVFVariant setFeatureId(StringDt theValue) {
        this.myFeatureId = theValue;
        return this;
    }

    public GVFVariant setFeatureId(String theString) {
        this.myFeatureId = new StringDt(theString);
        return this;
    }

    public StringDt getAlias() {
        if (this.myAlias == null) {
            this.myAlias = new StringDt();
        }
        return this.myAlias;
    }

    public StringDt getAliasElement() {
        if (this.myAlias == null) {
            this.myAlias = new StringDt();
        }
        return this.myAlias;
    }

    public GVFVariant setAlias(StringDt theValue) {
        this.myAlias = theValue;
        return this;
    }

    public GVFVariant setAlias(String theString) {
        this.myAlias = new StringDt(theString);
        return this;
    }

    public Dbxref getDbxref() {
        if (this.myDbxref == null) {
            this.myDbxref = new Dbxref();
        }
        return this.myDbxref;
    }

    public Dbxref getDbxrefElement() {
        if (this.myDbxref == null) {
            this.myDbxref = new Dbxref();
        }
        return this.myDbxref;
    }

    public GVFVariant setDbxref(Dbxref theValue) {
        this.myDbxref = theValue;
        return this;
    }

    public List<StringDt> getVariantSeq() {
        if (this.myVariantSeq == null) {
            this.myVariantSeq = new ArrayList<StringDt>();
        }
        return this.myVariantSeq;
    }

    public List<StringDt> getVariantSeqElement() {
        if (this.myVariantSeq == null) {
            this.myVariantSeq = new ArrayList<StringDt>();
        }
        return this.myVariantSeq;
    }

    public GVFVariant setVariantSeq(List<StringDt> theValue) {
        this.myVariantSeq = theValue;
        return this;
    }

    public StringDt addVariantSeq() {
        StringDt newType = new StringDt();
        this.getVariantSeq().add(newType);
        return newType;
    }

    public StringDt getVariantSeqFirstRep() {
        if (this.getVariantSeq().isEmpty()) {
            return this.addVariantSeq();
        }
        return this.getVariantSeq().get(0);
    }

    public GVFVariant addVariantSeq(String theString) {
        if (this.myVariantSeq == null) {
            this.myVariantSeq = new ArrayList<StringDt>();
        }
        this.myVariantSeq.add(new StringDt(theString));
        return this;
    }

    public StringDt getReferenceSeq() {
        if (this.myReferenceSeq == null) {
            this.myReferenceSeq = new StringDt();
        }
        return this.myReferenceSeq;
    }

    public StringDt getReferenceSeqElement() {
        if (this.myReferenceSeq == null) {
            this.myReferenceSeq = new StringDt();
        }
        return this.myReferenceSeq;
    }

    public GVFVariant setReferenceSeq(StringDt theValue) {
        this.myReferenceSeq = theValue;
        return this;
    }

    public GVFVariant setReferenceSeq(String theString) {
        this.myReferenceSeq = new StringDt(theString);
        return this;
    }

    public List<DecimalDt> getVariantFreq() {
        if (this.myVariantFreq == null) {
            this.myVariantFreq = new ArrayList<DecimalDt>();
        }
        return this.myVariantFreq;
    }

    public List<DecimalDt> getVariantFreqElement() {
        if (this.myVariantFreq == null) {
            this.myVariantFreq = new ArrayList<DecimalDt>();
        }
        return this.myVariantFreq;
    }

    public GVFVariant setVariantFreq(List<DecimalDt> theValue) {
        this.myVariantFreq = theValue;
        return this;
    }

    public DecimalDt addVariantFreq() {
        DecimalDt newType = new DecimalDt();
        this.getVariantFreq().add(newType);
        return newType;
    }

    public DecimalDt getVariantFreqFirstRep() {
        if (this.getVariantFreq().isEmpty()) {
            return this.addVariantFreq();
        }
        return this.getVariantFreq().get(0);
    }

    public GVFVariant addVariantFreq(long theValue) {
        if (this.myVariantFreq == null) {
            this.myVariantFreq = new ArrayList<DecimalDt>();
        }
        this.myVariantFreq.add(new DecimalDt(theValue));
        return this;
    }

    public GVFVariant addVariantFreq(double theValue) {
        if (this.myVariantFreq == null) {
            this.myVariantFreq = new ArrayList<DecimalDt>();
        }
        this.myVariantFreq.add(new DecimalDt(theValue));
        return this;
    }

    public GVFVariant addVariantFreq(BigDecimal theValue) {
        if (this.myVariantFreq == null) {
            this.myVariantFreq = new ArrayList<DecimalDt>();
        }
        this.myVariantFreq.add(new DecimalDt(theValue));
        return this;
    }

    public List<VariantEffect> getVariantEffect() {
        if (this.myVariantEffect == null) {
            this.myVariantEffect = new ArrayList<VariantEffect>();
        }
        return this.myVariantEffect;
    }

    public List<VariantEffect> getVariantEffectElement() {
        if (this.myVariantEffect == null) {
            this.myVariantEffect = new ArrayList<VariantEffect>();
        }
        return this.myVariantEffect;
    }

    public GVFVariant setVariantEffect(List<VariantEffect> theValue) {
        this.myVariantEffect = theValue;
        return this;
    }

    public VariantEffect addVariantEffect() {
        VariantEffect newType = new VariantEffect();
        this.getVariantEffect().add(newType);
        return newType;
    }

    public VariantEffect getVariantEffectFirstRep() {
        if (this.getVariantEffect().isEmpty()) {
            return this.addVariantEffect();
        }
        return this.getVariantEffect().get(0);
    }

    public StartRange getStartRange() {
        if (this.myStartRange == null) {
            this.myStartRange = new StartRange();
        }
        return this.myStartRange;
    }

    public StartRange getStartRangeElement() {
        if (this.myStartRange == null) {
            this.myStartRange = new StartRange();
        }
        return this.myStartRange;
    }

    public GVFVariant setStartRange(StartRange theValue) {
        this.myStartRange = theValue;
        return this;
    }

    public EndRange getEndRange() {
        if (this.myEndRange == null) {
            this.myEndRange = new EndRange();
        }
        return this.myEndRange;
    }

    public EndRange getEndRangeElement() {
        if (this.myEndRange == null) {
            this.myEndRange = new EndRange();
        }
        return this.myEndRange;
    }

    public GVFVariant setEndRange(EndRange theValue) {
        this.myEndRange = theValue;
        return this;
    }

    public List<StringDt> getVariantCodon() {
        if (this.myVariantCodon == null) {
            this.myVariantCodon = new ArrayList<StringDt>();
        }
        return this.myVariantCodon;
    }

    public List<StringDt> getVariantCodonElement() {
        if (this.myVariantCodon == null) {
            this.myVariantCodon = new ArrayList<StringDt>();
        }
        return this.myVariantCodon;
    }

    public GVFVariant setVariantCodon(List<StringDt> theValue) {
        this.myVariantCodon = theValue;
        return this;
    }

    public StringDt addVariantCodon() {
        StringDt newType = new StringDt();
        this.getVariantCodon().add(newType);
        return newType;
    }

    public StringDt getVariantCodonFirstRep() {
        if (this.getVariantCodon().isEmpty()) {
            return this.addVariantCodon();
        }
        return this.getVariantCodon().get(0);
    }

    public GVFVariant addVariantCodon(String theString) {
        if (this.myVariantCodon == null) {
            this.myVariantCodon = new ArrayList<StringDt>();
        }
        this.myVariantCodon.add(new StringDt(theString));
        return this;
    }

    public StringDt getReferenceCodon() {
        if (this.myReferenceCodon == null) {
            this.myReferenceCodon = new StringDt();
        }
        return this.myReferenceCodon;
    }

    public StringDt getReferenceCodonElement() {
        if (this.myReferenceCodon == null) {
            this.myReferenceCodon = new StringDt();
        }
        return this.myReferenceCodon;
    }

    public GVFVariant setReferenceCodon(StringDt theValue) {
        this.myReferenceCodon = theValue;
        return this;
    }

    public GVFVariant setReferenceCodon(String theString) {
        this.myReferenceCodon = new StringDt(theString);
        return this;
    }

    public List<StringDt> getVariantAA() {
        if (this.myVariantAA == null) {
            this.myVariantAA = new ArrayList<StringDt>();
        }
        return this.myVariantAA;
    }

    public List<StringDt> getVariantAAElement() {
        if (this.myVariantAA == null) {
            this.myVariantAA = new ArrayList<StringDt>();
        }
        return this.myVariantAA;
    }

    public GVFVariant setVariantAA(List<StringDt> theValue) {
        this.myVariantAA = theValue;
        return this;
    }

    public StringDt addVariantAA() {
        StringDt newType = new StringDt();
        this.getVariantAA().add(newType);
        return newType;
    }

    public StringDt getVariantAAFirstRep() {
        if (this.getVariantAA().isEmpty()) {
            return this.addVariantAA();
        }
        return this.getVariantAA().get(0);
    }

    public GVFVariant addVariantAA(String theString) {
        if (this.myVariantAA == null) {
            this.myVariantAA = new ArrayList<StringDt>();
        }
        this.myVariantAA.add(new StringDt(theString));
        return this;
    }

    public List<StringDt> getReferenceAA() {
        if (this.myReferenceAA == null) {
            this.myReferenceAA = new ArrayList<StringDt>();
        }
        return this.myReferenceAA;
    }

    public List<StringDt> getReferenceAAElement() {
        if (this.myReferenceAA == null) {
            this.myReferenceAA = new ArrayList<StringDt>();
        }
        return this.myReferenceAA;
    }

    public GVFVariant setReferenceAA(List<StringDt> theValue) {
        this.myReferenceAA = theValue;
        return this;
    }

    public StringDt addReferenceAA() {
        StringDt newType = new StringDt();
        this.getReferenceAA().add(newType);
        return newType;
    }

    public StringDt getReferenceAAFirstRep() {
        if (this.getReferenceAA().isEmpty()) {
            return this.addReferenceAA();
        }
        return this.getReferenceAA().get(0);
    }

    public GVFVariant addReferenceAA(String theString) {
        if (this.myReferenceAA == null) {
            this.myReferenceAA = new ArrayList<StringDt>();
        }
        this.myReferenceAA.add(new StringDt(theString));
        return this;
    }

    public BreakpointDetail getBreakpointDetail() {
        if (this.myBreakpointDetail == null) {
            this.myBreakpointDetail = new BreakpointDetail();
        }
        return this.myBreakpointDetail;
    }

    public BreakpointDetail getBreakpointDetailElement() {
        if (this.myBreakpointDetail == null) {
            this.myBreakpointDetail = new BreakpointDetail();
        }
        return this.myBreakpointDetail;
    }

    public GVFVariant setBreakpointDetail(BreakpointDetail theValue) {
        this.myBreakpointDetail = theValue;
        return this;
    }

    public SequenceContext getSequenceContext() {
        if (this.mySequenceContext == null) {
            this.mySequenceContext = new SequenceContext();
        }
        return this.mySequenceContext;
    }

    public SequenceContext getSequenceContextElement() {
        if (this.mySequenceContext == null) {
            this.mySequenceContext = new SequenceContext();
        }
        return this.mySequenceContext;
    }

    public GVFVariant setSequenceContext(SequenceContext theValue) {
        this.mySequenceContext = theValue;
        return this;
    }

    public List<StringDt> getIndividual() {
        if (this.myIndividual == null) {
            this.myIndividual = new ArrayList<StringDt>();
        }
        return this.myIndividual;
    }

    public List<StringDt> getIndividualElement() {
        if (this.myIndividual == null) {
            this.myIndividual = new ArrayList<StringDt>();
        }
        return this.myIndividual;
    }

    public GVFVariant setIndividual(List<StringDt> theValue) {
        this.myIndividual = theValue;
        return this;
    }

    public StringDt addIndividual() {
        StringDt newType = new StringDt();
        this.getIndividual().add(newType);
        return newType;
    }

    public StringDt getIndividualFirstRep() {
        if (this.getIndividual().isEmpty()) {
            return this.addIndividual();
        }
        return this.getIndividual().get(0);
    }

    public GVFVariant addIndividual(String theString) {
        if (this.myIndividual == null) {
            this.myIndividual = new ArrayList<StringDt>();
        }
        this.myIndividual.add(new StringDt(theString));
        return this;
    }

    public List<Sample> getSample() {
        if (this.mySample == null) {
            this.mySample = new ArrayList<Sample>();
        }
        return this.mySample;
    }

    public List<Sample> getSampleElement() {
        if (this.mySample == null) {
            this.mySample = new ArrayList<Sample>();
        }
        return this.mySample;
    }

    public GVFVariant setSample(List<Sample> theValue) {
        this.mySample = theValue;
        return this;
    }

    public Sample addSample() {
        Sample newType = new Sample();
        this.getSample().add(newType);
        return newType;
    }

    public Sample getSampleFirstRep() {
        if (this.getSample().isEmpty()) {
            return this.addSample();
        }
        return this.getSample().get(0);
    }

    public String getResourceName() {
        return "GVFVariant";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Sample
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="phased", type={StringDt.class}, order=0, min=0, max=-1)
        @Description(shortDefinition="Phase status of the sequence", formalDefinition="Attribute describing the phasing of a sequence")
        private List<StringDt> myPhased;
        @Child(name="genotype", type={StringDt.class}, order=1, min=0, max=-1)
        @Description(shortDefinition="Genotype of individuals", formalDefinition="Genotypes of the individual")
        private List<StringDt> myGenotype;
        @Child(name="variantReads", type={IntegerDt.class}, order=2, min=0, max=-1)
        @Description(shortDefinition="Read number of the sequence", formalDefinition="Renumber of the sequence")
        private List<IntegerDt> myVariantReads;
        @Child(name="totalReads", type={IntegerDt.class}, order=3, min=0, max=1)
        @Description(shortDefinition="Total reads", formalDefinition="Total reads of all sequence present in the sample")
        private IntegerDt myTotalReads;
        @Child(name="zygosity", type={CodeDt.class}, order=4, min=0, max=1)
        @Description(shortDefinition="Zygosity", formalDefinition="Zygosity of the sequences")
        private CodeDt myZygosity;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myPhased, this.myGenotype, this.myVariantReads, this.myTotalReads, this.myZygosity});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myPhased, this.myGenotype, this.myVariantReads, this.myTotalReads, this.myZygosity});
        }

        public List<StringDt> getPhased() {
            if (this.myPhased == null) {
                this.myPhased = new ArrayList<StringDt>();
            }
            return this.myPhased;
        }

        public List<StringDt> getPhasedElement() {
            if (this.myPhased == null) {
                this.myPhased = new ArrayList<StringDt>();
            }
            return this.myPhased;
        }

        public Sample setPhased(List<StringDt> theValue) {
            this.myPhased = theValue;
            return this;
        }

        public StringDt addPhased() {
            StringDt newType = new StringDt();
            this.getPhased().add(newType);
            return newType;
        }

        public StringDt getPhasedFirstRep() {
            if (this.getPhased().isEmpty()) {
                return this.addPhased();
            }
            return this.getPhased().get(0);
        }

        public Sample addPhased(String theString) {
            if (this.myPhased == null) {
                this.myPhased = new ArrayList<StringDt>();
            }
            this.myPhased.add(new StringDt(theString));
            return this;
        }

        public List<StringDt> getGenotype() {
            if (this.myGenotype == null) {
                this.myGenotype = new ArrayList<StringDt>();
            }
            return this.myGenotype;
        }

        public List<StringDt> getGenotypeElement() {
            if (this.myGenotype == null) {
                this.myGenotype = new ArrayList<StringDt>();
            }
            return this.myGenotype;
        }

        public Sample setGenotype(List<StringDt> theValue) {
            this.myGenotype = theValue;
            return this;
        }

        public StringDt addGenotype() {
            StringDt newType = new StringDt();
            this.getGenotype().add(newType);
            return newType;
        }

        public StringDt getGenotypeFirstRep() {
            if (this.getGenotype().isEmpty()) {
                return this.addGenotype();
            }
            return this.getGenotype().get(0);
        }

        public Sample addGenotype(String theString) {
            if (this.myGenotype == null) {
                this.myGenotype = new ArrayList<StringDt>();
            }
            this.myGenotype.add(new StringDt(theString));
            return this;
        }

        public List<IntegerDt> getVariantReads() {
            if (this.myVariantReads == null) {
                this.myVariantReads = new ArrayList<IntegerDt>();
            }
            return this.myVariantReads;
        }

        public List<IntegerDt> getVariantReadsElement() {
            if (this.myVariantReads == null) {
                this.myVariantReads = new ArrayList<IntegerDt>();
            }
            return this.myVariantReads;
        }

        public Sample setVariantReads(List<IntegerDt> theValue) {
            this.myVariantReads = theValue;
            return this;
        }

        public IntegerDt addVariantReads() {
            IntegerDt newType = new IntegerDt();
            this.getVariantReads().add(newType);
            return newType;
        }

        public IntegerDt getVariantReadsFirstRep() {
            if (this.getVariantReads().isEmpty()) {
                return this.addVariantReads();
            }
            return this.getVariantReads().get(0);
        }

        public Sample addVariantReads(int theInteger) {
            if (this.myVariantReads == null) {
                this.myVariantReads = new ArrayList<IntegerDt>();
            }
            this.myVariantReads.add(new IntegerDt(theInteger));
            return this;
        }

        public IntegerDt getTotalReads() {
            if (this.myTotalReads == null) {
                this.myTotalReads = new IntegerDt();
            }
            return this.myTotalReads;
        }

        public IntegerDt getTotalReadsElement() {
            if (this.myTotalReads == null) {
                this.myTotalReads = new IntegerDt();
            }
            return this.myTotalReads;
        }

        public Sample setTotalReads(IntegerDt theValue) {
            this.myTotalReads = theValue;
            return this;
        }

        public Sample setTotalReads(int theInteger) {
            this.myTotalReads = new IntegerDt(theInteger);
            return this;
        }

        public CodeDt getZygosity() {
            if (this.myZygosity == null) {
                this.myZygosity = new CodeDt();
            }
            return this.myZygosity;
        }

        public CodeDt getZygosityElement() {
            if (this.myZygosity == null) {
                this.myZygosity = new CodeDt();
            }
            return this.myZygosity;
        }

        public Sample setZygosity(CodeDt theValue) {
            this.myZygosity = theValue;
            return this;
        }

        public Sample setZygosity(String theCode) {
            this.myZygosity = new CodeDt(theCode);
            return this;
        }
    }

    @Block
    public static class SequenceContext
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="fivePrime", type={StringDt.class}, order=0, min=1, max=1)
        @Description(shortDefinition="5 prime of the context", formalDefinition="Sequence adjacent to the feature at its 5 prime")
        private StringDt myFivePrime;
        @Child(name="threePrime", type={StringDt.class}, order=1, min=1, max=1)
        @Description(shortDefinition="3 prime of the context", formalDefinition="Sequence adjacent to the feature at its 3 prime")
        private StringDt myThreePrime;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myFivePrime, this.myThreePrime});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myFivePrime, this.myThreePrime});
        }

        public StringDt getFivePrime() {
            if (this.myFivePrime == null) {
                this.myFivePrime = new StringDt();
            }
            return this.myFivePrime;
        }

        public StringDt getFivePrimeElement() {
            if (this.myFivePrime == null) {
                this.myFivePrime = new StringDt();
            }
            return this.myFivePrime;
        }

        public SequenceContext setFivePrime(StringDt theValue) {
            this.myFivePrime = theValue;
            return this;
        }

        public SequenceContext setFivePrime(String theString) {
            this.myFivePrime = new StringDt(theString);
            return this;
        }

        public StringDt getThreePrime() {
            if (this.myThreePrime == null) {
                this.myThreePrime = new StringDt();
            }
            return this.myThreePrime;
        }

        public StringDt getThreePrimeElement() {
            if (this.myThreePrime == null) {
                this.myThreePrime = new StringDt();
            }
            return this.myThreePrime;
        }

        public SequenceContext setThreePrime(StringDt theValue) {
            this.myThreePrime = theValue;
            return this;
        }

        public SequenceContext setThreePrime(String theString) {
            this.myThreePrime = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class BreakpointDetail
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="seqid", type={StringDt.class}, order=0, min=1, max=1)
        @Description(shortDefinition="Sequence Id of the variant", formalDefinition="Sequence Id of the variant")
        private StringDt mySeqid;
        @Child(name="start", type={IntegerDt.class}, order=1, min=1, max=1)
        @Description(shortDefinition="Start position", formalDefinition="Start position")
        private IntegerDt myStart;
        @Child(name="end", type={IntegerDt.class}, order=2, min=1, max=1)
        @Description(shortDefinition="End position", formalDefinition="End position")
        private IntegerDt myEnd;
        @Child(name="strand", type={CodeDt.class}, order=3, min=1, max=1)
        @Description(shortDefinition="Strand", formalDefinition="Direction of strand")
        private CodeDt myStrand;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.mySeqid, this.myStart, this.myEnd, this.myStrand});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySeqid, this.myStart, this.myEnd, this.myStrand});
        }

        public StringDt getSeqid() {
            if (this.mySeqid == null) {
                this.mySeqid = new StringDt();
            }
            return this.mySeqid;
        }

        public StringDt getSeqidElement() {
            if (this.mySeqid == null) {
                this.mySeqid = new StringDt();
            }
            return this.mySeqid;
        }

        public BreakpointDetail setSeqid(StringDt theValue) {
            this.mySeqid = theValue;
            return this;
        }

        public BreakpointDetail setSeqid(String theString) {
            this.mySeqid = new StringDt(theString);
            return this;
        }

        public IntegerDt getStart() {
            if (this.myStart == null) {
                this.myStart = new IntegerDt();
            }
            return this.myStart;
        }

        public IntegerDt getStartElement() {
            if (this.myStart == null) {
                this.myStart = new IntegerDt();
            }
            return this.myStart;
        }

        public BreakpointDetail setStart(IntegerDt theValue) {
            this.myStart = theValue;
            return this;
        }

        public BreakpointDetail setStart(int theInteger) {
            this.myStart = new IntegerDt(theInteger);
            return this;
        }

        public IntegerDt getEnd() {
            if (this.myEnd == null) {
                this.myEnd = new IntegerDt();
            }
            return this.myEnd;
        }

        public IntegerDt getEndElement() {
            if (this.myEnd == null) {
                this.myEnd = new IntegerDt();
            }
            return this.myEnd;
        }

        public BreakpointDetail setEnd(IntegerDt theValue) {
            this.myEnd = theValue;
            return this;
        }

        public BreakpointDetail setEnd(int theInteger) {
            this.myEnd = new IntegerDt(theInteger);
            return this;
        }

        public CodeDt getStrand() {
            if (this.myStrand == null) {
                this.myStrand = new CodeDt();
            }
            return this.myStrand;
        }

        public CodeDt getStrandElement() {
            if (this.myStrand == null) {
                this.myStrand = new CodeDt();
            }
            return this.myStrand;
        }

        public BreakpointDetail setStrand(CodeDt theValue) {
            this.myStrand = theValue;
            return this;
        }

        public BreakpointDetail setStrand(String theCode) {
            this.myStrand = new CodeDt(theCode);
            return this;
        }
    }

    @Block
    public static class EndRange
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="start", type={IntegerDt.class}, order=0, min=1, max=1)
        @Description(shortDefinition="Start of the end range", formalDefinition="Start of the end range")
        private IntegerDt myStart;
        @Child(name="end", type={IntegerDt.class}, order=1, min=1, max=1)
        @Description(shortDefinition="End of the end range", formalDefinition="End of the end range")
        private IntegerDt myEnd;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myStart, this.myEnd});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myStart, this.myEnd});
        }

        public IntegerDt getStart() {
            if (this.myStart == null) {
                this.myStart = new IntegerDt();
            }
            return this.myStart;
        }

        public IntegerDt getStartElement() {
            if (this.myStart == null) {
                this.myStart = new IntegerDt();
            }
            return this.myStart;
        }

        public EndRange setStart(IntegerDt theValue) {
            this.myStart = theValue;
            return this;
        }

        public EndRange setStart(int theInteger) {
            this.myStart = new IntegerDt(theInteger);
            return this;
        }

        public IntegerDt getEnd() {
            if (this.myEnd == null) {
                this.myEnd = new IntegerDt();
            }
            return this.myEnd;
        }

        public IntegerDt getEndElement() {
            if (this.myEnd == null) {
                this.myEnd = new IntegerDt();
            }
            return this.myEnd;
        }

        public EndRange setEnd(IntegerDt theValue) {
            this.myEnd = theValue;
            return this;
        }

        public EndRange setEnd(int theInteger) {
            this.myEnd = new IntegerDt(theInteger);
            return this;
        }
    }

    @Block
    public static class StartRange
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="start", type={IntegerDt.class}, order=0, min=1, max=1)
        @Description(shortDefinition="Start of the start range", formalDefinition="Start of the start range")
        private IntegerDt myStart;
        @Child(name="end", type={IntegerDt.class}, order=1, min=1, max=1)
        @Description(shortDefinition="End of the start range", formalDefinition="End of the start range")
        private IntegerDt myEnd;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myStart, this.myEnd});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myStart, this.myEnd});
        }

        public IntegerDt getStart() {
            if (this.myStart == null) {
                this.myStart = new IntegerDt();
            }
            return this.myStart;
        }

        public IntegerDt getStartElement() {
            if (this.myStart == null) {
                this.myStart = new IntegerDt();
            }
            return this.myStart;
        }

        public StartRange setStart(IntegerDt theValue) {
            this.myStart = theValue;
            return this;
        }

        public StartRange setStart(int theInteger) {
            this.myStart = new IntegerDt(theInteger);
            return this;
        }

        public IntegerDt getEnd() {
            if (this.myEnd == null) {
                this.myEnd = new IntegerDt();
            }
            return this.myEnd;
        }

        public IntegerDt getEndElement() {
            if (this.myEnd == null) {
                this.myEnd = new IntegerDt();
            }
            return this.myEnd;
        }

        public StartRange setEnd(IntegerDt theValue) {
            this.myEnd = theValue;
            return this;
        }

        public StartRange setEnd(int theInteger) {
            this.myEnd = new IntegerDt(theInteger);
            return this;
        }
    }

    @Block
    public static class VariantEffect
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="sequenceVariant", type={CodeDt.class}, order=0, min=1, max=1)
        @Description(shortDefinition="Effect of the variant", formalDefinition="Effect of the variant")
        private CodeDt mySequenceVariant;
        @Child(name="index", type={IntegerDt.class}, order=1, min=1, max=1)
        @Description(shortDefinition="Index of variant being discussed", formalDefinition="Zero-based index that tells the variant being discussed")
        private IntegerDt myIndex;
        @Child(name="featureType", type={CodeDt.class}, order=2, min=1, max=1)
        @Description(shortDefinition="Feature type", formalDefinition="Type of the feature being described")
        private CodeDt myFeatureType;
        @Child(name="featureId", type={StringDt.class}, order=3, min=1, max=-1)
        @Description(shortDefinition="Feature Id", formalDefinition="Id of features being affected by the variant")
        private List<StringDt> myFeatureId;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.mySequenceVariant, this.myIndex, this.myFeatureType, this.myFeatureId});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.mySequenceVariant, this.myIndex, this.myFeatureType, this.myFeatureId});
        }

        public CodeDt getSequenceVariant() {
            if (this.mySequenceVariant == null) {
                this.mySequenceVariant = new CodeDt();
            }
            return this.mySequenceVariant;
        }

        public CodeDt getSequenceVariantElement() {
            if (this.mySequenceVariant == null) {
                this.mySequenceVariant = new CodeDt();
            }
            return this.mySequenceVariant;
        }

        public VariantEffect setSequenceVariant(CodeDt theValue) {
            this.mySequenceVariant = theValue;
            return this;
        }

        public VariantEffect setSequenceVariant(String theCode) {
            this.mySequenceVariant = new CodeDt(theCode);
            return this;
        }

        public IntegerDt getIndex() {
            if (this.myIndex == null) {
                this.myIndex = new IntegerDt();
            }
            return this.myIndex;
        }

        public IntegerDt getIndexElement() {
            if (this.myIndex == null) {
                this.myIndex = new IntegerDt();
            }
            return this.myIndex;
        }

        public VariantEffect setIndex(IntegerDt theValue) {
            this.myIndex = theValue;
            return this;
        }

        public VariantEffect setIndex(int theInteger) {
            this.myIndex = new IntegerDt(theInteger);
            return this;
        }

        public CodeDt getFeatureType() {
            if (this.myFeatureType == null) {
                this.myFeatureType = new CodeDt();
            }
            return this.myFeatureType;
        }

        public CodeDt getFeatureTypeElement() {
            if (this.myFeatureType == null) {
                this.myFeatureType = new CodeDt();
            }
            return this.myFeatureType;
        }

        public VariantEffect setFeatureType(CodeDt theValue) {
            this.myFeatureType = theValue;
            return this;
        }

        public VariantEffect setFeatureType(String theCode) {
            this.myFeatureType = new CodeDt(theCode);
            return this;
        }

        public List<StringDt> getFeatureId() {
            if (this.myFeatureId == null) {
                this.myFeatureId = new ArrayList<StringDt>();
            }
            return this.myFeatureId;
        }

        public List<StringDt> getFeatureIdElement() {
            if (this.myFeatureId == null) {
                this.myFeatureId = new ArrayList<StringDt>();
            }
            return this.myFeatureId;
        }

        public VariantEffect setFeatureId(List<StringDt> theValue) {
            this.myFeatureId = theValue;
            return this;
        }

        public StringDt addFeatureId() {
            StringDt newType = new StringDt();
            this.getFeatureId().add(newType);
            return newType;
        }

        public StringDt getFeatureIdFirstRep() {
            if (this.getFeatureId().isEmpty()) {
                return this.addFeatureId();
            }
            return this.getFeatureId().get(0);
        }

        public VariantEffect addFeatureId(String theString) {
            if (this.myFeatureId == null) {
                this.myFeatureId = new ArrayList<StringDt>();
            }
            this.myFeatureId.add(new StringDt(theString));
            return this;
        }
    }

    @Block
    public static class Dbxref
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="database", type={CodeDt.class}, order=0, min=1, max=1)
        @Description(shortDefinition="Name of the database", formalDefinition="Name of the database")
        private CodeDt myDatabase;
        @Child(name="identity", type={StringDt.class}, order=1, min=1, max=1)
        @Description(shortDefinition="Id of the feature within the database", formalDefinition="Id of the feature within the database")
        private StringDt myIdentity;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myDatabase, this.myIdentity});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDatabase, this.myIdentity});
        }

        public CodeDt getDatabase() {
            if (this.myDatabase == null) {
                this.myDatabase = new CodeDt();
            }
            return this.myDatabase;
        }

        public CodeDt getDatabaseElement() {
            if (this.myDatabase == null) {
                this.myDatabase = new CodeDt();
            }
            return this.myDatabase;
        }

        public Dbxref setDatabase(CodeDt theValue) {
            this.myDatabase = theValue;
            return this;
        }

        public Dbxref setDatabase(String theCode) {
            this.myDatabase = new CodeDt(theCode);
            return this;
        }

        public StringDt getIdentity() {
            if (this.myIdentity == null) {
                this.myIdentity = new StringDt();
            }
            return this.myIdentity;
        }

        public StringDt getIdentityElement() {
            if (this.myIdentity == null) {
                this.myIdentity = new StringDt();
            }
            return this.myIdentity;
        }

        public Dbxref setIdentity(StringDt theValue) {
            this.myIdentity = theValue;
            return this;
        }

        public Dbxref setIdentity(String theString) {
            this.myIdentity = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class Subject
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="patient", order=0, min=1, max=1, type={Patient.class})
        @Description(shortDefinition="Subject", formalDefinition="Patient resource that stores information of the subejct")
        private ResourceReferenceDt myPatient;
        @Child(name="fileId", type={StringDt.class}, order=1, min=0, max=1)
        @Description(shortDefinition="Individual Id", formalDefinition="Id of individual in GVF file that corresponds to the subject (only mandatory if the file is a multi-individual one")
        private StringDt myFileId;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myPatient, this.myFileId});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myPatient, this.myFileId});
        }

        public ResourceReferenceDt getPatient() {
            if (this.myPatient == null) {
                this.myPatient = new ResourceReferenceDt();
            }
            return this.myPatient;
        }

        public ResourceReferenceDt getPatientElement() {
            if (this.myPatient == null) {
                this.myPatient = new ResourceReferenceDt();
            }
            return this.myPatient;
        }

        public Subject setPatient(ResourceReferenceDt theValue) {
            this.myPatient = theValue;
            return this;
        }

        public StringDt getFileId() {
            if (this.myFileId == null) {
                this.myFileId = new StringDt();
            }
            return this.myFileId;
        }

        public StringDt getFileIdElement() {
            if (this.myFileId == null) {
                this.myFileId = new StringDt();
            }
            return this.myFileId;
        }

        public Subject setFileId(StringDt theValue) {
            this.myFileId = theValue;
            return this;
        }

        public Subject setFileId(String theString) {
            this.myFileId = new StringDt(theString);
            return this;
        }
    }
}

