/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Binary;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.DocumentReference;
import ca.uhn.fhir.model.dstu.resource.Group;
import ca.uhn.fhir.model.dstu.resource.Media;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu.valueset.DocumentReferenceStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.StringClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="DocumentManifest", profile="http://hl7.org/fhir/profiles/DocumentManifest", id="documentmanifest")
public class DocumentManifest
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="identifier", path="DocumentManifest.masterIdentifier | DocumentManifest.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="subject", path="DocumentManifest.subject", description="", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("DocumentManifest.subject");
    @SearchParamDefinition(name="type", path="DocumentManifest.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="recipient", path="DocumentManifest.recipient", description="", type="reference")
    public static final String SP_RECIPIENT = "recipient";
    public static final ReferenceClientParam RECIPIENT = new ReferenceClientParam("recipient");
    public static final Include INCLUDE_RECIPIENT = new Include("DocumentManifest.recipient");
    @SearchParamDefinition(name="author", path="DocumentManifest.author", description="", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("DocumentManifest.author");
    @SearchParamDefinition(name="created", path="DocumentManifest.created", description="", type="date")
    public static final String SP_CREATED = "created";
    public static final DateClientParam CREATED = new DateClientParam("created");
    @SearchParamDefinition(name="status", path="DocumentManifest.status", description="", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="supersedes", path="DocumentManifest.supercedes", description="", type="reference")
    public static final String SP_SUPERSEDES = "supersedes";
    public static final ReferenceClientParam SUPERSEDES = new ReferenceClientParam("supersedes");
    public static final Include INCLUDE_SUPERCEDES = new Include("DocumentManifest.supercedes");
    @SearchParamDefinition(name="description", path="DocumentManifest.description", description="", type="string")
    public static final String SP_DESCRIPTION = "description";
    public static final StringClientParam DESCRIPTION = new StringClientParam("description");
    @SearchParamDefinition(name="confidentiality", path="DocumentManifest.confidentiality", description="", type="token")
    public static final String SP_CONFIDENTIALITY = "confidentiality";
    public static final TokenClientParam CONFIDENTIALITY = new TokenClientParam("confidentiality");
    @SearchParamDefinition(name="content", path="DocumentManifest.content", description="", type="reference")
    public static final String SP_CONTENT = "content";
    public static final ReferenceClientParam CONTENT = new ReferenceClientParam("content");
    public static final Include INCLUDE_CONTENT = new Include("DocumentManifest.content");
    @Child(name="masterIdentifier", type={IdentifierDt.class}, order=0, min=1, max=1)
    @Description(shortDefinition="Unique Identifier for the set of documents", formalDefinition="A single identifier that uniquely identifies this manifest. Principally used to refer to the manifest in non-FHIR contexts")
    private IdentifierDt myMasterIdentifier;
    @Child(name="identifier", type={IdentifierDt.class}, order=1, min=0, max=-1)
    @Description(shortDefinition="Other identifiers for the manifest", formalDefinition="Other identifiers associated with the document, including version independent, source record and workflow related identifiers")
    private List<IdentifierDt> myIdentifier;
    @Child(name="subject", order=2, min=1, max=-1, type={Patient.class, Practitioner.class, Group.class, Device.class})
    @Description(shortDefinition="The subject of the set of documents", formalDefinition="Who or what the set of documents is about. The documents can be about a person, (patient or healthcare practitioner), a device (i.e. machine) or even a group of subjects (such as a document about a herd of farm animals, or a set of patients that share a common exposure). If the documents cross more than one subject, then more than one subject is allowed here (unusual use case)")
    private List<ResourceReferenceDt> mySubject;
    @Child(name="recipient", order=3, min=0, max=-1, type={Patient.class, Practitioner.class, Organization.class})
    @Description(shortDefinition="Intended to get notified about this set of documents", formalDefinition="A patient, practitioner, or organization for which this set of documents is intended")
    private List<ResourceReferenceDt> myRecipient;
    @Child(name="type", type={CodeableConceptDt.class}, order=4, min=0, max=1)
    @Description(shortDefinition="What kind of document set this is", formalDefinition="Specifies the kind of this set of documents (e.g. Patient Summary, Discharge Summary, Prescription, etc.). The type of a set of documents may be the same as one of the documents in it - especially if there is only one - but it may be wider")
    private CodeableConceptDt myType;
    @Child(name="author", order=5, min=0, max=-1, type={Practitioner.class, Device.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="Who and/or what authored the document", formalDefinition="Identifies who is responsible for adding the information to the document")
    private List<ResourceReferenceDt> myAuthor;
    @Child(name="created", type={DateTimeDt.class}, order=6, min=0, max=1)
    @Description(shortDefinition="When this document manifest created", formalDefinition="When the document manifest was created for submission to the server (not necessarily the same thing as the actual resource last modified time, since it may be modified, replicated etc)")
    private DateTimeDt myCreated;
    @Child(name="source", type={UriDt.class}, order=7, min=0, max=1)
    @Description(shortDefinition="The source system/application/software", formalDefinition="Identifies the source system, application, or software that produced the document manifest")
    private UriDt mySource;
    @Child(name="status", type={CodeDt.class}, order=8, min=1, max=1)
    @Description(shortDefinition="current | superceded | entered in error", formalDefinition="The status of this document manifest")
    private BoundCodeDt<DocumentReferenceStatusEnum> myStatus;
    @Child(name="supercedes", order=9, min=0, max=1, type={DocumentManifest.class})
    @Description(shortDefinition="If this document manifest replaces another", formalDefinition="Whether this document manifest replaces another")
    private ResourceReferenceDt mySupercedes;
    @Child(name="description", type={StringDt.class}, order=10, min=0, max=1)
    @Description(shortDefinition="Human-readable description (title)", formalDefinition="Human-readable description of the source document. This is sometimes known as the \"title\"")
    private StringDt myDescription;
    @Child(name="confidentiality", type={CodeableConceptDt.class}, order=11, min=0, max=1)
    @Description(shortDefinition="Sensitivity of set of documents", formalDefinition="A code specifying the level of confidentiality of this set of Documents")
    private CodeableConceptDt myConfidentiality;
    @Child(name="content", order=12, min=1, max=-1, type={DocumentReference.class, Binary.class, Media.class})
    @Description(shortDefinition="Contents of this set of documents", formalDefinition="The list of resources that describe the parts of this document reference. Usually, these would be document references, but direct references to binary attachments and images are also allowed")
    private List<ResourceReferenceDt> myContent;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myMasterIdentifier, this.myIdentifier, this.mySubject, this.myRecipient, this.myType, this.myAuthor, this.myCreated, this.mySource, this.myStatus, this.mySupercedes, this.myDescription, this.myConfidentiality, this.myContent});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myMasterIdentifier, this.myIdentifier, this.mySubject, this.myRecipient, this.myType, this.myAuthor, this.myCreated, this.mySource, this.myStatus, this.mySupercedes, this.myDescription, this.myConfidentiality, this.myContent});
    }

    public IdentifierDt getMasterIdentifier() {
        if (this.myMasterIdentifier == null) {
            this.myMasterIdentifier = new IdentifierDt();
        }
        return this.myMasterIdentifier;
    }

    public IdentifierDt getMasterIdentifierElement() {
        if (this.myMasterIdentifier == null) {
            this.myMasterIdentifier = new IdentifierDt();
        }
        return this.myMasterIdentifier;
    }

    public DocumentManifest setMasterIdentifier(IdentifierDt theValue) {
        this.myMasterIdentifier = theValue;
        return this;
    }

    public DocumentManifest setMasterIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        this.myMasterIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
        return this;
    }

    public DocumentManifest setMasterIdentifier(String theSystem, String theValue) {
        this.myMasterIdentifier = new IdentifierDt(theSystem, theValue);
        return this;
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public DocumentManifest setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public DocumentManifest addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public DocumentManifest addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public List<ResourceReferenceDt> getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySubject;
    }

    public List<ResourceReferenceDt> getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySubject;
    }

    public DocumentManifest setSubject(List<ResourceReferenceDt> theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt addSubject() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getSubject().add(newType);
        return newType;
    }

    public List<ResourceReferenceDt> getRecipient() {
        if (this.myRecipient == null) {
            this.myRecipient = new ArrayList<ResourceReferenceDt>();
        }
        return this.myRecipient;
    }

    public List<ResourceReferenceDt> getRecipientElement() {
        if (this.myRecipient == null) {
            this.myRecipient = new ArrayList<ResourceReferenceDt>();
        }
        return this.myRecipient;
    }

    public DocumentManifest setRecipient(List<ResourceReferenceDt> theValue) {
        this.myRecipient = theValue;
        return this;
    }

    public ResourceReferenceDt addRecipient() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getRecipient().add(newType);
        return newType;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public CodeableConceptDt getTypeElement() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public DocumentManifest setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ArrayList<ResourceReferenceDt>();
        }
        return this.myAuthor;
    }

    public List<ResourceReferenceDt> getAuthorElement() {
        if (this.myAuthor == null) {
            this.myAuthor = new ArrayList<ResourceReferenceDt>();
        }
        return this.myAuthor;
    }

    public DocumentManifest setAuthor(List<ResourceReferenceDt> theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public ResourceReferenceDt addAuthor() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getAuthor().add(newType);
        return newType;
    }

    public DateTimeDt getCreated() {
        if (this.myCreated == null) {
            this.myCreated = new DateTimeDt();
        }
        return this.myCreated;
    }

    public DateTimeDt getCreatedElement() {
        if (this.myCreated == null) {
            this.myCreated = new DateTimeDt();
        }
        return this.myCreated;
    }

    public DocumentManifest setCreated(DateTimeDt theValue) {
        this.myCreated = theValue;
        return this;
    }

    public DocumentManifest setCreated(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myCreated = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public DocumentManifest setCreatedWithSecondsPrecision(Date theDate) {
        this.myCreated = new DateTimeDt(theDate);
        return this;
    }

    public UriDt getSource() {
        if (this.mySource == null) {
            this.mySource = new UriDt();
        }
        return this.mySource;
    }

    public UriDt getSourceElement() {
        if (this.mySource == null) {
            this.mySource = new UriDt();
        }
        return this.mySource;
    }

    public DocumentManifest setSource(UriDt theValue) {
        this.mySource = theValue;
        return this;
    }

    public DocumentManifest setSource(String theUri) {
        this.mySource = new UriDt(theUri);
        return this;
    }

    public BoundCodeDt<DocumentReferenceStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(DocumentReferenceStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<DocumentReferenceStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(DocumentReferenceStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public DocumentManifest setStatus(BoundCodeDt<DocumentReferenceStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public DocumentManifest setStatus(DocumentReferenceStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public ResourceReferenceDt getSupercedes() {
        if (this.mySupercedes == null) {
            this.mySupercedes = new ResourceReferenceDt();
        }
        return this.mySupercedes;
    }

    public ResourceReferenceDt getSupercedesElement() {
        if (this.mySupercedes == null) {
            this.mySupercedes = new ResourceReferenceDt();
        }
        return this.mySupercedes;
    }

    public DocumentManifest setSupercedes(ResourceReferenceDt theValue) {
        this.mySupercedes = theValue;
        return this;
    }

    public StringDt getDescription() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public StringDt getDescriptionElement() {
        if (this.myDescription == null) {
            this.myDescription = new StringDt();
        }
        return this.myDescription;
    }

    public DocumentManifest setDescription(StringDt theValue) {
        this.myDescription = theValue;
        return this;
    }

    public DocumentManifest setDescription(String theString) {
        this.myDescription = new StringDt(theString);
        return this;
    }

    public CodeableConceptDt getConfidentiality() {
        if (this.myConfidentiality == null) {
            this.myConfidentiality = new CodeableConceptDt();
        }
        return this.myConfidentiality;
    }

    public CodeableConceptDt getConfidentialityElement() {
        if (this.myConfidentiality == null) {
            this.myConfidentiality = new CodeableConceptDt();
        }
        return this.myConfidentiality;
    }

    public DocumentManifest setConfidentiality(CodeableConceptDt theValue) {
        this.myConfidentiality = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getContent() {
        if (this.myContent == null) {
            this.myContent = new ArrayList<ResourceReferenceDt>();
        }
        return this.myContent;
    }

    public List<ResourceReferenceDt> getContentElement() {
        if (this.myContent == null) {
            this.myContent = new ArrayList<ResourceReferenceDt>();
        }
        return this.myContent;
    }

    public DocumentManifest setContent(List<ResourceReferenceDt> theValue) {
        this.myContent = theValue;
        return this;
    }

    public ResourceReferenceDt addContent() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getContent().add(newType);
        return newType;
    }

    public String getResourceName() {
        return "DocumentManifest";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }
}

