/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.AddressDt;
import ca.uhn.fhir.model.dstu.composite.CodingDt;
import ca.uhn.fhir.model.dstu.composite.HumanNameDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.DateDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Coverage", profile="http://hl7.org/fhir/profiles/Coverage", id="coverage")
public class Coverage
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="issuer", path="Coverage.issuer", description="The identity of the insurer", type="reference")
    public static final String SP_ISSUER = "issuer";
    public static final ReferenceClientParam ISSUER = new ReferenceClientParam("issuer");
    public static final Include INCLUDE_ISSUER = new Include("Coverage.issuer");
    @SearchParamDefinition(name="identifier", path="Coverage.identifier", description="The primary identifier of the insured", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @SearchParamDefinition(name="type", path="Coverage.type", description="The kind of coverage", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="plan", path="Coverage.plan", description="A plan or policy identifier", type="token")
    public static final String SP_PLAN = "plan";
    public static final TokenClientParam PLAN = new TokenClientParam("plan");
    @SearchParamDefinition(name="subplan", path="Coverage.subplan", description="Sub-plan identifier", type="token")
    public static final String SP_SUBPLAN = "subplan";
    public static final TokenClientParam SUBPLAN = new TokenClientParam("subplan");
    @SearchParamDefinition(name="group", path="Coverage.group", description="Group identifier", type="token")
    public static final String SP_GROUP = "group";
    public static final TokenClientParam GROUP = new TokenClientParam("group");
    @SearchParamDefinition(name="dependent", path="Coverage.dependent", description="Dependent number", type="token")
    public static final String SP_DEPENDENT = "dependent";
    public static final TokenClientParam DEPENDENT = new TokenClientParam("dependent");
    @SearchParamDefinition(name="sequence", path="Coverage.sequence", description="Sequence number", type="token")
    public static final String SP_SEQUENCE = "sequence";
    public static final TokenClientParam SEQUENCE = new TokenClientParam("sequence");
    @SearchParamDefinition(name="name", path="Coverage.subscriber.name", description="The name of the subscriber", type="token")
    public static final String SP_NAME = "name";
    public static final TokenClientParam NAME = new TokenClientParam("name");
    @Child(name="issuer", order=0, min=0, max=1, type={Organization.class})
    @Description(shortDefinition="An identifier for the plan issuer", formalDefinition="The program or plan underwriter or payor.")
    private ResourceReferenceDt myIssuer;
    @Child(name="period", type={PeriodDt.class}, order=1, min=0, max=1)
    @Description(shortDefinition="Coverage start and end dates", formalDefinition="Time period during which the coverage is in force. A missing start date indicates the start date isn't known, a missing end date means the coverage is continuing to be in force.")
    private PeriodDt myPeriod;
    @Child(name="type", type={CodingDt.class}, order=2, min=1, max=1)
    @Description(shortDefinition="Type of coverage", formalDefinition="The type of coverage: social program, medical plan, accident coverage (workers compensation, auto), group health.")
    private CodingDt myType;
    @Child(name="identifier", type={IdentifierDt.class}, order=3, min=0, max=1)
    @Description(shortDefinition="The primary coverage ID", formalDefinition="The main (and possibly only) identifier for the coverage - often referred to as a Subscriber Id, Certificate number or Personal Health Number or Case ID.")
    private IdentifierDt myIdentifier;
    @Child(name="group", type={IdentifierDt.class}, order=4, min=0, max=1)
    @Description(shortDefinition="An identifier for the group", formalDefinition="Todo")
    private IdentifierDt myGroup;
    @Child(name="plan", type={IdentifierDt.class}, order=5, min=0, max=1)
    @Description(shortDefinition="An identifier for the plan", formalDefinition="Identifies a style or collective of coverage issues by the underwriter, for example may be used to identify a class of coverage or employer group. May also be referred to as a Policy or Group ID.")
    private IdentifierDt myPlan;
    @Child(name="subplan", type={IdentifierDt.class}, order=6, min=0, max=1)
    @Description(shortDefinition="An identifier for the subsection of the plan", formalDefinition="Identifies a sub-style or sub-collective of coverage issues by the underwriter, for example may be used to identify a specific employer group within a class of employers. May be referred to as a Section or Division ID.")
    private IdentifierDt mySubplan;
    @Child(name="dependent", type={IntegerDt.class}, order=7, min=0, max=1)
    @Description(shortDefinition="The dependent number", formalDefinition="A unique identifier for a dependent under the coverage.")
    private IntegerDt myDependent;
    @Child(name="sequence", type={IntegerDt.class}, order=8, min=0, max=1)
    @Description(shortDefinition="The plan instance or sequence counter", formalDefinition="An optional counter for a particular instance of the identified coverage which increments upon each renewal.")
    private IntegerDt mySequence;
    @Child(name="subscriber", order=9, min=0, max=1)
    @Description(shortDefinition="Planholder information", formalDefinition="")
    private Subscriber mySubscriber;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myIssuer, this.myPeriod, this.myType, this.myIdentifier, this.myGroup, this.myPlan, this.mySubplan, this.myDependent, this.mySequence, this.mySubscriber});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIssuer, this.myPeriod, this.myType, this.myIdentifier, this.myGroup, this.myPlan, this.mySubplan, this.myDependent, this.mySequence, this.mySubscriber});
    }

    public ResourceReferenceDt getIssuer() {
        if (this.myIssuer == null) {
            this.myIssuer = new ResourceReferenceDt();
        }
        return this.myIssuer;
    }

    public ResourceReferenceDt getIssuerElement() {
        if (this.myIssuer == null) {
            this.myIssuer = new ResourceReferenceDt();
        }
        return this.myIssuer;
    }

    public Coverage setIssuer(ResourceReferenceDt theValue) {
        this.myIssuer = theValue;
        return this;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public PeriodDt getPeriodElement() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public Coverage setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public CodingDt getType() {
        if (this.myType == null) {
            this.myType = new CodingDt();
        }
        return this.myType;
    }

    public CodingDt getTypeElement() {
        if (this.myType == null) {
            this.myType = new CodingDt();
        }
        return this.myType;
    }

    public Coverage setType(CodingDt theValue) {
        this.myType = theValue;
        return this;
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public IdentifierDt getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public Coverage setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public Coverage setIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        this.myIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
        return this;
    }

    public Coverage setIdentifier(String theSystem, String theValue) {
        this.myIdentifier = new IdentifierDt(theSystem, theValue);
        return this;
    }

    public IdentifierDt getGroup() {
        if (this.myGroup == null) {
            this.myGroup = new IdentifierDt();
        }
        return this.myGroup;
    }

    public IdentifierDt getGroupElement() {
        if (this.myGroup == null) {
            this.myGroup = new IdentifierDt();
        }
        return this.myGroup;
    }

    public Coverage setGroup(IdentifierDt theValue) {
        this.myGroup = theValue;
        return this;
    }

    public Coverage setGroup(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        this.myGroup = new IdentifierDt(theUse, theSystem, theValue, theLabel);
        return this;
    }

    public Coverage setGroup(String theSystem, String theValue) {
        this.myGroup = new IdentifierDt(theSystem, theValue);
        return this;
    }

    public IdentifierDt getPlan() {
        if (this.myPlan == null) {
            this.myPlan = new IdentifierDt();
        }
        return this.myPlan;
    }

    public IdentifierDt getPlanElement() {
        if (this.myPlan == null) {
            this.myPlan = new IdentifierDt();
        }
        return this.myPlan;
    }

    public Coverage setPlan(IdentifierDt theValue) {
        this.myPlan = theValue;
        return this;
    }

    public Coverage setPlan(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        this.myPlan = new IdentifierDt(theUse, theSystem, theValue, theLabel);
        return this;
    }

    public Coverage setPlan(String theSystem, String theValue) {
        this.myPlan = new IdentifierDt(theSystem, theValue);
        return this;
    }

    public IdentifierDt getSubplan() {
        if (this.mySubplan == null) {
            this.mySubplan = new IdentifierDt();
        }
        return this.mySubplan;
    }

    public IdentifierDt getSubplanElement() {
        if (this.mySubplan == null) {
            this.mySubplan = new IdentifierDt();
        }
        return this.mySubplan;
    }

    public Coverage setSubplan(IdentifierDt theValue) {
        this.mySubplan = theValue;
        return this;
    }

    public Coverage setSubplan(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        this.mySubplan = new IdentifierDt(theUse, theSystem, theValue, theLabel);
        return this;
    }

    public Coverage setSubplan(String theSystem, String theValue) {
        this.mySubplan = new IdentifierDt(theSystem, theValue);
        return this;
    }

    public IntegerDt getDependent() {
        if (this.myDependent == null) {
            this.myDependent = new IntegerDt();
        }
        return this.myDependent;
    }

    public IntegerDt getDependentElement() {
        if (this.myDependent == null) {
            this.myDependent = new IntegerDt();
        }
        return this.myDependent;
    }

    public Coverage setDependent(IntegerDt theValue) {
        this.myDependent = theValue;
        return this;
    }

    public Coverage setDependent(int theInteger) {
        this.myDependent = new IntegerDt(theInteger);
        return this;
    }

    public IntegerDt getSequence() {
        if (this.mySequence == null) {
            this.mySequence = new IntegerDt();
        }
        return this.mySequence;
    }

    public IntegerDt getSequenceElement() {
        if (this.mySequence == null) {
            this.mySequence = new IntegerDt();
        }
        return this.mySequence;
    }

    public Coverage setSequence(IntegerDt theValue) {
        this.mySequence = theValue;
        return this;
    }

    public Coverage setSequence(int theInteger) {
        this.mySequence = new IntegerDt(theInteger);
        return this;
    }

    public Subscriber getSubscriber() {
        if (this.mySubscriber == null) {
            this.mySubscriber = new Subscriber();
        }
        return this.mySubscriber;
    }

    public Subscriber getSubscriberElement() {
        if (this.mySubscriber == null) {
            this.mySubscriber = new Subscriber();
        }
        return this.mySubscriber;
    }

    public Coverage setSubscriber(Subscriber theValue) {
        this.mySubscriber = theValue;
        return this;
    }

    public String getResourceName() {
        return "Coverage";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Subscriber
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="name", type={HumanNameDt.class}, order=0, min=0, max=1)
        @Description(shortDefinition="PolicyHolder name", formalDefinition="The name of the PolicyHolder")
        private HumanNameDt myName;
        @Child(name="address", type={AddressDt.class}, order=1, min=0, max=1)
        @Description(shortDefinition="PolicyHolder address", formalDefinition="The mailing address, typically home, of the PolicyHolder")
        private AddressDt myAddress;
        @Child(name="birthdate", type={DateDt.class}, order=2, min=0, max=1)
        @Description(shortDefinition="PolicyHolder date of birth", formalDefinition="The date of birth of the PolicyHolder")
        private DateDt myBirthdate;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myName, this.myAddress, this.myBirthdate});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myName, this.myAddress, this.myBirthdate});
        }

        public HumanNameDt getName() {
            if (this.myName == null) {
                this.myName = new HumanNameDt();
            }
            return this.myName;
        }

        public HumanNameDt getNameElement() {
            if (this.myName == null) {
                this.myName = new HumanNameDt();
            }
            return this.myName;
        }

        public Subscriber setName(HumanNameDt theValue) {
            this.myName = theValue;
            return this;
        }

        public AddressDt getAddress() {
            if (this.myAddress == null) {
                this.myAddress = new AddressDt();
            }
            return this.myAddress;
        }

        public AddressDt getAddressElement() {
            if (this.myAddress == null) {
                this.myAddress = new AddressDt();
            }
            return this.myAddress;
        }

        public Subscriber setAddress(AddressDt theValue) {
            this.myAddress = theValue;
            return this;
        }

        public DateDt getBirthdate() {
            if (this.myBirthdate == null) {
                this.myBirthdate = new DateDt();
            }
            return this.myBirthdate;
        }

        public DateDt getBirthdateElement() {
            if (this.myBirthdate == null) {
                this.myBirthdate = new DateDt();
            }
            return this.myBirthdate;
        }

        public Subscriber setBirthdate(DateDt theValue) {
            this.myBirthdate = theValue;
            return this;
        }

        public Subscriber setBirthdate(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myBirthdate = new DateDt(theDate, thePrecision);
            return this;
        }

        public Subscriber setBirthdateWithDayPrecision(Date theDate) {
            this.myBirthdate = new DateDt(theDate);
            return this;
        }
    }
}

