/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.CodingDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Encounter;
import ca.uhn.fhir.model.dstu.resource.Group;
import ca.uhn.fhir.model.dstu.resource.Location;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu.valueset.CompositionAttestationModeEnum;
import ca.uhn.fhir.model.dstu.valueset.CompositionStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="Composition", profile="http://hl7.org/fhir/profiles/Composition", id="composition")
public class Composition
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="type", path="Composition.type", description="", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="class", path="Composition.class", description="", type="token")
    public static final String SP_CLASS = "class";
    public static final TokenClientParam CLASS = new TokenClientParam("class");
    @SearchParamDefinition(name="date", path="Composition.date", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="subject", path="Composition.subject", description="", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Composition.subject");
    @SearchParamDefinition(name="author", path="Composition.author", description="", type="reference")
    public static final String SP_AUTHOR = "author";
    public static final ReferenceClientParam AUTHOR = new ReferenceClientParam("author");
    public static final Include INCLUDE_AUTHOR = new Include("Composition.author");
    @SearchParamDefinition(name="attester", path="Composition.attester.party", description="", type="reference")
    public static final String SP_ATTESTER = "attester";
    public static final ReferenceClientParam ATTESTER = new ReferenceClientParam("attester");
    public static final Include INCLUDE_ATTESTER_PARTY = new Include("Composition.attester.party");
    @SearchParamDefinition(name="context", path="Composition.event.code", description="", type="token")
    public static final String SP_CONTEXT = "context";
    public static final TokenClientParam CONTEXT = new TokenClientParam("context");
    @SearchParamDefinition(name="section-type", path="Composition.section.code", description="", type="token")
    public static final String SP_SECTION_TYPE = "section-type";
    public static final TokenClientParam SECTION_TYPE = new TokenClientParam("section-type");
    @SearchParamDefinition(name="section-content", path="Composition.section.content", description="", type="reference")
    public static final String SP_SECTION_CONTENT = "section-content";
    public static final ReferenceClientParam SECTION_CONTENT = new ReferenceClientParam("section-content");
    public static final Include INCLUDE_SECTION_CONTENT = new Include("Composition.section.content");
    @SearchParamDefinition(name="identifier", path="Composition.identifier", description="", type="token")
    public static final String SP_IDENTIFIER = "identifier";
    public static final TokenClientParam IDENTIFIER = new TokenClientParam("identifier");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=1)
    @Description(shortDefinition="Logical identifier of composition (version-independent)", formalDefinition="Logical Identifier for the composition, assigned when created. This identifier stays constant as the composition is changed over time")
    private IdentifierDt myIdentifier;
    @Child(name="date", type={DateTimeDt.class}, order=1, min=1, max=1)
    @Description(shortDefinition="Composition editing time", formalDefinition="The composition editing time, when the composition was last logically changed by the author")
    private DateTimeDt myDate;
    @Child(name="type", type={CodeableConceptDt.class}, order=2, min=1, max=1)
    @Description(shortDefinition="Kind of composition (LOINC if possible)", formalDefinition="Specifies the particular kind of composition (e.g. History and Physical, Discharge Summary, Progress Note). This usually equates to the purpose of making the composition")
    private CodeableConceptDt myType;
    @Child(name="class", type={CodeableConceptDt.class}, order=3, min=0, max=1)
    @Description(shortDefinition="Categorization of Composition", formalDefinition="A categorization for the type of the composition. This may be implied by or derived from the code specified in the Composition Type")
    private CodeableConceptDt myClassElement;
    @Child(name="title", type={StringDt.class}, order=4, min=0, max=1)
    @Description(shortDefinition="Human Readable name/title", formalDefinition="Official human-readable label for the composition")
    private StringDt myTitle;
    @Child(name="status", type={CodeDt.class}, order=5, min=1, max=1)
    @Description(shortDefinition="preliminary | final | appended | amended | entered in error", formalDefinition="The workflow/clinical status of this composition. The status is a marker for the clinical standing of the document")
    private BoundCodeDt<CompositionStatusEnum> myStatus;
    @Child(name="confidentiality", type={CodingDt.class}, order=6, min=1, max=1)
    @Description(shortDefinition="As defined by affinity domain", formalDefinition="The code specifying the level of confidentiality of the Composition")
    private CodingDt myConfidentiality;
    @Child(name="subject", order=7, min=1, max=1, type={Patient.class, Practitioner.class, Group.class, Device.class, Location.class})
    @Description(shortDefinition="Who and/or what the composition is about", formalDefinition="Who or what the composition is about. The composition can be about a person, (patient or healthcare practitioner), a device (I.e. machine) or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure)")
    private ResourceReferenceDt mySubject;
    @Child(name="author", order=8, min=1, max=-1, type={Practitioner.class, Device.class, Patient.class, RelatedPerson.class})
    @Description(shortDefinition="Who and/or what authored the composition", formalDefinition="Identifies who is responsible for the information in the composition.  (Not necessarily who typed it in.)")
    private List<ResourceReferenceDt> myAuthor;
    @Child(name="attester", order=9, min=0, max=-1)
    @Description(shortDefinition="Attests to accuracy of composition", formalDefinition="A participant who has attested to the accuracy of the composition/document")
    private List<Attester> myAttester;
    @Child(name="custodian", order=10, min=0, max=1, type={Organization.class})
    @Description(shortDefinition="Org which maintains the composition", formalDefinition="Identifies the organization or group who is responsible for ongoing maintenance of and access to the composition/document information")
    private ResourceReferenceDt myCustodian;
    @Child(name="event", order=11, min=0, max=1)
    @Description(shortDefinition="The clinical event/act/item being documented", formalDefinition="The main event/act/item, such as a colonoscopy or an appendectomy, being documented")
    private Event myEvent;
    @Child(name="encounter", order=12, min=0, max=1, type={Encounter.class})
    @Description(shortDefinition="Context of the conposition", formalDefinition="Describes the clinical encounter or type of care this documentation is associated with.")
    private ResourceReferenceDt myEncounter;
    @Child(name="section", order=13, min=0, max=-1)
    @Description(shortDefinition="Composition is broken into sections", formalDefinition="The root of the sections that make up the composition")
    private List<Section> mySection;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myDate, this.myType, this.myClassElement, this.myTitle, this.myStatus, this.myConfidentiality, this.mySubject, this.myAuthor, this.myAttester, this.myCustodian, this.myEvent, this.myEncounter, this.mySection});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myDate, this.myType, this.myClassElement, this.myTitle, this.myStatus, this.myConfidentiality, this.mySubject, this.myAuthor, this.myAttester, this.myCustodian, this.myEvent, this.myEncounter, this.mySection});
    }

    public IdentifierDt getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public IdentifierDt getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new IdentifierDt();
        }
        return this.myIdentifier;
    }

    public Composition setIdentifier(IdentifierDt theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public Composition setIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        this.myIdentifier = new IdentifierDt(theUse, theSystem, theValue, theLabel);
        return this;
    }

    public Composition setIdentifier(String theSystem, String theValue) {
        this.myIdentifier = new IdentifierDt(theSystem, theValue);
        return this;
    }

    public DateTimeDt getDate() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public Composition setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public Composition setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public Composition setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public CodeableConceptDt getType() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public CodeableConceptDt getTypeElement() {
        if (this.myType == null) {
            this.myType = new CodeableConceptDt();
        }
        return this.myType;
    }

    public Composition setType(CodeableConceptDt theValue) {
        this.myType = theValue;
        return this;
    }

    public CodeableConceptDt getClassElement() {
        if (this.myClassElement == null) {
            this.myClassElement = new CodeableConceptDt();
        }
        return this.myClassElement;
    }

    public CodeableConceptDt getClassElementElement() {
        if (this.myClassElement == null) {
            this.myClassElement = new CodeableConceptDt();
        }
        return this.myClassElement;
    }

    public Composition setClassElement(CodeableConceptDt theValue) {
        this.myClassElement = theValue;
        return this;
    }

    public StringDt getTitle() {
        if (this.myTitle == null) {
            this.myTitle = new StringDt();
        }
        return this.myTitle;
    }

    public StringDt getTitleElement() {
        if (this.myTitle == null) {
            this.myTitle = new StringDt();
        }
        return this.myTitle;
    }

    public Composition setTitle(StringDt theValue) {
        this.myTitle = theValue;
        return this;
    }

    public Composition setTitle(String theString) {
        this.myTitle = new StringDt(theString);
        return this;
    }

    public BoundCodeDt<CompositionStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(CompositionStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<CompositionStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(CompositionStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public Composition setStatus(BoundCodeDt<CompositionStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Composition setStatus(CompositionStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public CodingDt getConfidentiality() {
        if (this.myConfidentiality == null) {
            this.myConfidentiality = new CodingDt();
        }
        return this.myConfidentiality;
    }

    public CodingDt getConfidentialityElement() {
        if (this.myConfidentiality == null) {
            this.myConfidentiality = new CodingDt();
        }
        return this.myConfidentiality;
    }

    public Composition setConfidentiality(CodingDt theValue) {
        this.myConfidentiality = theValue;
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Composition setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ArrayList<ResourceReferenceDt>();
        }
        return this.myAuthor;
    }

    public List<ResourceReferenceDt> getAuthorElement() {
        if (this.myAuthor == null) {
            this.myAuthor = new ArrayList<ResourceReferenceDt>();
        }
        return this.myAuthor;
    }

    public Composition setAuthor(List<ResourceReferenceDt> theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public ResourceReferenceDt addAuthor() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getAuthor().add(newType);
        return newType;
    }

    public List<Attester> getAttester() {
        if (this.myAttester == null) {
            this.myAttester = new ArrayList<Attester>();
        }
        return this.myAttester;
    }

    public List<Attester> getAttesterElement() {
        if (this.myAttester == null) {
            this.myAttester = new ArrayList<Attester>();
        }
        return this.myAttester;
    }

    public Composition setAttester(List<Attester> theValue) {
        this.myAttester = theValue;
        return this;
    }

    public Attester addAttester() {
        Attester newType = new Attester();
        this.getAttester().add(newType);
        return newType;
    }

    public Attester getAttesterFirstRep() {
        if (this.getAttester().isEmpty()) {
            return this.addAttester();
        }
        return this.getAttester().get(0);
    }

    public ResourceReferenceDt getCustodian() {
        if (this.myCustodian == null) {
            this.myCustodian = new ResourceReferenceDt();
        }
        return this.myCustodian;
    }

    public ResourceReferenceDt getCustodianElement() {
        if (this.myCustodian == null) {
            this.myCustodian = new ResourceReferenceDt();
        }
        return this.myCustodian;
    }

    public Composition setCustodian(ResourceReferenceDt theValue) {
        this.myCustodian = theValue;
        return this;
    }

    public Event getEvent() {
        if (this.myEvent == null) {
            this.myEvent = new Event();
        }
        return this.myEvent;
    }

    public Event getEventElement() {
        if (this.myEvent == null) {
            this.myEvent = new Event();
        }
        return this.myEvent;
    }

    public Composition setEvent(Event theValue) {
        this.myEvent = theValue;
        return this;
    }

    public ResourceReferenceDt getEncounter() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public ResourceReferenceDt getEncounterElement() {
        if (this.myEncounter == null) {
            this.myEncounter = new ResourceReferenceDt();
        }
        return this.myEncounter;
    }

    public Composition setEncounter(ResourceReferenceDt theValue) {
        this.myEncounter = theValue;
        return this;
    }

    public List<Section> getSection() {
        if (this.mySection == null) {
            this.mySection = new ArrayList<Section>();
        }
        return this.mySection;
    }

    public List<Section> getSectionElement() {
        if (this.mySection == null) {
            this.mySection = new ArrayList<Section>();
        }
        return this.mySection;
    }

    public Composition setSection(List<Section> theValue) {
        this.mySection = theValue;
        return this;
    }

    public Section addSection() {
        Section newType = new Section();
        this.getSection().add(newType);
        return newType;
    }

    public Section getSectionFirstRep() {
        if (this.getSection().isEmpty()) {
            return this.addSection();
        }
        return this.getSection().get(0);
    }

    public String getResourceName() {
        return "Composition";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Section
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="title", type={StringDt.class}, order=0, min=0, max=1)
        @Description(shortDefinition="Label for section", formalDefinition="The heading for this particular section.  This will be part of the rendered content for the document.")
        private StringDt myTitle;
        @Child(name="code", type={CodeableConceptDt.class}, order=1, min=0, max=1)
        @Description(shortDefinition="Classification of section (recommended)", formalDefinition="A code identifying the kind of content contained within the section")
        private CodeableConceptDt myCode;
        @Child(name="subject", order=2, min=0, max=1, type={Patient.class, Group.class, Device.class})
        @Description(shortDefinition="If section different to composition", formalDefinition="Identifies the primary subject of the section.")
        private ResourceReferenceDt mySubject;
        @Child(name="content", order=3, min=0, max=1, type={IResource.class})
        @Description(shortDefinition="The actual data for the section", formalDefinition="Identifies the discrete data that provides the content for the section.")
        private ResourceReferenceDt myContent;
        @Child(name="section", type={Section.class}, order=4, min=0, max=-1)
        @Description(shortDefinition="Nested Section", formalDefinition="A nested sub-section within this section")
        private List<Section> mySection;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myTitle, this.myCode, this.mySubject, this.myContent, this.mySection});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myTitle, this.myCode, this.mySubject, this.myContent, this.mySection});
        }

        public StringDt getTitle() {
            if (this.myTitle == null) {
                this.myTitle = new StringDt();
            }
            return this.myTitle;
        }

        public StringDt getTitleElement() {
            if (this.myTitle == null) {
                this.myTitle = new StringDt();
            }
            return this.myTitle;
        }

        public Section setTitle(StringDt theValue) {
            this.myTitle = theValue;
            return this;
        }

        public Section setTitle(String theString) {
            this.myTitle = new StringDt(theString);
            return this;
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public CodeableConceptDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public Section setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public ResourceReferenceDt getSubject() {
            if (this.mySubject == null) {
                this.mySubject = new ResourceReferenceDt();
            }
            return this.mySubject;
        }

        public ResourceReferenceDt getSubjectElement() {
            if (this.mySubject == null) {
                this.mySubject = new ResourceReferenceDt();
            }
            return this.mySubject;
        }

        public Section setSubject(ResourceReferenceDt theValue) {
            this.mySubject = theValue;
            return this;
        }

        public ResourceReferenceDt getContent() {
            if (this.myContent == null) {
                this.myContent = new ResourceReferenceDt();
            }
            return this.myContent;
        }

        public ResourceReferenceDt getContentElement() {
            if (this.myContent == null) {
                this.myContent = new ResourceReferenceDt();
            }
            return this.myContent;
        }

        public Section setContent(ResourceReferenceDt theValue) {
            this.myContent = theValue;
            return this;
        }

        public List<Section> getSection() {
            if (this.mySection == null) {
                this.mySection = new ArrayList<Section>();
            }
            return this.mySection;
        }

        public List<Section> getSectionElement() {
            if (this.mySection == null) {
                this.mySection = new ArrayList<Section>();
            }
            return this.mySection;
        }

        public Section setSection(List<Section> theValue) {
            this.mySection = theValue;
            return this;
        }

        public Section addSection() {
            Section newType = new Section();
            this.getSection().add(newType);
            return newType;
        }

        public Section getSectionFirstRep() {
            if (this.getSection().isEmpty()) {
                return this.addSection();
            }
            return this.getSection().get(0);
        }
    }

    @Block
    public static class Event
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=0, max=-1)
        @Description(shortDefinition="Code(s) that apply to the event being documented", formalDefinition="This list of codes represents the main clinical acts, such as a colonoscopy or an appendectomy, being documented. In some cases, the event is inherent in the typeCode, such as a \"History and Physical Report\" in which the procedure being documented is necessarily a \"History and Physical\" act.")
        private List<CodeableConceptDt> myCode;
        @Child(name="period", type={PeriodDt.class}, order=1, min=0, max=1)
        @Description(shortDefinition="The period covered by the documentation", formalDefinition="The period of time covered by the documentation. There is no assertion that the documentation is a complete representation for this period, only that it documents events during this time")
        private PeriodDt myPeriod;
        @Child(name="detail", order=2, min=0, max=-1, type={IResource.class})
        @Description(shortDefinition="Full details for the event(s) the composition consents", formalDefinition="Full details for the event(s) the composition/documentation consents")
        private List<ResourceReferenceDt> myDetail;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCode, this.myPeriod, this.myDetail});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.myPeriod, this.myDetail});
        }

        public List<CodeableConceptDt> getCode() {
            if (this.myCode == null) {
                this.myCode = new ArrayList<CodeableConceptDt>();
            }
            return this.myCode;
        }

        public List<CodeableConceptDt> getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new ArrayList<CodeableConceptDt>();
            }
            return this.myCode;
        }

        public Event setCode(List<CodeableConceptDt> theValue) {
            this.myCode = theValue;
            return this;
        }

        public CodeableConceptDt addCode() {
            CodeableConceptDt newType = new CodeableConceptDt();
            this.getCode().add(newType);
            return newType;
        }

        public CodeableConceptDt getCodeFirstRep() {
            if (this.getCode().isEmpty()) {
                return this.addCode();
            }
            return this.getCode().get(0);
        }

        public PeriodDt getPeriod() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public PeriodDt getPeriodElement() {
            if (this.myPeriod == null) {
                this.myPeriod = new PeriodDt();
            }
            return this.myPeriod;
        }

        public Event setPeriod(PeriodDt theValue) {
            this.myPeriod = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getDetail() {
            if (this.myDetail == null) {
                this.myDetail = new ArrayList<ResourceReferenceDt>();
            }
            return this.myDetail;
        }

        public List<ResourceReferenceDt> getDetailElement() {
            if (this.myDetail == null) {
                this.myDetail = new ArrayList<ResourceReferenceDt>();
            }
            return this.myDetail;
        }

        public Event setDetail(List<ResourceReferenceDt> theValue) {
            this.myDetail = theValue;
            return this;
        }

        public ResourceReferenceDt addDetail() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getDetail().add(newType);
            return newType;
        }
    }

    @Block
    public static class Attester
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="mode", type={CodeDt.class}, order=0, min=1, max=-1)
        @Description(shortDefinition="personal | professional | legal | official", formalDefinition="The type of attestation the authenticator offers")
        private List<BoundCodeDt<CompositionAttestationModeEnum>> myMode;
        @Child(name="time", type={DateTimeDt.class}, order=1, min=0, max=1)
        @Description(shortDefinition="When composition attested", formalDefinition="When composition was attested by the party")
        private DateTimeDt myTime;
        @Child(name="party", order=2, min=0, max=1, type={Patient.class, Practitioner.class, Organization.class})
        @Description(shortDefinition="Who attested the composition", formalDefinition="Who attested the composition in the specified way")
        private ResourceReferenceDt myParty;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myMode, this.myTime, this.myParty});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myMode, this.myTime, this.myParty});
        }

        public List<BoundCodeDt<CompositionAttestationModeEnum>> getMode() {
            if (this.myMode == null) {
                this.myMode = new ArrayList<BoundCodeDt<CompositionAttestationModeEnum>>();
            }
            return this.myMode;
        }

        public List<BoundCodeDt<CompositionAttestationModeEnum>> getModeElement() {
            if (this.myMode == null) {
                this.myMode = new ArrayList<BoundCodeDt<CompositionAttestationModeEnum>>();
            }
            return this.myMode;
        }

        public Attester setMode(List<BoundCodeDt<CompositionAttestationModeEnum>> theValue) {
            this.myMode = theValue;
            return this;
        }

        public BoundCodeDt<CompositionAttestationModeEnum> addMode(CompositionAttestationModeEnum theValue) {
            BoundCodeDt retVal = new BoundCodeDt(CompositionAttestationModeEnum.VALUESET_BINDER, (Enum)theValue);
            this.getMode().add((BoundCodeDt<CompositionAttestationModeEnum>)retVal);
            return retVal;
        }

        public BoundCodeDt<CompositionAttestationModeEnum> getModeFirstRep() {
            if (this.getMode().size() == 0) {
                this.addMode();
            }
            return this.getMode().get(0);
        }

        public BoundCodeDt<CompositionAttestationModeEnum> addMode() {
            BoundCodeDt retVal = new BoundCodeDt(CompositionAttestationModeEnum.VALUESET_BINDER);
            this.getMode().add((BoundCodeDt<CompositionAttestationModeEnum>)retVal);
            return retVal;
        }

        public Attester setMode(CompositionAttestationModeEnum theValue) {
            this.getMode().clear();
            this.addMode(theValue);
            return this;
        }

        public DateTimeDt getTime() {
            if (this.myTime == null) {
                this.myTime = new DateTimeDt();
            }
            return this.myTime;
        }

        public DateTimeDt getTimeElement() {
            if (this.myTime == null) {
                this.myTime = new DateTimeDt();
            }
            return this.myTime;
        }

        public Attester setTime(DateTimeDt theValue) {
            this.myTime = theValue;
            return this;
        }

        public Attester setTime(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myTime = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public Attester setTimeWithSecondsPrecision(Date theDate) {
            this.myTime = new DateTimeDt(theDate);
            return this;
        }

        public ResourceReferenceDt getParty() {
            if (this.myParty == null) {
                this.myParty = new ResourceReferenceDt();
            }
            return this.myParty;
        }

        public ResourceReferenceDt getPartyElement() {
            if (this.myParty == null) {
                this.myParty = new ResourceReferenceDt();
            }
            return this.myParty;
        }

        public Attester setParty(ResourceReferenceDt theValue) {
            this.myParty = theValue;
            return this;
        }
    }
}

