/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.QuantityDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.composite.ScheduleDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Condition;
import ca.uhn.fhir.model.dstu.resource.DiagnosticOrder;
import ca.uhn.fhir.model.dstu.resource.Encounter;
import ca.uhn.fhir.model.dstu.resource.Location;
import ca.uhn.fhir.model.dstu.resource.Medication;
import ca.uhn.fhir.model.dstu.resource.MedicationPrescription;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.Procedure;
import ca.uhn.fhir.model.dstu.resource.RelatedPerson;
import ca.uhn.fhir.model.dstu.resource.Substance;
import ca.uhn.fhir.model.dstu.valueset.CarePlanActivityCategoryEnum;
import ca.uhn.fhir.model.dstu.valueset.CarePlanActivityStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.CarePlanGoalStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.CarePlanStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.IdrefDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="CarePlan", profile="http://hl7.org/fhir/profiles/CarePlan", id="careplan")
public class CarePlan
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="patient", path="CarePlan.patient", description="", type="reference")
    public static final String SP_PATIENT = "patient";
    public static final ReferenceClientParam PATIENT = new ReferenceClientParam("patient");
    public static final Include INCLUDE_PATIENT = new Include("CarePlan.patient");
    @SearchParamDefinition(name="condition", path="CarePlan.concern", description="", type="reference")
    public static final String SP_CONDITION = "condition";
    public static final ReferenceClientParam CONDITION = new ReferenceClientParam("condition");
    public static final Include INCLUDE_CONCERN = new Include("CarePlan.concern");
    @SearchParamDefinition(name="date", path="CarePlan.period", description="", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="participant", path="CarePlan.participant.member", description="", type="reference")
    public static final String SP_PARTICIPANT = "participant";
    public static final ReferenceClientParam PARTICIPANT = new ReferenceClientParam("participant");
    public static final Include INCLUDE_PARTICIPANT_MEMBER = new Include("CarePlan.participant.member");
    @SearchParamDefinition(name="activitycode", path="CarePlan.activity.simple.code", description="", type="token")
    public static final String SP_ACTIVITYCODE = "activitycode";
    public static final TokenClientParam ACTIVITYCODE = new TokenClientParam("activitycode");
    @SearchParamDefinition(name="activitydate", path="CarePlan.activity.simple.timing[x]", description="Specified date occurs within period specified by CarePlan.activity.timingSchedule", type="date")
    public static final String SP_ACTIVITYDATE = "activitydate";
    public static final DateClientParam ACTIVITYDATE = new DateClientParam("activitydate");
    @SearchParamDefinition(name="activitydetail", path="CarePlan.activity.detail", description="", type="reference")
    public static final String SP_ACTIVITYDETAIL = "activitydetail";
    public static final ReferenceClientParam ACTIVITYDETAIL = new ReferenceClientParam("activitydetail");
    public static final Include INCLUDE_ACTIVITY_DETAIL = new Include("CarePlan.activity.detail");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1)
    @Description(shortDefinition="External Ids for this plan", formalDefinition="This records identifiers associated with this care plan that are defined by business processed and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="patient", order=1, min=0, max=1, type={Patient.class})
    @Description(shortDefinition="Who care plan is for", formalDefinition="Identifies the patient/subject whose intended care is described by the plan.")
    private ResourceReferenceDt myPatient;
    @Child(name="status", type={CodeDt.class}, order=2, min=1, max=1)
    @Description(shortDefinition="planned | active | completed", formalDefinition="Indicates whether the plan is currently being acted upon, represents future intentions or is now just historical record.")
    private BoundCodeDt<CarePlanStatusEnum> myStatus;
    @Child(name="period", type={PeriodDt.class}, order=3, min=0, max=1)
    @Description(shortDefinition="Time period plan covers", formalDefinition="Indicates when the plan did (or is intended to) come into effect and end.")
    private PeriodDt myPeriod;
    @Child(name="modified", type={DateTimeDt.class}, order=4, min=0, max=1)
    @Description(shortDefinition="When last updated", formalDefinition="Identifies the most recent date on which the plan has been revised.")
    private DateTimeDt myModified;
    @Child(name="concern", order=5, min=0, max=-1, type={Condition.class})
    @Description(shortDefinition="Health issues this plan addresses", formalDefinition="Identifies the conditions/problems/concerns/diagnoses/etc. whose management and/or mitigation are handled by this plan.")
    private List<ResourceReferenceDt> myConcern;
    @Child(name="participant", order=6, min=0, max=-1)
    @Description(shortDefinition="Who's involved in plan?", formalDefinition="Identifies all people and organizations who are expected to be involved in the care envisioned by this plan.")
    private List<Participant> myParticipant;
    @Child(name="goal", order=7, min=0, max=-1)
    @Description(shortDefinition="Desired outcome of plan", formalDefinition="Describes the intended objective(s) of carrying out the Care Plan.")
    private List<Goal> myGoal;
    @Child(name="activity", order=8, min=0, max=-1)
    @Description(shortDefinition="Action to occur as part of plan", formalDefinition="Identifies a planned action to occur as part of the plan.  For example, a medication to be used, lab tests to perform, self-monitoring, education, etc.")
    private List<Activity> myActivity;
    @Child(name="notes", type={StringDt.class}, order=9, min=0, max=1)
    @Description(shortDefinition="Comments about the plan", formalDefinition="General notes about the care plan not covered elsewhere")
    private StringDt myNotes;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myPatient, this.myStatus, this.myPeriod, this.myModified, this.myConcern, this.myParticipant, this.myGoal, this.myActivity, this.myNotes});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myPatient, this.myStatus, this.myPeriod, this.myModified, this.myConcern, this.myParticipant, this.myGoal, this.myActivity, this.myNotes});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public CarePlan setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public CarePlan addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public CarePlan addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public ResourceReferenceDt getPatient() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public ResourceReferenceDt getPatientElement() {
        if (this.myPatient == null) {
            this.myPatient = new ResourceReferenceDt();
        }
        return this.myPatient;
    }

    public CarePlan setPatient(ResourceReferenceDt theValue) {
        this.myPatient = theValue;
        return this;
    }

    public BoundCodeDt<CarePlanStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(CarePlanStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<CarePlanStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(CarePlanStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public CarePlan setStatus(BoundCodeDt<CarePlanStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public CarePlan setStatus(CarePlanStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public PeriodDt getPeriodElement() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public CarePlan setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public DateTimeDt getModified() {
        if (this.myModified == null) {
            this.myModified = new DateTimeDt();
        }
        return this.myModified;
    }

    public DateTimeDt getModifiedElement() {
        if (this.myModified == null) {
            this.myModified = new DateTimeDt();
        }
        return this.myModified;
    }

    public CarePlan setModified(DateTimeDt theValue) {
        this.myModified = theValue;
        return this;
    }

    public CarePlan setModified(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myModified = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public CarePlan setModifiedWithSecondsPrecision(Date theDate) {
        this.myModified = new DateTimeDt(theDate);
        return this;
    }

    public List<ResourceReferenceDt> getConcern() {
        if (this.myConcern == null) {
            this.myConcern = new ArrayList<ResourceReferenceDt>();
        }
        return this.myConcern;
    }

    public List<ResourceReferenceDt> getConcernElement() {
        if (this.myConcern == null) {
            this.myConcern = new ArrayList<ResourceReferenceDt>();
        }
        return this.myConcern;
    }

    public CarePlan setConcern(List<ResourceReferenceDt> theValue) {
        this.myConcern = theValue;
        return this;
    }

    public ResourceReferenceDt addConcern() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getConcern().add(newType);
        return newType;
    }

    public List<Participant> getParticipant() {
        if (this.myParticipant == null) {
            this.myParticipant = new ArrayList<Participant>();
        }
        return this.myParticipant;
    }

    public List<Participant> getParticipantElement() {
        if (this.myParticipant == null) {
            this.myParticipant = new ArrayList<Participant>();
        }
        return this.myParticipant;
    }

    public CarePlan setParticipant(List<Participant> theValue) {
        this.myParticipant = theValue;
        return this;
    }

    public Participant addParticipant() {
        Participant newType = new Participant();
        this.getParticipant().add(newType);
        return newType;
    }

    public Participant getParticipantFirstRep() {
        if (this.getParticipant().isEmpty()) {
            return this.addParticipant();
        }
        return this.getParticipant().get(0);
    }

    public List<Goal> getGoal() {
        if (this.myGoal == null) {
            this.myGoal = new ArrayList<Goal>();
        }
        return this.myGoal;
    }

    public List<Goal> getGoalElement() {
        if (this.myGoal == null) {
            this.myGoal = new ArrayList<Goal>();
        }
        return this.myGoal;
    }

    public CarePlan setGoal(List<Goal> theValue) {
        this.myGoal = theValue;
        return this;
    }

    public Goal addGoal() {
        Goal newType = new Goal();
        this.getGoal().add(newType);
        return newType;
    }

    public Goal getGoalFirstRep() {
        if (this.getGoal().isEmpty()) {
            return this.addGoal();
        }
        return this.getGoal().get(0);
    }

    public List<Activity> getActivity() {
        if (this.myActivity == null) {
            this.myActivity = new ArrayList<Activity>();
        }
        return this.myActivity;
    }

    public List<Activity> getActivityElement() {
        if (this.myActivity == null) {
            this.myActivity = new ArrayList<Activity>();
        }
        return this.myActivity;
    }

    public CarePlan setActivity(List<Activity> theValue) {
        this.myActivity = theValue;
        return this;
    }

    public Activity addActivity() {
        Activity newType = new Activity();
        this.getActivity().add(newType);
        return newType;
    }

    public Activity getActivityFirstRep() {
        if (this.getActivity().isEmpty()) {
            return this.addActivity();
        }
        return this.getActivity().get(0);
    }

    public StringDt getNotes() {
        if (this.myNotes == null) {
            this.myNotes = new StringDt();
        }
        return this.myNotes;
    }

    public StringDt getNotesElement() {
        if (this.myNotes == null) {
            this.myNotes = new StringDt();
        }
        return this.myNotes;
    }

    public CarePlan setNotes(StringDt theValue) {
        this.myNotes = theValue;
        return this;
    }

    public CarePlan setNotes(String theString) {
        this.myNotes = new StringDt(theString);
        return this;
    }

    public String getResourceName() {
        return "CarePlan";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class ActivitySimple
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="category", type={CodeDt.class}, order=0, min=1, max=1)
        @Description(shortDefinition="diet | drug | encounter | observation | procedure | supply | other", formalDefinition="High-level categorization of the type of activity in a care plan.")
        private BoundCodeDt<CarePlanActivityCategoryEnum> myCategory;
        @Child(name="code", type={CodeableConceptDt.class}, order=1, min=0, max=1)
        @Description(shortDefinition="Detail type of activity", formalDefinition="Detailed description of the type of activity.  E.g. What lab test, what procedure, what kind of encounter.")
        private CodeableConceptDt myCode;
        @Child(name="timing", order=2, min=0, max=1, type={ScheduleDt.class, PeriodDt.class, StringDt.class})
        @Description(shortDefinition="When activity is to occur", formalDefinition="The period, timing or frequency upon which the described activity is to occur.")
        private IDatatype myTiming;
        @Child(name="location", order=3, min=0, max=1, type={Location.class})
        @Description(shortDefinition="Where it should happen", formalDefinition="Identifies the facility where the activity will occur.  E.g. home, hospital, specific clinic, etc.")
        private ResourceReferenceDt myLocation;
        @Child(name="performer", order=4, min=0, max=-1, type={Practitioner.class, Organization.class, RelatedPerson.class, Patient.class})
        @Description(shortDefinition="Who's responsible?", formalDefinition="Identifies who's expected to be involved in the activity.")
        private List<ResourceReferenceDt> myPerformer;
        @Child(name="product", order=5, min=0, max=1, type={Medication.class, Substance.class})
        @Description(shortDefinition="What's administered/supplied", formalDefinition="Identifies the food, drug or other product being consumed or supplied in the activity.")
        private ResourceReferenceDt myProduct;
        @Child(name="dailyAmount", type={QuantityDt.class}, order=6, min=0, max=1)
        @Description(shortDefinition="How much consumed/day?", formalDefinition="Identifies the quantity expected to be consumed in a given day.")
        private QuantityDt myDailyAmount;
        @Child(name="quantity", type={QuantityDt.class}, order=7, min=0, max=1)
        @Description(shortDefinition="How much is administered/supplied/consumed", formalDefinition="Identifies the quantity expected to be supplied.")
        private QuantityDt myQuantity;
        @Child(name="details", type={StringDt.class}, order=8, min=0, max=1)
        @Description(shortDefinition="Extra info on activity occurrence", formalDefinition="This provides a textual description of constraints on the activity occurrence, including relation to other activities.  It may also include objectives, pre-conditions and end-conditions.  Finally, it may convey specifics about the activity such as body site, method, route, etc.")
        private StringDt myDetails;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myCategory, this.myCode, this.myTiming, this.myLocation, this.myPerformer, this.myProduct, this.myDailyAmount, this.myQuantity, this.myDetails});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCategory, this.myCode, this.myTiming, this.myLocation, this.myPerformer, this.myProduct, this.myDailyAmount, this.myQuantity, this.myDetails});
        }

        public BoundCodeDt<CarePlanActivityCategoryEnum> getCategory() {
            if (this.myCategory == null) {
                this.myCategory = new BoundCodeDt(CarePlanActivityCategoryEnum.VALUESET_BINDER);
            }
            return this.myCategory;
        }

        public BoundCodeDt<CarePlanActivityCategoryEnum> getCategoryElement() {
            if (this.myCategory == null) {
                this.myCategory = new BoundCodeDt(CarePlanActivityCategoryEnum.VALUESET_BINDER);
            }
            return this.myCategory;
        }

        public ActivitySimple setCategory(BoundCodeDt<CarePlanActivityCategoryEnum> theValue) {
            this.myCategory = theValue;
            return this;
        }

        public ActivitySimple setCategory(CarePlanActivityCategoryEnum theValue) {
            this.getCategory().setValueAsEnum((Enum)theValue);
            return this;
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public CodeableConceptDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public ActivitySimple setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public IDatatype getTiming() {
            return this.myTiming;
        }

        public IDatatype getTimingElement() {
            return this.myTiming;
        }

        public ActivitySimple setTiming(IDatatype theValue) {
            this.myTiming = theValue;
            return this;
        }

        public ResourceReferenceDt getLocation() {
            if (this.myLocation == null) {
                this.myLocation = new ResourceReferenceDt();
            }
            return this.myLocation;
        }

        public ResourceReferenceDt getLocationElement() {
            if (this.myLocation == null) {
                this.myLocation = new ResourceReferenceDt();
            }
            return this.myLocation;
        }

        public ActivitySimple setLocation(ResourceReferenceDt theValue) {
            this.myLocation = theValue;
            return this;
        }

        public List<ResourceReferenceDt> getPerformer() {
            if (this.myPerformer == null) {
                this.myPerformer = new ArrayList<ResourceReferenceDt>();
            }
            return this.myPerformer;
        }

        public List<ResourceReferenceDt> getPerformerElement() {
            if (this.myPerformer == null) {
                this.myPerformer = new ArrayList<ResourceReferenceDt>();
            }
            return this.myPerformer;
        }

        public ActivitySimple setPerformer(List<ResourceReferenceDt> theValue) {
            this.myPerformer = theValue;
            return this;
        }

        public ResourceReferenceDt addPerformer() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getPerformer().add(newType);
            return newType;
        }

        public ResourceReferenceDt getProduct() {
            if (this.myProduct == null) {
                this.myProduct = new ResourceReferenceDt();
            }
            return this.myProduct;
        }

        public ResourceReferenceDt getProductElement() {
            if (this.myProduct == null) {
                this.myProduct = new ResourceReferenceDt();
            }
            return this.myProduct;
        }

        public ActivitySimple setProduct(ResourceReferenceDt theValue) {
            this.myProduct = theValue;
            return this;
        }

        public QuantityDt getDailyAmount() {
            if (this.myDailyAmount == null) {
                this.myDailyAmount = new QuantityDt();
            }
            return this.myDailyAmount;
        }

        public QuantityDt getDailyAmountElement() {
            if (this.myDailyAmount == null) {
                this.myDailyAmount = new QuantityDt();
            }
            return this.myDailyAmount;
        }

        public ActivitySimple setDailyAmount(QuantityDt theValue) {
            this.myDailyAmount = theValue;
            return this;
        }

        public ActivitySimple setDailyAmount(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
            this.myDailyAmount = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public ActivitySimple setDailyAmount(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
            this.myDailyAmount = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public ActivitySimple setDailyAmount(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
            this.myDailyAmount = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public ActivitySimple setDailyAmount(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
            this.myDailyAmount = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public ActivitySimple setDailyAmount(double theValue) {
            this.myDailyAmount = new QuantityDt(theValue);
            return this;
        }

        public ActivitySimple setDailyAmount(long theValue) {
            this.myDailyAmount = new QuantityDt(theValue);
            return this;
        }

        public QuantityDt getQuantity() {
            if (this.myQuantity == null) {
                this.myQuantity = new QuantityDt();
            }
            return this.myQuantity;
        }

        public QuantityDt getQuantityElement() {
            if (this.myQuantity == null) {
                this.myQuantity = new QuantityDt();
            }
            return this.myQuantity;
        }

        public ActivitySimple setQuantity(QuantityDt theValue) {
            this.myQuantity = theValue;
            return this;
        }

        public ActivitySimple setQuantity(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public ActivitySimple setQuantity(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theUnits);
            return this;
        }

        public ActivitySimple setQuantity(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public ActivitySimple setQuantity(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
            this.myQuantity = new QuantityDt(theComparator, theValue, theSystem, theUnits);
            return this;
        }

        public ActivitySimple setQuantity(double theValue) {
            this.myQuantity = new QuantityDt(theValue);
            return this;
        }

        public ActivitySimple setQuantity(long theValue) {
            this.myQuantity = new QuantityDt(theValue);
            return this;
        }

        public StringDt getDetails() {
            if (this.myDetails == null) {
                this.myDetails = new StringDt();
            }
            return this.myDetails;
        }

        public StringDt getDetailsElement() {
            if (this.myDetails == null) {
                this.myDetails = new StringDt();
            }
            return this.myDetails;
        }

        public ActivitySimple setDetails(StringDt theValue) {
            this.myDetails = theValue;
            return this;
        }

        public ActivitySimple setDetails(String theString) {
            this.myDetails = new StringDt(theString);
            return this;
        }
    }

    @Block
    public static class Activity
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="goal", type={IdrefDt.class}, order=0, min=0, max=-1)
        @Description(shortDefinition="Goals this activity relates to", formalDefinition="Internal reference that identifies the goals that this activity is intended to contribute towards meeting")
        private List<IdrefDt> myGoal;
        @Child(name="status", type={CodeDt.class}, order=1, min=0, max=1)
        @Description(shortDefinition="not started | scheduled | in progress | on hold | completed | cancelled", formalDefinition="Identifies what progress is being made for the specific activity.")
        private BoundCodeDt<CarePlanActivityStatusEnum> myStatus;
        @Child(name="prohibited", type={BooleanDt.class}, order=2, min=1, max=1)
        @Description(shortDefinition="Do NOT do", formalDefinition="If true, indicates that the described activity is one that must NOT be engaged in when following the plan.")
        private BooleanDt myProhibited;
        @Child(name="actionResulting", order=3, min=0, max=-1, type={IResource.class})
        @Description(shortDefinition="Appointments, orders, etc.", formalDefinition="Resources that describe follow-on actions resulting from the plan, such as drug prescriptions, encounter records, appointments, etc.")
        private List<ResourceReferenceDt> myActionResulting;
        @Child(name="notes", type={StringDt.class}, order=4, min=0, max=1)
        @Description(shortDefinition="Comments about the activity", formalDefinition="Notes about the execution of the activity")
        private StringDt myNotes;
        @Child(name="detail", order=5, min=0, max=1, type={Procedure.class, MedicationPrescription.class, DiagnosticOrder.class, Encounter.class})
        @Description(shortDefinition="Activity details defined in specific resource", formalDefinition="The details of the proposed activity represented in a specific resource")
        private ResourceReferenceDt myDetail;
        @Child(name="simple", order=6, min=0, max=1)
        @Description(shortDefinition="Activity details summarised here", formalDefinition="A simple summary of details suitable for a general care plan system (e.g. form driven) that doesn't know about specific resources such as procedure etc")
        private ActivitySimple mySimple;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myGoal, this.myStatus, this.myProhibited, this.myActionResulting, this.myNotes, this.myDetail, this.mySimple});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myGoal, this.myStatus, this.myProhibited, this.myActionResulting, this.myNotes, this.myDetail, this.mySimple});
        }

        public List<IdrefDt> getGoal() {
            if (this.myGoal == null) {
                this.myGoal = new ArrayList<IdrefDt>();
            }
            return this.myGoal;
        }

        public List<IdrefDt> getGoalElement() {
            if (this.myGoal == null) {
                this.myGoal = new ArrayList<IdrefDt>();
            }
            return this.myGoal;
        }

        public Activity setGoal(List<IdrefDt> theValue) {
            this.myGoal = theValue;
            return this;
        }

        public IdrefDt addGoal() {
            IdrefDt newType = new IdrefDt();
            this.getGoal().add(newType);
            return newType;
        }

        public IdrefDt getGoalFirstRep() {
            if (this.getGoal().isEmpty()) {
                return this.addGoal();
            }
            return this.getGoal().get(0);
        }

        public BoundCodeDt<CarePlanActivityStatusEnum> getStatus() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(CarePlanActivityStatusEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public BoundCodeDt<CarePlanActivityStatusEnum> getStatusElement() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(CarePlanActivityStatusEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public Activity setStatus(BoundCodeDt<CarePlanActivityStatusEnum> theValue) {
            this.myStatus = theValue;
            return this;
        }

        public Activity setStatus(CarePlanActivityStatusEnum theValue) {
            this.getStatus().setValueAsEnum((Enum)theValue);
            return this;
        }

        public BooleanDt getProhibited() {
            if (this.myProhibited == null) {
                this.myProhibited = new BooleanDt();
            }
            return this.myProhibited;
        }

        public BooleanDt getProhibitedElement() {
            if (this.myProhibited == null) {
                this.myProhibited = new BooleanDt();
            }
            return this.myProhibited;
        }

        public Activity setProhibited(BooleanDt theValue) {
            this.myProhibited = theValue;
            return this;
        }

        public Activity setProhibited(boolean theBoolean) {
            this.myProhibited = new BooleanDt(theBoolean);
            return this;
        }

        public List<ResourceReferenceDt> getActionResulting() {
            if (this.myActionResulting == null) {
                this.myActionResulting = new ArrayList<ResourceReferenceDt>();
            }
            return this.myActionResulting;
        }

        public List<ResourceReferenceDt> getActionResultingElement() {
            if (this.myActionResulting == null) {
                this.myActionResulting = new ArrayList<ResourceReferenceDt>();
            }
            return this.myActionResulting;
        }

        public Activity setActionResulting(List<ResourceReferenceDt> theValue) {
            this.myActionResulting = theValue;
            return this;
        }

        public ResourceReferenceDt addActionResulting() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getActionResulting().add(newType);
            return newType;
        }

        public StringDt getNotes() {
            if (this.myNotes == null) {
                this.myNotes = new StringDt();
            }
            return this.myNotes;
        }

        public StringDt getNotesElement() {
            if (this.myNotes == null) {
                this.myNotes = new StringDt();
            }
            return this.myNotes;
        }

        public Activity setNotes(StringDt theValue) {
            this.myNotes = theValue;
            return this;
        }

        public Activity setNotes(String theString) {
            this.myNotes = new StringDt(theString);
            return this;
        }

        public ResourceReferenceDt getDetail() {
            if (this.myDetail == null) {
                this.myDetail = new ResourceReferenceDt();
            }
            return this.myDetail;
        }

        public ResourceReferenceDt getDetailElement() {
            if (this.myDetail == null) {
                this.myDetail = new ResourceReferenceDt();
            }
            return this.myDetail;
        }

        public Activity setDetail(ResourceReferenceDt theValue) {
            this.myDetail = theValue;
            return this;
        }

        public ActivitySimple getSimple() {
            if (this.mySimple == null) {
                this.mySimple = new ActivitySimple();
            }
            return this.mySimple;
        }

        public ActivitySimple getSimpleElement() {
            if (this.mySimple == null) {
                this.mySimple = new ActivitySimple();
            }
            return this.mySimple;
        }

        public Activity setSimple(ActivitySimple theValue) {
            this.mySimple = theValue;
            return this;
        }
    }

    @Block
    public static class Goal
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="description", type={StringDt.class}, order=0, min=1, max=1)
        @Description(shortDefinition="What's the desired outcome?", formalDefinition="Human-readable description of a specific desired objective of the care plan.")
        private StringDt myDescription;
        @Child(name="status", type={CodeDt.class}, order=1, min=0, max=1)
        @Description(shortDefinition="in progress | achieved | sustaining | cancelled", formalDefinition="Indicates whether the goal has been reached and is still considered relevant")
        private BoundCodeDt<CarePlanGoalStatusEnum> myStatus;
        @Child(name="notes", type={StringDt.class}, order=2, min=0, max=1)
        @Description(shortDefinition="Comments about the goal", formalDefinition="Any comments related to the goal")
        private StringDt myNotes;
        @Child(name="concern", order=3, min=0, max=-1, type={Condition.class})
        @Description(shortDefinition="Health issues this goal addresses", formalDefinition="The identified conditions that this goal relates to - the condition that caused it to be created, or that it is intended to address")
        private List<ResourceReferenceDt> myConcern;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myDescription, this.myStatus, this.myNotes, this.myConcern});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDescription, this.myStatus, this.myNotes, this.myConcern});
        }

        public StringDt getDescription() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public StringDt getDescriptionElement() {
            if (this.myDescription == null) {
                this.myDescription = new StringDt();
            }
            return this.myDescription;
        }

        public Goal setDescription(StringDt theValue) {
            this.myDescription = theValue;
            return this;
        }

        public Goal setDescription(String theString) {
            this.myDescription = new StringDt(theString);
            return this;
        }

        public BoundCodeDt<CarePlanGoalStatusEnum> getStatus() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(CarePlanGoalStatusEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public BoundCodeDt<CarePlanGoalStatusEnum> getStatusElement() {
            if (this.myStatus == null) {
                this.myStatus = new BoundCodeDt(CarePlanGoalStatusEnum.VALUESET_BINDER);
            }
            return this.myStatus;
        }

        public Goal setStatus(BoundCodeDt<CarePlanGoalStatusEnum> theValue) {
            this.myStatus = theValue;
            return this;
        }

        public Goal setStatus(CarePlanGoalStatusEnum theValue) {
            this.getStatus().setValueAsEnum((Enum)theValue);
            return this;
        }

        public StringDt getNotes() {
            if (this.myNotes == null) {
                this.myNotes = new StringDt();
            }
            return this.myNotes;
        }

        public StringDt getNotesElement() {
            if (this.myNotes == null) {
                this.myNotes = new StringDt();
            }
            return this.myNotes;
        }

        public Goal setNotes(StringDt theValue) {
            this.myNotes = theValue;
            return this;
        }

        public Goal setNotes(String theString) {
            this.myNotes = new StringDt(theString);
            return this;
        }

        public List<ResourceReferenceDt> getConcern() {
            if (this.myConcern == null) {
                this.myConcern = new ArrayList<ResourceReferenceDt>();
            }
            return this.myConcern;
        }

        public List<ResourceReferenceDt> getConcernElement() {
            if (this.myConcern == null) {
                this.myConcern = new ArrayList<ResourceReferenceDt>();
            }
            return this.myConcern;
        }

        public Goal setConcern(List<ResourceReferenceDt> theValue) {
            this.myConcern = theValue;
            return this;
        }

        public ResourceReferenceDt addConcern() {
            ResourceReferenceDt newType = new ResourceReferenceDt();
            this.getConcern().add(newType);
            return newType;
        }
    }

    @Block
    public static class Participant
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="role", type={CodeableConceptDt.class}, order=0, min=0, max=1)
        @Description(shortDefinition="Type of involvement", formalDefinition="Indicates specific responsibility of an individual within the care plan.  E.g. \"Primary physician\", \"Team coordinator\", \"Caregiver\", etc.")
        private CodeableConceptDt myRole;
        @Child(name="member", order=1, min=1, max=1, type={Practitioner.class, RelatedPerson.class, Patient.class, Organization.class})
        @Description(shortDefinition="Who is involved", formalDefinition="The specific person or organization who is participating/expected to participate in the care plan.")
        private ResourceReferenceDt myMember;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myRole, this.myMember});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myRole, this.myMember});
        }

        public CodeableConceptDt getRole() {
            if (this.myRole == null) {
                this.myRole = new CodeableConceptDt();
            }
            return this.myRole;
        }

        public CodeableConceptDt getRoleElement() {
            if (this.myRole == null) {
                this.myRole = new CodeableConceptDt();
            }
            return this.myRole;
        }

        public Participant setRole(CodeableConceptDt theValue) {
            this.myRole = theValue;
            return this;
        }

        public ResourceReferenceDt getMember() {
            if (this.myMember == null) {
                this.myMember = new ResourceReferenceDt();
            }
            return this.myMember;
        }

        public ResourceReferenceDt getMemberElement() {
            if (this.myMember == null) {
                this.myMember = new ResourceReferenceDt();
            }
            return this.myMember;
        }

        public Participant setMember(ResourceReferenceDt theValue) {
            this.myMember = theValue;
            return this;
        }
    }
}

