/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.AdverseReaction;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Observation;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.Substance;
import ca.uhn.fhir.model.dstu.valueset.CriticalityEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.SensitivityStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.SensitivityTypeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="AllergyIntolerance", profile="http://hl7.org/fhir/profiles/AllergyIntolerance", id="allergyintolerance")
public class AllergyIntolerance
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="type", path="AllergyIntolerance.sensitivityType", description="The type of sensitivity", type="token")
    public static final String SP_TYPE = "type";
    public static final TokenClientParam TYPE = new TokenClientParam("type");
    @SearchParamDefinition(name="substance", path="AllergyIntolerance.substance", description="The name or code of the substance that produces the sensitivity", type="reference")
    public static final String SP_SUBSTANCE = "substance";
    public static final ReferenceClientParam SUBSTANCE = new ReferenceClientParam("substance");
    public static final Include INCLUDE_SUBSTANCE = new Include("AllergyIntolerance.substance");
    @SearchParamDefinition(name="date", path="AllergyIntolerance.recordedDate", description="Recorded date/time.", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="status", path="AllergyIntolerance.status", description="The status of the sensitivity", type="token")
    public static final String SP_STATUS = "status";
    public static final TokenClientParam STATUS = new TokenClientParam("status");
    @SearchParamDefinition(name="subject", path="AllergyIntolerance.subject", description="The subject that the sensitivity is about", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("AllergyIntolerance.subject");
    @SearchParamDefinition(name="recorder", path="AllergyIntolerance.recorder", description="Who recorded the sensitivity", type="reference")
    public static final String SP_RECORDER = "recorder";
    public static final ReferenceClientParam RECORDER = new ReferenceClientParam("recorder");
    public static final Include INCLUDE_RECORDER = new Include("AllergyIntolerance.recorder");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1)
    @Description(shortDefinition="External Ids for this item", formalDefinition="This records identifiers associated with this allergy/intolerance concern that are defined by business processed and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="criticality", type={CodeDt.class}, order=1, min=0, max=1)
    @Description(shortDefinition="fatal | high | medium | low", formalDefinition="Criticality of the sensitivity")
    private BoundCodeDt<CriticalityEnum> myCriticality;
    @Child(name="sensitivityType", type={CodeDt.class}, order=2, min=1, max=1)
    @Description(shortDefinition="allergy | intolerance | unknown", formalDefinition="Type of the sensitivity")
    private BoundCodeDt<SensitivityTypeEnum> mySensitivityType;
    @Child(name="recordedDate", type={DateTimeDt.class}, order=3, min=0, max=1)
    @Description(shortDefinition="When recorded", formalDefinition="Date when the sensitivity was recorded")
    private DateTimeDt myRecordedDate;
    @Child(name="status", type={CodeDt.class}, order=4, min=1, max=1)
    @Description(shortDefinition="suspected | confirmed | refuted | resolved", formalDefinition="Status of the sensitivity")
    private BoundCodeDt<SensitivityStatusEnum> myStatus;
    @Child(name="subject", order=5, min=1, max=1, type={Patient.class})
    @Description(shortDefinition="Who the sensitivity is for", formalDefinition="The patient who has the allergy or intolerance")
    private ResourceReferenceDt mySubject;
    @Child(name="recorder", order=6, min=0, max=1, type={Practitioner.class, Patient.class})
    @Description(shortDefinition="Who recorded the sensitivity", formalDefinition="Indicates who has responsibility for the record")
    private ResourceReferenceDt myRecorder;
    @Child(name="substance", order=7, min=1, max=1, type={Substance.class})
    @Description(shortDefinition="The substance that causes the sensitivity", formalDefinition="The substance that causes the sensitivity")
    private ResourceReferenceDt mySubstance;
    @Child(name="reaction", order=8, min=0, max=-1, type={AdverseReaction.class})
    @Description(shortDefinition="Reactions associated with the sensitivity", formalDefinition="Reactions associated with the sensitivity")
    private List<ResourceReferenceDt> myReaction;
    @Child(name="sensitivityTest", order=9, min=0, max=-1, type={Observation.class})
    @Description(shortDefinition="Observations that confirm or refute", formalDefinition="Observations that confirm or refute the sensitivity")
    private List<ResourceReferenceDt> mySensitivityTest;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myCriticality, this.mySensitivityType, this.myRecordedDate, this.myStatus, this.mySubject, this.myRecorder, this.mySubstance, this.myReaction, this.mySensitivityTest});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myCriticality, this.mySensitivityType, this.myRecordedDate, this.myStatus, this.mySubject, this.myRecorder, this.mySubstance, this.myReaction, this.mySensitivityTest});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public AllergyIntolerance setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public AllergyIntolerance addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public AllergyIntolerance addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public BoundCodeDt<CriticalityEnum> getCriticality() {
        if (this.myCriticality == null) {
            this.myCriticality = new BoundCodeDt(CriticalityEnum.VALUESET_BINDER);
        }
        return this.myCriticality;
    }

    public BoundCodeDt<CriticalityEnum> getCriticalityElement() {
        if (this.myCriticality == null) {
            this.myCriticality = new BoundCodeDt(CriticalityEnum.VALUESET_BINDER);
        }
        return this.myCriticality;
    }

    public AllergyIntolerance setCriticality(BoundCodeDt<CriticalityEnum> theValue) {
        this.myCriticality = theValue;
        return this;
    }

    public AllergyIntolerance setCriticality(CriticalityEnum theValue) {
        this.getCriticality().setValueAsEnum((Enum)theValue);
        return this;
    }

    public BoundCodeDt<SensitivityTypeEnum> getSensitivityType() {
        if (this.mySensitivityType == null) {
            this.mySensitivityType = new BoundCodeDt(SensitivityTypeEnum.VALUESET_BINDER);
        }
        return this.mySensitivityType;
    }

    public BoundCodeDt<SensitivityTypeEnum> getSensitivityTypeElement() {
        if (this.mySensitivityType == null) {
            this.mySensitivityType = new BoundCodeDt(SensitivityTypeEnum.VALUESET_BINDER);
        }
        return this.mySensitivityType;
    }

    public AllergyIntolerance setSensitivityType(BoundCodeDt<SensitivityTypeEnum> theValue) {
        this.mySensitivityType = theValue;
        return this;
    }

    public AllergyIntolerance setSensitivityType(SensitivityTypeEnum theValue) {
        this.getSensitivityType().setValueAsEnum((Enum)theValue);
        return this;
    }

    public DateTimeDt getRecordedDate() {
        if (this.myRecordedDate == null) {
            this.myRecordedDate = new DateTimeDt();
        }
        return this.myRecordedDate;
    }

    public DateTimeDt getRecordedDateElement() {
        if (this.myRecordedDate == null) {
            this.myRecordedDate = new DateTimeDt();
        }
        return this.myRecordedDate;
    }

    public AllergyIntolerance setRecordedDate(DateTimeDt theValue) {
        this.myRecordedDate = theValue;
        return this;
    }

    public AllergyIntolerance setRecordedDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myRecordedDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public AllergyIntolerance setRecordedDateWithSecondsPrecision(Date theDate) {
        this.myRecordedDate = new DateTimeDt(theDate);
        return this;
    }

    public BoundCodeDt<SensitivityStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(SensitivityStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<SensitivityStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(SensitivityStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public AllergyIntolerance setStatus(BoundCodeDt<SensitivityStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public AllergyIntolerance setStatus(SensitivityStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public AllergyIntolerance setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getRecorder() {
        if (this.myRecorder == null) {
            this.myRecorder = new ResourceReferenceDt();
        }
        return this.myRecorder;
    }

    public ResourceReferenceDt getRecorderElement() {
        if (this.myRecorder == null) {
            this.myRecorder = new ResourceReferenceDt();
        }
        return this.myRecorder;
    }

    public AllergyIntolerance setRecorder(ResourceReferenceDt theValue) {
        this.myRecorder = theValue;
        return this;
    }

    public ResourceReferenceDt getSubstance() {
        if (this.mySubstance == null) {
            this.mySubstance = new ResourceReferenceDt();
        }
        return this.mySubstance;
    }

    public ResourceReferenceDt getSubstanceElement() {
        if (this.mySubstance == null) {
            this.mySubstance = new ResourceReferenceDt();
        }
        return this.mySubstance;
    }

    public AllergyIntolerance setSubstance(ResourceReferenceDt theValue) {
        this.mySubstance = theValue;
        return this;
    }

    public List<ResourceReferenceDt> getReaction() {
        if (this.myReaction == null) {
            this.myReaction = new ArrayList<ResourceReferenceDt>();
        }
        return this.myReaction;
    }

    public List<ResourceReferenceDt> getReactionElement() {
        if (this.myReaction == null) {
            this.myReaction = new ArrayList<ResourceReferenceDt>();
        }
        return this.myReaction;
    }

    public AllergyIntolerance setReaction(List<ResourceReferenceDt> theValue) {
        this.myReaction = theValue;
        return this;
    }

    public ResourceReferenceDt addReaction() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getReaction().add(newType);
        return newType;
    }

    public List<ResourceReferenceDt> getSensitivityTest() {
        if (this.mySensitivityTest == null) {
            this.mySensitivityTest = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySensitivityTest;
    }

    public List<ResourceReferenceDt> getSensitivityTestElement() {
        if (this.mySensitivityTest == null) {
            this.mySensitivityTest = new ArrayList<ResourceReferenceDt>();
        }
        return this.mySensitivityTest;
    }

    public AllergyIntolerance setSensitivityTest(List<ResourceReferenceDt> theValue) {
        this.mySensitivityTest = theValue;
        return this;
    }

    public ResourceReferenceDt addSensitivityTest() {
        ResourceReferenceDt newType = new ResourceReferenceDt();
        this.getSensitivityTest().add(newType);
        return newType;
    }

    public String getResourceName() {
        return "AllergyIntolerance";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }
}

