/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Device;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.valueset.AlertStatusEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@ResourceDef(name="Alert", profile="http://hl7.org/fhir/profiles/Alert", id="alert")
public class Alert
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="subject", path="Alert.subject", description="The identity of a subject to list alerts for", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("Alert.subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1)
    @Description(shortDefinition="Business identifier", formalDefinition="Identifier assigned to the alert for external use (outside the FHIR environment)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="category", type={CodeableConceptDt.class}, order=1, min=0, max=1)
    @Description(shortDefinition="Clinical, administrative, etc.", formalDefinition="Allows an alert to be divided into different categories like clinical, administrative etc.")
    private CodeableConceptDt myCategory;
    @Child(name="status", type={CodeDt.class}, order=2, min=1, max=1)
    @Description(shortDefinition="active | inactive | entered in error", formalDefinition="Supports basic workflow")
    private BoundCodeDt<AlertStatusEnum> myStatus;
    @Child(name="subject", order=3, min=1, max=1, type={Patient.class})
    @Description(shortDefinition="Who is alert about?", formalDefinition="The person who this alert concerns")
    private ResourceReferenceDt mySubject;
    @Child(name="author", order=4, min=0, max=1, type={Practitioner.class, Patient.class, Device.class})
    @Description(shortDefinition="Alert creator", formalDefinition="The person or device that created the alert")
    private ResourceReferenceDt myAuthor;
    @Child(name="note", type={StringDt.class}, order=5, min=1, max=1)
    @Description(shortDefinition="Text of alert", formalDefinition="The textual component of the alert to display to the user")
    private StringDt myNote;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myCategory, this.myStatus, this.mySubject, this.myAuthor, this.myNote});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myCategory, this.myStatus, this.mySubject, this.myAuthor, this.myNote});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public Alert setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public Alert addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public Alert addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public CodeableConceptDt getCategory() {
        if (this.myCategory == null) {
            this.myCategory = new CodeableConceptDt();
        }
        return this.myCategory;
    }

    public CodeableConceptDt getCategoryElement() {
        if (this.myCategory == null) {
            this.myCategory = new CodeableConceptDt();
        }
        return this.myCategory;
    }

    public Alert setCategory(CodeableConceptDt theValue) {
        this.myCategory = theValue;
        return this;
    }

    public BoundCodeDt<AlertStatusEnum> getStatus() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(AlertStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public BoundCodeDt<AlertStatusEnum> getStatusElement() {
        if (this.myStatus == null) {
            this.myStatus = new BoundCodeDt(AlertStatusEnum.VALUESET_BINDER);
        }
        return this.myStatus;
    }

    public Alert setStatus(BoundCodeDt<AlertStatusEnum> theValue) {
        this.myStatus = theValue;
        return this;
    }

    public Alert setStatus(AlertStatusEnum theValue) {
        this.getStatus().setValueAsEnum((Enum)theValue);
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public Alert setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public ResourceReferenceDt getAuthor() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public ResourceReferenceDt getAuthorElement() {
        if (this.myAuthor == null) {
            this.myAuthor = new ResourceReferenceDt();
        }
        return this.myAuthor;
    }

    public Alert setAuthor(ResourceReferenceDt theValue) {
        this.myAuthor = theValue;
        return this;
    }

    public StringDt getNote() {
        if (this.myNote == null) {
            this.myNote = new StringDt();
        }
        return this.myNote;
    }

    public StringDt getNoteElement() {
        if (this.myNote == null) {
            this.myNote = new StringDt();
        }
        return this.myNote;
    }

    public Alert setNote(StringDt theValue) {
        this.myNote = theValue;
        return this;
    }

    public Alert setNote(String theString) {
        this.myNote = new StringDt(theString);
        return this;
    }

    public String getResourceName() {
        return "Alert";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }
}

