/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.resource;

import ca.uhn.fhir.context.FhirVersionEnum;
import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResource;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.Include;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.ResourceDef;
import ca.uhn.fhir.model.api.annotation.SearchParamDefinition;
import ca.uhn.fhir.model.dstu.composite.CodeableConceptDt;
import ca.uhn.fhir.model.dstu.composite.IdentifierDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.BaseResource;
import ca.uhn.fhir.model.dstu.resource.Patient;
import ca.uhn.fhir.model.dstu.resource.Practitioner;
import ca.uhn.fhir.model.dstu.resource.Substance;
import ca.uhn.fhir.model.dstu.valueset.CausalityExpectationEnum;
import ca.uhn.fhir.model.dstu.valueset.ExposureTypeEnum;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.dstu.valueset.ReactionSeverityEnum;
import ca.uhn.fhir.model.primitive.BooleanDt;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.rest.gclient.DateClientParam;
import ca.uhn.fhir.rest.gclient.ReferenceClientParam;
import ca.uhn.fhir.rest.gclient.TokenClientParam;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@ResourceDef(name="AdverseReaction", profile="http://hl7.org/fhir/profiles/AdverseReaction", id="adversereaction")
public class AdverseReaction
extends BaseResource
implements IResource {
    @SearchParamDefinition(name="symptom", path="AdverseReaction.symptom.code", description="One of the symptoms of the reaction", type="token")
    public static final String SP_SYMPTOM = "symptom";
    public static final TokenClientParam SYMPTOM = new TokenClientParam("symptom");
    @SearchParamDefinition(name="substance", path="AdverseReaction.exposure.substance", description="The name or code of the substance that produces the sensitivity", type="reference")
    public static final String SP_SUBSTANCE = "substance";
    public static final ReferenceClientParam SUBSTANCE = new ReferenceClientParam("substance");
    public static final Include INCLUDE_EXPOSURE_SUBSTANCE = new Include("AdverseReaction.exposure.substance");
    @SearchParamDefinition(name="date", path="AdverseReaction.date", description="The date of the reaction", type="date")
    public static final String SP_DATE = "date";
    public static final DateClientParam DATE = new DateClientParam("date");
    @SearchParamDefinition(name="subject", path="AdverseReaction.subject", description="The subject that the sensitivity is about", type="reference")
    public static final String SP_SUBJECT = "subject";
    public static final ReferenceClientParam SUBJECT = new ReferenceClientParam("subject");
    public static final Include INCLUDE_SUBJECT = new Include("AdverseReaction.subject");
    @Child(name="identifier", type={IdentifierDt.class}, order=0, min=0, max=-1)
    @Description(shortDefinition="External Ids for this adverse reaction", formalDefinition="This records identifiers associated with this reaction that are defined by business processed and/ or used to refer to it when a direct URL reference to the resource itself is not appropriate (e.g. in CDA documents, or in written / printed documentation)")
    private List<IdentifierDt> myIdentifier;
    @Child(name="date", type={DateTimeDt.class}, order=1, min=0, max=1)
    @Description(shortDefinition="When the reaction occurred", formalDefinition="The date (and possibly time) when the reaction began")
    private DateTimeDt myDate;
    @Child(name="subject", order=2, min=1, max=1, type={Patient.class})
    @Description(shortDefinition="Who had the reaction", formalDefinition="The subject of the adverse reaction")
    private ResourceReferenceDt mySubject;
    @Child(name="didNotOccurFlag", type={BooleanDt.class}, order=3, min=1, max=1)
    @Description(shortDefinition="Indicates lack of reaction", formalDefinition="If true, indicates that no reaction occurred.")
    private BooleanDt myDidNotOccurFlag;
    @Child(name="recorder", order=4, min=0, max=1, type={Practitioner.class, Patient.class})
    @Description(shortDefinition="Who recorded the reaction", formalDefinition="Identifies the individual responsible for the information in the reaction record.")
    private ResourceReferenceDt myRecorder;
    @Child(name="symptom", order=5, min=0, max=-1)
    @Description(shortDefinition="What was reaction?", formalDefinition="The signs and symptoms that were observed as part of the reaction")
    private List<Symptom> mySymptom;
    @Child(name="exposure", order=6, min=0, max=-1)
    @Description(shortDefinition="Suspected substance", formalDefinition="An exposure to a substance that preceded a reaction occurrence")
    private List<Exposure> myExposure;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myIdentifier, this.myDate, this.mySubject, this.myDidNotOccurFlag, this.myRecorder, this.mySymptom, this.myExposure});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myIdentifier, this.myDate, this.mySubject, this.myDidNotOccurFlag, this.myRecorder, this.mySymptom, this.myExposure});
    }

    public List<IdentifierDt> getIdentifier() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public List<IdentifierDt> getIdentifierElement() {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        return this.myIdentifier;
    }

    public AdverseReaction setIdentifier(List<IdentifierDt> theValue) {
        this.myIdentifier = theValue;
        return this;
    }

    public IdentifierDt addIdentifier() {
        IdentifierDt newType = new IdentifierDt();
        this.getIdentifier().add(newType);
        return newType;
    }

    public IdentifierDt getIdentifierFirstRep() {
        if (this.getIdentifier().isEmpty()) {
            return this.addIdentifier();
        }
        return this.getIdentifier().get(0);
    }

    public AdverseReaction addIdentifier(IdentifierUseEnum theUse, String theSystem, String theValue, String theLabel) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theUse, theSystem, theValue, theLabel));
        return this;
    }

    public AdverseReaction addIdentifier(String theSystem, String theValue) {
        if (this.myIdentifier == null) {
            this.myIdentifier = new ArrayList<IdentifierDt>();
        }
        this.myIdentifier.add(new IdentifierDt(theSystem, theValue));
        return this;
    }

    public DateTimeDt getDate() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public DateTimeDt getDateElement() {
        if (this.myDate == null) {
            this.myDate = new DateTimeDt();
        }
        return this.myDate;
    }

    public AdverseReaction setDate(DateTimeDt theValue) {
        this.myDate = theValue;
        return this;
    }

    public AdverseReaction setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
        this.myDate = new DateTimeDt(theDate, thePrecision);
        return this;
    }

    public AdverseReaction setDateWithSecondsPrecision(Date theDate) {
        this.myDate = new DateTimeDt(theDate);
        return this;
    }

    public ResourceReferenceDt getSubject() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public ResourceReferenceDt getSubjectElement() {
        if (this.mySubject == null) {
            this.mySubject = new ResourceReferenceDt();
        }
        return this.mySubject;
    }

    public AdverseReaction setSubject(ResourceReferenceDt theValue) {
        this.mySubject = theValue;
        return this;
    }

    public BooleanDt getDidNotOccurFlag() {
        if (this.myDidNotOccurFlag == null) {
            this.myDidNotOccurFlag = new BooleanDt();
        }
        return this.myDidNotOccurFlag;
    }

    public BooleanDt getDidNotOccurFlagElement() {
        if (this.myDidNotOccurFlag == null) {
            this.myDidNotOccurFlag = new BooleanDt();
        }
        return this.myDidNotOccurFlag;
    }

    public AdverseReaction setDidNotOccurFlag(BooleanDt theValue) {
        this.myDidNotOccurFlag = theValue;
        return this;
    }

    public AdverseReaction setDidNotOccurFlag(boolean theBoolean) {
        this.myDidNotOccurFlag = new BooleanDt(theBoolean);
        return this;
    }

    public ResourceReferenceDt getRecorder() {
        if (this.myRecorder == null) {
            this.myRecorder = new ResourceReferenceDt();
        }
        return this.myRecorder;
    }

    public ResourceReferenceDt getRecorderElement() {
        if (this.myRecorder == null) {
            this.myRecorder = new ResourceReferenceDt();
        }
        return this.myRecorder;
    }

    public AdverseReaction setRecorder(ResourceReferenceDt theValue) {
        this.myRecorder = theValue;
        return this;
    }

    public List<Symptom> getSymptom() {
        if (this.mySymptom == null) {
            this.mySymptom = new ArrayList<Symptom>();
        }
        return this.mySymptom;
    }

    public List<Symptom> getSymptomElement() {
        if (this.mySymptom == null) {
            this.mySymptom = new ArrayList<Symptom>();
        }
        return this.mySymptom;
    }

    public AdverseReaction setSymptom(List<Symptom> theValue) {
        this.mySymptom = theValue;
        return this;
    }

    public Symptom addSymptom() {
        Symptom newType = new Symptom();
        this.getSymptom().add(newType);
        return newType;
    }

    public Symptom getSymptomFirstRep() {
        if (this.getSymptom().isEmpty()) {
            return this.addSymptom();
        }
        return this.getSymptom().get(0);
    }

    public List<Exposure> getExposure() {
        if (this.myExposure == null) {
            this.myExposure = new ArrayList<Exposure>();
        }
        return this.myExposure;
    }

    public List<Exposure> getExposureElement() {
        if (this.myExposure == null) {
            this.myExposure = new ArrayList<Exposure>();
        }
        return this.myExposure;
    }

    public AdverseReaction setExposure(List<Exposure> theValue) {
        this.myExposure = theValue;
        return this;
    }

    public Exposure addExposure() {
        Exposure newType = new Exposure();
        this.getExposure().add(newType);
        return newType;
    }

    public Exposure getExposureFirstRep() {
        if (this.getExposure().isEmpty()) {
            return this.addExposure();
        }
        return this.getExposure().get(0);
    }

    public String getResourceName() {
        return "AdverseReaction";
    }

    public FhirVersionEnum getStructureFhirVersionEnum() {
        return FhirVersionEnum.DSTU1;
    }

    @Block
    public static class Exposure
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="date", type={DateTimeDt.class}, order=0, min=0, max=1)
        @Description(shortDefinition="When the exposure occurred", formalDefinition="Identifies the initial date of the exposure that is suspected to be related to the reaction")
        private DateTimeDt myDate;
        @Child(name="type", type={CodeDt.class}, order=1, min=0, max=1)
        @Description(shortDefinition="drugadmin | immuniz | coincidental", formalDefinition="The type of exposure: Drug Administration, Immunization, Coincidental")
        private BoundCodeDt<ExposureTypeEnum> myType;
        @Child(name="causalityExpectation", type={CodeDt.class}, order=2, min=0, max=1)
        @Description(shortDefinition="likely | unlikely | confirmed | unknown", formalDefinition="A statement of how confident that the recorder was that this exposure caused the reaction")
        private BoundCodeDt<CausalityExpectationEnum> myCausalityExpectation;
        @Child(name="substance", order=3, min=0, max=1, type={Substance.class})
        @Description(shortDefinition="Presumed causative substance", formalDefinition="Substance that is presumed to have caused the adverse reaction")
        private ResourceReferenceDt mySubstance;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myDate, this.myType, this.myCausalityExpectation, this.mySubstance});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myDate, this.myType, this.myCausalityExpectation, this.mySubstance});
        }

        public DateTimeDt getDate() {
            if (this.myDate == null) {
                this.myDate = new DateTimeDt();
            }
            return this.myDate;
        }

        public DateTimeDt getDateElement() {
            if (this.myDate == null) {
                this.myDate = new DateTimeDt();
            }
            return this.myDate;
        }

        public Exposure setDate(DateTimeDt theValue) {
            this.myDate = theValue;
            return this;
        }

        public Exposure setDate(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myDate = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public Exposure setDateWithSecondsPrecision(Date theDate) {
            this.myDate = new DateTimeDt(theDate);
            return this;
        }

        public BoundCodeDt<ExposureTypeEnum> getType() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(ExposureTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public BoundCodeDt<ExposureTypeEnum> getTypeElement() {
            if (this.myType == null) {
                this.myType = new BoundCodeDt(ExposureTypeEnum.VALUESET_BINDER);
            }
            return this.myType;
        }

        public Exposure setType(BoundCodeDt<ExposureTypeEnum> theValue) {
            this.myType = theValue;
            return this;
        }

        public Exposure setType(ExposureTypeEnum theValue) {
            this.getType().setValueAsEnum((Enum)theValue);
            return this;
        }

        public BoundCodeDt<CausalityExpectationEnum> getCausalityExpectation() {
            if (this.myCausalityExpectation == null) {
                this.myCausalityExpectation = new BoundCodeDt(CausalityExpectationEnum.VALUESET_BINDER);
            }
            return this.myCausalityExpectation;
        }

        public BoundCodeDt<CausalityExpectationEnum> getCausalityExpectationElement() {
            if (this.myCausalityExpectation == null) {
                this.myCausalityExpectation = new BoundCodeDt(CausalityExpectationEnum.VALUESET_BINDER);
            }
            return this.myCausalityExpectation;
        }

        public Exposure setCausalityExpectation(BoundCodeDt<CausalityExpectationEnum> theValue) {
            this.myCausalityExpectation = theValue;
            return this;
        }

        public Exposure setCausalityExpectation(CausalityExpectationEnum theValue) {
            this.getCausalityExpectation().setValueAsEnum((Enum)theValue);
            return this;
        }

        public ResourceReferenceDt getSubstance() {
            if (this.mySubstance == null) {
                this.mySubstance = new ResourceReferenceDt();
            }
            return this.mySubstance;
        }

        public ResourceReferenceDt getSubstanceElement() {
            if (this.mySubstance == null) {
                this.mySubstance = new ResourceReferenceDt();
            }
            return this.mySubstance;
        }

        public Exposure setSubstance(ResourceReferenceDt theValue) {
            this.mySubstance = theValue;
            return this;
        }
    }

    @Block
    public static class Symptom
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="code", type={CodeableConceptDt.class}, order=0, min=1, max=1)
        @Description(shortDefinition="E.g. Rash, vomiting", formalDefinition="Indicates the specific sign or symptom that was observed")
        private CodeableConceptDt myCode;
        @Child(name="severity", type={CodeDt.class}, order=1, min=0, max=1)
        @Description(shortDefinition="severe | serious | moderate | minor", formalDefinition="The severity of the sign or symptom")
        private BoundCodeDt<ReactionSeverityEnum> mySeverity;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myCode, this.mySeverity});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myCode, this.mySeverity});
        }

        public CodeableConceptDt getCode() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public CodeableConceptDt getCodeElement() {
            if (this.myCode == null) {
                this.myCode = new CodeableConceptDt();
            }
            return this.myCode;
        }

        public Symptom setCode(CodeableConceptDt theValue) {
            this.myCode = theValue;
            return this;
        }

        public BoundCodeDt<ReactionSeverityEnum> getSeverity() {
            if (this.mySeverity == null) {
                this.mySeverity = new BoundCodeDt(ReactionSeverityEnum.VALUESET_BINDER);
            }
            return this.mySeverity;
        }

        public BoundCodeDt<ReactionSeverityEnum> getSeverityElement() {
            if (this.mySeverity == null) {
                this.mySeverity = new BoundCodeDt(ReactionSeverityEnum.VALUESET_BINDER);
            }
            return this.mySeverity;
        }

        public Symptom setSeverity(BoundCodeDt<ReactionSeverityEnum> theValue) {
            this.mySeverity = theValue;
            return this;
        }

        public Symptom setSeverity(ReactionSeverityEnum theValue) {
            this.getSeverity().setValueAsEnum((Enum)theValue);
            return this;
        }
    }
}

