/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.IResourceBlock;
import ca.uhn.fhir.model.api.TemporalPrecisionEnum;
import ca.uhn.fhir.model.api.annotation.Block;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.valueset.EventTimingEnum;
import ca.uhn.fhir.model.dstu.valueset.UnitsOfTimeEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.DateTimeDt;
import ca.uhn.fhir.model.primitive.DecimalDt;
import ca.uhn.fhir.model.primitive.IntegerDt;
import ca.uhn.fhir.util.ElementUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

@DatatypeDef(name="ScheduleDt")
public class ScheduleDt
extends BaseIdentifiableElement
implements ICompositeDatatype {
    @Child(name="event", type={PeriodDt.class}, order=0, min=0, max=-1)
    @Description(shortDefinition="When the event occurs", formalDefinition="Identifies specific time periods when the event should occur")
    private List<PeriodDt> myEvent;
    @Child(name="repeat", order=1, min=0, max=1)
    @Description(shortDefinition="Only if there is none or one event", formalDefinition="Identifies a repeating pattern to the intended time periods.")
    private Repeat myRepeat;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myEvent, this.myRepeat});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myEvent, this.myRepeat});
    }

    public List<PeriodDt> getEvent() {
        if (this.myEvent == null) {
            this.myEvent = new ArrayList<PeriodDt>();
        }
        return this.myEvent;
    }

    public List<PeriodDt> getEventElement() {
        if (this.myEvent == null) {
            this.myEvent = new ArrayList<PeriodDt>();
        }
        return this.myEvent;
    }

    public ScheduleDt setEvent(List<PeriodDt> theValue) {
        this.myEvent = theValue;
        return this;
    }

    public PeriodDt addEvent() {
        PeriodDt newType = new PeriodDt();
        this.getEvent().add(newType);
        return newType;
    }

    public PeriodDt getEventFirstRep() {
        if (this.getEvent().isEmpty()) {
            return this.addEvent();
        }
        return this.getEvent().get(0);
    }

    public Repeat getRepeat() {
        if (this.myRepeat == null) {
            this.myRepeat = new Repeat();
        }
        return this.myRepeat;
    }

    public Repeat getRepeatElement() {
        if (this.myRepeat == null) {
            this.myRepeat = new Repeat();
        }
        return this.myRepeat;
    }

    public ScheduleDt setRepeat(Repeat theValue) {
        this.myRepeat = theValue;
        return this;
    }

    @Block
    public static class Repeat
    extends BaseIdentifiableElement
    implements IResourceBlock {
        @Child(name="frequency", type={IntegerDt.class}, order=0, min=0, max=1)
        @Description(shortDefinition="Event occurs frequency times per duration", formalDefinition="Indicates how often the event should occur.")
        private IntegerDt myFrequency;
        @Child(name="when", type={CodeDt.class}, order=1, min=0, max=1)
        @Description(shortDefinition="HS | WAKE | AC | ACM | ACD | ACV | PC | PCM | PCD | PCV - common life events", formalDefinition="Identifies the occurrence of daily life that determines timing")
        private BoundCodeDt<EventTimingEnum> myWhen;
        @Child(name="duration", type={DecimalDt.class}, order=2, min=1, max=1)
        @Description(shortDefinition="Repeating or event-related duration", formalDefinition="How long each repetition should last")
        private DecimalDt myDuration;
        @Child(name="units", type={CodeDt.class}, order=3, min=1, max=1)
        @Description(shortDefinition="s | min | h | d | wk | mo | a - unit of time (UCUM)", formalDefinition="The units of time for the duration")
        private BoundCodeDt<UnitsOfTimeEnum> myUnits;
        @Child(name="count", type={IntegerDt.class}, order=4, min=0, max=1)
        @Description(shortDefinition="Number of times to repeat", formalDefinition="A total count of the desired number of repetitions")
        private IntegerDt myCount;
        @Child(name="end", type={DateTimeDt.class}, order=5, min=0, max=1)
        @Description(shortDefinition="When to stop repeats", formalDefinition="When to stop repeating the schedule")
        private DateTimeDt myEnd;

        public boolean isEmpty() {
            return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myFrequency, this.myWhen, this.myDuration, this.myUnits, this.myCount, this.myEnd});
        }

        public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
            return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myFrequency, this.myWhen, this.myDuration, this.myUnits, this.myCount, this.myEnd});
        }

        public IntegerDt getFrequency() {
            if (this.myFrequency == null) {
                this.myFrequency = new IntegerDt();
            }
            return this.myFrequency;
        }

        public IntegerDt getFrequencyElement() {
            if (this.myFrequency == null) {
                this.myFrequency = new IntegerDt();
            }
            return this.myFrequency;
        }

        public Repeat setFrequency(IntegerDt theValue) {
            this.myFrequency = theValue;
            return this;
        }

        public Repeat setFrequency(int theInteger) {
            this.myFrequency = new IntegerDt(theInteger);
            return this;
        }

        public BoundCodeDt<EventTimingEnum> getWhen() {
            if (this.myWhen == null) {
                this.myWhen = new BoundCodeDt(EventTimingEnum.VALUESET_BINDER);
            }
            return this.myWhen;
        }

        public BoundCodeDt<EventTimingEnum> getWhenElement() {
            if (this.myWhen == null) {
                this.myWhen = new BoundCodeDt(EventTimingEnum.VALUESET_BINDER);
            }
            return this.myWhen;
        }

        public Repeat setWhen(BoundCodeDt<EventTimingEnum> theValue) {
            this.myWhen = theValue;
            return this;
        }

        public Repeat setWhen(EventTimingEnum theValue) {
            this.getWhen().setValueAsEnum((Enum)theValue);
            return this;
        }

        public DecimalDt getDuration() {
            if (this.myDuration == null) {
                this.myDuration = new DecimalDt();
            }
            return this.myDuration;
        }

        public DecimalDt getDurationElement() {
            if (this.myDuration == null) {
                this.myDuration = new DecimalDt();
            }
            return this.myDuration;
        }

        public Repeat setDuration(DecimalDt theValue) {
            this.myDuration = theValue;
            return this;
        }

        public Repeat setDuration(long theValue) {
            this.myDuration = new DecimalDt(theValue);
            return this;
        }

        public Repeat setDuration(double theValue) {
            this.myDuration = new DecimalDt(theValue);
            return this;
        }

        public Repeat setDuration(BigDecimal theValue) {
            this.myDuration = new DecimalDt(theValue);
            return this;
        }

        public BoundCodeDt<UnitsOfTimeEnum> getUnits() {
            if (this.myUnits == null) {
                this.myUnits = new BoundCodeDt(UnitsOfTimeEnum.VALUESET_BINDER);
            }
            return this.myUnits;
        }

        public BoundCodeDt<UnitsOfTimeEnum> getUnitsElement() {
            if (this.myUnits == null) {
                this.myUnits = new BoundCodeDt(UnitsOfTimeEnum.VALUESET_BINDER);
            }
            return this.myUnits;
        }

        public Repeat setUnits(BoundCodeDt<UnitsOfTimeEnum> theValue) {
            this.myUnits = theValue;
            return this;
        }

        public Repeat setUnits(UnitsOfTimeEnum theValue) {
            this.getUnits().setValueAsEnum((Enum)theValue);
            return this;
        }

        public IntegerDt getCount() {
            if (this.myCount == null) {
                this.myCount = new IntegerDt();
            }
            return this.myCount;
        }

        public IntegerDt getCountElement() {
            if (this.myCount == null) {
                this.myCount = new IntegerDt();
            }
            return this.myCount;
        }

        public Repeat setCount(IntegerDt theValue) {
            this.myCount = theValue;
            return this;
        }

        public Repeat setCount(int theInteger) {
            this.myCount = new IntegerDt(theInteger);
            return this;
        }

        public DateTimeDt getEnd() {
            if (this.myEnd == null) {
                this.myEnd = new DateTimeDt();
            }
            return this.myEnd;
        }

        public DateTimeDt getEndElement() {
            if (this.myEnd == null) {
                this.myEnd = new DateTimeDt();
            }
            return this.myEnd;
        }

        public Repeat setEnd(DateTimeDt theValue) {
            this.myEnd = theValue;
            return this;
        }

        public Repeat setEnd(Date theDate, TemporalPrecisionEnum thePrecision) {
            this.myEnd = new DateTimeDt(theDate, thePrecision);
            return this;
        }

        public Repeat setEndWithSecondsPrecision(Date theDate) {
            this.myEnd = new DateTimeDt(theDate);
            return this;
        }
    }
}

