/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.dstu.composite.QuantityDt;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;

@DatatypeDef(name="RatioDt")
public class RatioDt
extends BaseIdentifiableElement
implements ICompositeDatatype {
    @Child(name="numerator", type={QuantityDt.class}, order=0, min=0, max=1)
    @Description(shortDefinition="Numerator value", formalDefinition="The value of the numerator")
    private QuantityDt myNumerator;
    @Child(name="denominator", type={QuantityDt.class}, order=1, min=0, max=1)
    @Description(shortDefinition="Denominator value", formalDefinition="The value of the denominator")
    private QuantityDt myDenominator;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myNumerator, this.myDenominator});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myNumerator, this.myDenominator});
    }

    public QuantityDt getNumerator() {
        if (this.myNumerator == null) {
            this.myNumerator = new QuantityDt();
        }
        return this.myNumerator;
    }

    public QuantityDt getNumeratorElement() {
        if (this.myNumerator == null) {
            this.myNumerator = new QuantityDt();
        }
        return this.myNumerator;
    }

    public RatioDt setNumerator(QuantityDt theValue) {
        this.myNumerator = theValue;
        return this;
    }

    public RatioDt setNumerator(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
        this.myNumerator = new QuantityDt(theComparator, theValue, theUnits);
        return this;
    }

    public RatioDt setNumerator(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
        this.myNumerator = new QuantityDt(theComparator, theValue, theUnits);
        return this;
    }

    public RatioDt setNumerator(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
        this.myNumerator = new QuantityDt(theComparator, theValue, theSystem, theUnits);
        return this;
    }

    public RatioDt setNumerator(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
        this.myNumerator = new QuantityDt(theComparator, theValue, theSystem, theUnits);
        return this;
    }

    public RatioDt setNumerator(double theValue) {
        this.myNumerator = new QuantityDt(theValue);
        return this;
    }

    public RatioDt setNumerator(long theValue) {
        this.myNumerator = new QuantityDt(theValue);
        return this;
    }

    public QuantityDt getDenominator() {
        if (this.myDenominator == null) {
            this.myDenominator = new QuantityDt();
        }
        return this.myDenominator;
    }

    public QuantityDt getDenominatorElement() {
        if (this.myDenominator == null) {
            this.myDenominator = new QuantityDt();
        }
        return this.myDenominator;
    }

    public RatioDt setDenominator(QuantityDt theValue) {
        this.myDenominator = theValue;
        return this;
    }

    public RatioDt setDenominator(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
        this.myDenominator = new QuantityDt(theComparator, theValue, theUnits);
        return this;
    }

    public RatioDt setDenominator(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
        this.myDenominator = new QuantityDt(theComparator, theValue, theUnits);
        return this;
    }

    public RatioDt setDenominator(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
        this.myDenominator = new QuantityDt(theComparator, theValue, theSystem, theUnits);
        return this;
    }

    public RatioDt setDenominator(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
        this.myDenominator = new QuantityDt(theComparator, theValue, theSystem, theUnits);
        return this;
    }

    public RatioDt setDenominator(double theValue) {
        this.myDenominator = new QuantityDt(theValue);
        return this;
    }

    public RatioDt setDenominator(long theValue) {
        this.myDenominator = new QuantityDt(theValue);
        return this;
    }
}

