/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.composite;

import ca.uhn.fhir.model.api.BaseIdentifiableElement;
import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.dstu.composite.QuantityDt;
import ca.uhn.fhir.model.dstu.valueset.QuantityCompararatorEnum;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;

@DatatypeDef(name="RangeDt")
public class RangeDt
extends BaseIdentifiableElement
implements ICompositeDatatype {
    @Child(name="low", type={QuantityDt.class}, order=0, min=0, max=1)
    @Description(shortDefinition="Low limit", formalDefinition="The low limit. The boundary is inclusive.")
    private QuantityDt myLow;
    @Child(name="high", type={QuantityDt.class}, order=1, min=0, max=1)
    @Description(shortDefinition="High limit", formalDefinition="The high limit. The boundary is inclusive.")
    private QuantityDt myHigh;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myLow, this.myHigh});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myLow, this.myHigh});
    }

    public QuantityDt getLow() {
        if (this.myLow == null) {
            this.myLow = new QuantityDt();
        }
        return this.myLow;
    }

    public QuantityDt getLowElement() {
        if (this.myLow == null) {
            this.myLow = new QuantityDt();
        }
        return this.myLow;
    }

    public RangeDt setLow(QuantityDt theValue) {
        this.myLow = theValue;
        return this;
    }

    public RangeDt setLow(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
        this.myLow = new QuantityDt(theComparator, theValue, theUnits);
        return this;
    }

    public RangeDt setLow(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
        this.myLow = new QuantityDt(theComparator, theValue, theUnits);
        return this;
    }

    public RangeDt setLow(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
        this.myLow = new QuantityDt(theComparator, theValue, theSystem, theUnits);
        return this;
    }

    public RangeDt setLow(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
        this.myLow = new QuantityDt(theComparator, theValue, theSystem, theUnits);
        return this;
    }

    public RangeDt setLow(double theValue) {
        this.myLow = new QuantityDt(theValue);
        return this;
    }

    public RangeDt setLow(long theValue) {
        this.myLow = new QuantityDt(theValue);
        return this;
    }

    public QuantityDt getHigh() {
        if (this.myHigh == null) {
            this.myHigh = new QuantityDt();
        }
        return this.myHigh;
    }

    public QuantityDt getHighElement() {
        if (this.myHigh == null) {
            this.myHigh = new QuantityDt();
        }
        return this.myHigh;
    }

    public RangeDt setHigh(QuantityDt theValue) {
        this.myHigh = theValue;
        return this;
    }

    public RangeDt setHigh(QuantityCompararatorEnum theComparator, double theValue, String theUnits) {
        this.myHigh = new QuantityDt(theComparator, theValue, theUnits);
        return this;
    }

    public RangeDt setHigh(QuantityCompararatorEnum theComparator, long theValue, String theUnits) {
        this.myHigh = new QuantityDt(theComparator, theValue, theUnits);
        return this;
    }

    public RangeDt setHigh(QuantityCompararatorEnum theComparator, double theValue, String theSystem, String theUnits) {
        this.myHigh = new QuantityDt(theComparator, theValue, theSystem, theUnits);
        return this;
    }

    public RangeDt setHigh(QuantityCompararatorEnum theComparator, long theValue, String theSystem, String theUnits) {
        this.myHigh = new QuantityDt(theComparator, theValue, theSystem, theUnits);
        return this;
    }

    public RangeDt setHigh(double theValue) {
        this.myHigh = new QuantityDt(theValue);
        return this;
    }

    public RangeDt setHigh(long theValue) {
        this.myHigh = new QuantityDt(theValue);
        return this;
    }
}

