/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.composite;

import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.api.annotation.SimpleSetter;
import ca.uhn.fhir.model.base.composite.BaseIdentifierDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.composite.ResourceReferenceDt;
import ca.uhn.fhir.model.dstu.resource.Organization;
import ca.uhn.fhir.model.dstu.valueset.IdentifierUseEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.model.primitive.UriDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.List;

@DatatypeDef(name="IdentifierDt")
public class IdentifierDt
extends BaseIdentifierDt
implements ICompositeDatatype {
    @Child(name="use", type={CodeDt.class}, order=0, min=0, max=1)
    @Description(shortDefinition="usual | official | temp | secondary (If known)", formalDefinition="The purpose of this identifier")
    private BoundCodeDt<IdentifierUseEnum> myUse;
    @Child(name="label", type={StringDt.class}, order=1, min=0, max=1)
    @Description(shortDefinition="Description of identifier", formalDefinition="A text string for the identifier that can be displayed to a human so they can recognize the identifier")
    private StringDt myLabel;
    @Child(name="system", type={UriDt.class}, order=2, min=0, max=1)
    @Description(shortDefinition="The namespace for the identifier", formalDefinition="Establishes the namespace in which set of possible id values is unique.")
    private UriDt mySystem;
    @Child(name="value", type={StringDt.class}, order=3, min=0, max=1)
    @Description(shortDefinition="The value that is unique", formalDefinition="The portion of the identifier typically displayed to the user and which is unique within the context of the system.")
    private StringDt myValue;
    @Child(name="period", type={PeriodDt.class}, order=4, min=0, max=1)
    @Description(shortDefinition="Time period when id is/was valid for use", formalDefinition="Time period during which identifier is/was valid for use")
    private PeriodDt myPeriod;
    @Child(name="assigner", order=5, min=0, max=1, type={Organization.class})
    @Description(shortDefinition="Organization that issued id (may be just text)", formalDefinition="Organization that issued/manages the identifier")
    private ResourceReferenceDt myAssigner;

    public IdentifierDt() {
    }

    @SimpleSetter
    public IdentifierDt(@SimpleSetter.Parameter(name="theSystem") String theSystem, @SimpleSetter.Parameter(name="theValue") String theValue) {
        this.setSystem(theSystem);
        this.setValue(theValue);
    }

    @SimpleSetter
    public IdentifierDt(@SimpleSetter.Parameter(name="theUse") IdentifierUseEnum theUse, @SimpleSetter.Parameter(name="theSystem") String theSystem, @SimpleSetter.Parameter(name="theValue") String theValue, @SimpleSetter.Parameter(name="theLabel") String theLabel) {
        this.setUse(theUse);
        this.setSystem(theSystem);
        this.setValue(theValue);
        this.setLabel(theLabel);
    }

    public String toString() {
        return "IdentifierDt[" + this.getValueAsQueryToken() + "]";
    }

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((IElement[])new IElement[]{this.myUse, this.myLabel, this.mySystem, this.myValue, this.myPeriod, this.myAssigner});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myUse, this.myLabel, this.mySystem, this.myValue, this.myPeriod, this.myAssigner});
    }

    public BoundCodeDt<IdentifierUseEnum> getUse() {
        if (this.myUse == null) {
            this.myUse = new BoundCodeDt(IdentifierUseEnum.VALUESET_BINDER);
        }
        return this.myUse;
    }

    public BoundCodeDt<IdentifierUseEnum> getUseElement() {
        if (this.myUse == null) {
            this.myUse = new BoundCodeDt(IdentifierUseEnum.VALUESET_BINDER);
        }
        return this.myUse;
    }

    public IdentifierDt setUse(BoundCodeDt<IdentifierUseEnum> theValue) {
        this.myUse = theValue;
        return this;
    }

    public IdentifierDt setUse(IdentifierUseEnum theValue) {
        this.getUse().setValueAsEnum((Enum)theValue);
        return this;
    }

    public StringDt getLabel() {
        if (this.myLabel == null) {
            this.myLabel = new StringDt();
        }
        return this.myLabel;
    }

    public StringDt getLabelElement() {
        if (this.myLabel == null) {
            this.myLabel = new StringDt();
        }
        return this.myLabel;
    }

    public IdentifierDt setLabel(StringDt theValue) {
        this.myLabel = theValue;
        return this;
    }

    public IdentifierDt setLabel(String theString) {
        this.myLabel = new StringDt(theString);
        return this;
    }

    public UriDt getSystem() {
        if (this.mySystem == null) {
            this.mySystem = new UriDt();
        }
        return this.mySystem;
    }

    public UriDt getSystemElement() {
        if (this.mySystem == null) {
            this.mySystem = new UriDt();
        }
        return this.mySystem;
    }

    public IdentifierDt setSystem(UriDt theValue) {
        this.mySystem = theValue;
        return this;
    }

    public IdentifierDt setSystem(String theUri) {
        this.mySystem = new UriDt(theUri);
        return this;
    }

    public StringDt getValue() {
        if (this.myValue == null) {
            this.myValue = new StringDt();
        }
        return this.myValue;
    }

    public StringDt getValueElement() {
        if (this.myValue == null) {
            this.myValue = new StringDt();
        }
        return this.myValue;
    }

    public IdentifierDt setValue(StringDt theValue) {
        this.myValue = theValue;
        return this;
    }

    public IdentifierDt setValue(String theString) {
        this.myValue = new StringDt(theString);
        return this;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public PeriodDt getPeriodElement() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public IdentifierDt setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }

    public ResourceReferenceDt getAssigner() {
        if (this.myAssigner == null) {
            this.myAssigner = new ResourceReferenceDt();
        }
        return this.myAssigner;
    }

    public ResourceReferenceDt getAssignerElement() {
        if (this.myAssigner == null) {
            this.myAssigner = new ResourceReferenceDt();
        }
        return this.myAssigner;
    }

    public IdentifierDt setAssigner(ResourceReferenceDt theValue) {
        this.myAssigner = theValue;
        return this;
    }
}

