/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.fhir.model.dstu.composite;

import ca.uhn.fhir.model.api.ICompositeDatatype;
import ca.uhn.fhir.model.api.IElement;
import ca.uhn.fhir.model.api.annotation.Child;
import ca.uhn.fhir.model.api.annotation.DatatypeDef;
import ca.uhn.fhir.model.api.annotation.Description;
import ca.uhn.fhir.model.base.composite.BaseHumanNameDt;
import ca.uhn.fhir.model.dstu.composite.PeriodDt;
import ca.uhn.fhir.model.dstu.valueset.NameUseEnum;
import ca.uhn.fhir.model.primitive.BoundCodeDt;
import ca.uhn.fhir.model.primitive.CodeDt;
import ca.uhn.fhir.model.primitive.StringDt;
import ca.uhn.fhir.util.ElementUtil;
import java.util.ArrayList;
import java.util.List;

@DatatypeDef(name="HumanNameDt")
public class HumanNameDt
extends BaseHumanNameDt
implements ICompositeDatatype {
    @Child(name="use", type={CodeDt.class}, order=0, min=0, max=1)
    @Description(shortDefinition="usual | official | temp | nickname | anonymous | old | maiden", formalDefinition="Identifies the purpose for this name")
    private BoundCodeDt<NameUseEnum> myUse;
    @Child(name="text", type={StringDt.class}, order=1, min=0, max=1)
    @Description(shortDefinition="Text representation of the full name", formalDefinition="A full text representation of the name")
    private StringDt myText;
    @Child(name="family", type={StringDt.class}, order=2, min=0, max=-1)
    @Description(shortDefinition="Family name (often called 'Surname')", formalDefinition="The part of a name that links to the genealogy. In some cultures (e.g. Eritrea) the family name of a son is the first name of his father.")
    private List<StringDt> myFamily;
    @Child(name="given", type={StringDt.class}, order=3, min=0, max=-1)
    @Description(shortDefinition="Given names (not always 'first'). Includes middle names", formalDefinition="Given name")
    private List<StringDt> myGiven;
    @Child(name="prefix", type={StringDt.class}, order=4, min=0, max=-1)
    @Description(shortDefinition="Parts that come before the name", formalDefinition="Part of the name that is acquired as a title due to academic, legal, employment or nobility status, etc. and that appears at the start of the name")
    private List<StringDt> myPrefix;
    @Child(name="suffix", type={StringDt.class}, order=5, min=0, max=-1)
    @Description(shortDefinition="Parts that come after the name", formalDefinition="Part of the name that is acquired as a title due to academic, legal, employment or nobility status, etc. and that appears at the end of the name")
    private List<StringDt> mySuffix;
    @Child(name="period", type={PeriodDt.class}, order=6, min=0, max=1)
    @Description(shortDefinition="Time period when name was/is in use", formalDefinition="Indicates the period of time when this name was valid for the named person.")
    private PeriodDt myPeriod;

    public boolean isEmpty() {
        return super.isBaseEmpty() && ElementUtil.isEmpty((Object[])new Object[]{this.myUse, this.myText, this.myFamily, this.myGiven, this.myPrefix, this.mySuffix, this.myPeriod});
    }

    public <T extends IElement> List<T> getAllPopulatedChildElementsOfType(Class<T> theType) {
        return ElementUtil.allPopulatedChildElements(theType, (Object[])new Object[]{this.myUse, this.myText, this.myFamily, this.myGiven, this.myPrefix, this.mySuffix, this.myPeriod});
    }

    public BoundCodeDt<NameUseEnum> getUse() {
        if (this.myUse == null) {
            this.myUse = new BoundCodeDt(NameUseEnum.VALUESET_BINDER);
        }
        return this.myUse;
    }

    public BoundCodeDt<NameUseEnum> getUseElement() {
        if (this.myUse == null) {
            this.myUse = new BoundCodeDt(NameUseEnum.VALUESET_BINDER);
        }
        return this.myUse;
    }

    public HumanNameDt setUse(BoundCodeDt<NameUseEnum> theValue) {
        this.myUse = theValue;
        return this;
    }

    public HumanNameDt setUse(NameUseEnum theValue) {
        this.getUse().setValueAsEnum((Enum)theValue);
        return this;
    }

    public StringDt getText() {
        if (this.myText == null) {
            this.myText = new StringDt();
        }
        return this.myText;
    }

    public StringDt getTextElement() {
        if (this.myText == null) {
            this.myText = new StringDt();
        }
        return this.myText;
    }

    public HumanNameDt setText(StringDt theValue) {
        this.myText = theValue;
        return this;
    }

    public HumanNameDt setText(String theString) {
        this.myText = new StringDt(theString);
        return this;
    }

    public List<StringDt> getFamily() {
        if (this.myFamily == null) {
            this.myFamily = new ArrayList<StringDt>();
        }
        return this.myFamily;
    }

    public List<StringDt> getFamilyElement() {
        if (this.myFamily == null) {
            this.myFamily = new ArrayList<StringDt>();
        }
        return this.myFamily;
    }

    public HumanNameDt setFamily(List<StringDt> theValue) {
        this.myFamily = theValue;
        return this;
    }

    public StringDt addFamily() {
        StringDt newType = new StringDt();
        this.getFamily().add(newType);
        return newType;
    }

    public StringDt getFamilyFirstRep() {
        if (this.getFamily().isEmpty()) {
            return this.addFamily();
        }
        return this.getFamily().get(0);
    }

    public HumanNameDt addFamily(String theString) {
        if (this.myFamily == null) {
            this.myFamily = new ArrayList<StringDt>();
        }
        this.myFamily.add(new StringDt(theString));
        return this;
    }

    public List<StringDt> getGiven() {
        if (this.myGiven == null) {
            this.myGiven = new ArrayList<StringDt>();
        }
        return this.myGiven;
    }

    public List<StringDt> getGivenElement() {
        if (this.myGiven == null) {
            this.myGiven = new ArrayList<StringDt>();
        }
        return this.myGiven;
    }

    public HumanNameDt setGiven(List<StringDt> theValue) {
        this.myGiven = theValue;
        return this;
    }

    public StringDt addGiven() {
        StringDt newType = new StringDt();
        this.getGiven().add(newType);
        return newType;
    }

    public StringDt getGivenFirstRep() {
        if (this.getGiven().isEmpty()) {
            return this.addGiven();
        }
        return this.getGiven().get(0);
    }

    public HumanNameDt addGiven(String theString) {
        if (this.myGiven == null) {
            this.myGiven = new ArrayList<StringDt>();
        }
        this.myGiven.add(new StringDt(theString));
        return this;
    }

    public List<StringDt> getPrefix() {
        if (this.myPrefix == null) {
            this.myPrefix = new ArrayList<StringDt>();
        }
        return this.myPrefix;
    }

    public List<StringDt> getPrefixElement() {
        if (this.myPrefix == null) {
            this.myPrefix = new ArrayList<StringDt>();
        }
        return this.myPrefix;
    }

    public HumanNameDt setPrefix(List<StringDt> theValue) {
        this.myPrefix = theValue;
        return this;
    }

    public StringDt addPrefix() {
        StringDt newType = new StringDt();
        this.getPrefix().add(newType);
        return newType;
    }

    public StringDt getPrefixFirstRep() {
        if (this.getPrefix().isEmpty()) {
            return this.addPrefix();
        }
        return this.getPrefix().get(0);
    }

    public HumanNameDt addPrefix(String theString) {
        if (this.myPrefix == null) {
            this.myPrefix = new ArrayList<StringDt>();
        }
        this.myPrefix.add(new StringDt(theString));
        return this;
    }

    public List<StringDt> getSuffix() {
        if (this.mySuffix == null) {
            this.mySuffix = new ArrayList<StringDt>();
        }
        return this.mySuffix;
    }

    public List<StringDt> getSuffixElement() {
        if (this.mySuffix == null) {
            this.mySuffix = new ArrayList<StringDt>();
        }
        return this.mySuffix;
    }

    public HumanNameDt setSuffix(List<StringDt> theValue) {
        this.mySuffix = theValue;
        return this;
    }

    public StringDt addSuffix() {
        StringDt newType = new StringDt();
        this.getSuffix().add(newType);
        return newType;
    }

    public StringDt getSuffixFirstRep() {
        if (this.getSuffix().isEmpty()) {
            return this.addSuffix();
        }
        return this.getSuffix().get(0);
    }

    public HumanNameDt addSuffix(String theString) {
        if (this.mySuffix == null) {
            this.mySuffix = new ArrayList<StringDt>();
        }
        this.mySuffix.add(new StringDt(theString));
        return this;
    }

    public PeriodDt getPeriod() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public PeriodDt getPeriodElement() {
        if (this.myPeriod == null) {
            this.myPeriod = new PeriodDt();
        }
        return this.myPeriod;
    }

    public HumanNameDt setPeriod(PeriodDt theValue) {
        this.myPeriod = theValue;
        return this;
    }
}

